/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public abstract class Padding {
    private String b;
    protected int a;

    protected Padding(String string, int n2) {
        this.b = string;
        this.a = n2;
    }

    public byte[] pad(byte[] byArray) throws IllegalBlockSizeException {
        if (byArray.length % this.a == 0) {
            return byArray;
        }
        byte[] byArray2 = Padding.expand(byArray, byArray.length + this.padLength(byArray.length));
        try {
            this.pad(byArray2, 0, byArray.length);
        }
        catch (ShortBufferException shortBufferException) {
            throw new Error(shortBufferException.toString());
        }
        return byArray2;
    }

    public abstract int pad(byte[] var1, int var2, int var3) throws ShortBufferException, IllegalBlockSizeException;

    public abstract int unpad(byte[] var1, int var2, int var3) throws BadPaddingException, ShortBufferException;

    public int padLength(int n2) {
        int n3 = this.a - n2 % this.a;
        return n3;
    }

    public String paddingScheme() {
        return this.b;
    }

    public static byte[] expand(byte[] byArray, int n2) {
        if (byArray != null && byArray.length >= n2) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }
}

