/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.rsa;

import com.certicom.ecc.rsa.RSADP;
import com.certicom.ecc.rsa.RSAEP;
import com.certicom.ecc.rsa.RSAException;
import com.certicom.ecc.rsa.RSAPrimitive;
import com.certicom.ecc.rsa.RSAPrivateKey;
import com.certicom.ecc.rsa.RSAPublicKey;
import com.certicom.ecc.rsa.outputSizeSelectable;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.util.Conversion;
import com.certicom.ecc.util.ConversionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public final class RSA
extends CryptoTransform
implements Serializable {
    private static final long serialVersionUID = -7085527673950540321L;
    private RSAPrimitive a;
    private CryptoTransform b;
    private int c;
    private byte[] d;
    private boolean e;

    public RSA() {
        super("RSA");
    }

    public void reset() {
        super.reset();
        if (this.a != null) {
            this.a.reset();
        }
        if (this.b != null) {
            this.b.reset();
        }
        this.c = 0;
        this.d = null;
        this.e = false;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.reset();
        super.init(n2, objectArray, random);
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            this.reset();
            throw new IllegalArgumentException("wrong mode");
        }
        if (objectArray != null && objectArray.length >= 2) {
            String string = (String)objectArray[1];
            if (string.equals("RawExpRsa")) {
                this.e = true;
            }
            if (this.e && (n2 == 1 || n2 == 2)) {
                this.reset();
                throw new IllegalArgumentException("rawExpRsa supports only encrypt/decrypt");
            }
            boolean bl = objectArray[0] instanceof RSAPublicKey;
            if (n2 == 1 && bl) {
                this.reset();
                throw new IllegalArgumentException("wrong key for sign.");
            }
            if (n2 == 2 && !bl) {
                this.reset();
                throw new IllegalArgumentException("wrong key for verify.");
            }
            if (bl) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)objectArray[0];
                if (!(this.a instanceof RSAEP)) {
                    this.a = new RSAEP(rSAPublicKey);
                } else {
                    this.a.setKey(rSAPublicKey);
                }
                this.c = rSAPublicKey.n().bitLength() + 7 >>> 3;
            } else {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)objectArray[0];
                if (!(this.a instanceof RSADP)) {
                    this.a = new RSADP(rSAPrivateKey);
                } else {
                    this.a.setKey(rSAPrivateKey);
                }
                this.c = rSAPrivateKey.hasExponents() ? rSAPrivateKey.n().bitLength() + 7 >>> 3 : rSAPrivateKey.p().multiply(rSAPrivateKey.q()).bitLength() + 7 >>> 3;
            }
            if (this.e) {
                return;
            }
            if (this.b == null || !this.b.getAlgorithm().equals(string)) {
                this.b = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, (String)objectArray[1]);
            }
            Object[] objectArray2 = null;
            if (objectArray.length >= 3) {
                objectArray2 = (Object[])objectArray[2];
            }
            this.b.init(5, objectArray2, random);
        }
    }

    public int inputSize() {
        if (this.h == 3 || this.h == 4) {
            if (this.e) {
                return this.c;
            }
            if (this.b instanceof outputSizeSelectable) {
                return ((outputSizeSelectable)((Object)this.b)).maxIn(this.c - 1);
            }
            return this.c;
        }
        if (this.h == 1 || this.h == 2) {
            return 0;
        }
        throw new IllegalStateException("wrong mode.");
    }

    public int outputSize(int n2, boolean bl) {
        if (this.h == 3 || this.h == 1 && bl) {
            return this.c;
        }
        if (this.h == 4) {
            if (this.e) {
                return this.c;
            }
            return this.b.outputSize(this.c - 1, true);
        }
        if (this.h == 2 || this.h == 1 && !bl) {
            return 0;
        }
        throw new IllegalStateException("wrong mode");
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.h == 3 || this.h == 4 || this.h == 1 || this.h == 2) {
            int n5;
            if (this.e) {
                if (byArray == null || n3 != this.c) {
                    throw new IllegalArgumentException("in size != modulus size.");
                }
                if (byArray2 == null || byArray2.length - n4 != this.c) {
                    throw new IllegalArgumentException("out size != modulus size");
                }
                byte[] byArray3 = new byte[this.c];
                System.arraycopy(byArray, n2, byArray3, 0, this.c);
                try {
                    byArray3 = this.a(byArray3, this.c);
                }
                catch (ConversionException conversionException) {
                    throw new IllegalArgumentException(conversionException.getMessage());
                }
                catch (RSAException rSAException) {
                    throw new IllegalArgumentException(rSAException.getMessage());
                }
                System.arraycopy(byArray3, 0, byArray2, n4, this.c);
                return this.c;
            }
            byte[] byArray4 = null;
            if (!(bl || this.h != 3 && this.h != 4)) {
                throw new IllegalArgumentException("ENC/DEC not incremental");
            }
            if (this.h != 4) {
                if (bl) {
                    byArray4 = new byte[this.c - 1];
                }
                try {
                    this.b.transform(byArray, n2, n3, byArray4, 0, bl);
                    if (this.h == 2 && bl) {
                        this.d = byArray4;
                        return 0;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.h != 2) {
                        throw illegalArgumentException;
                    }
                    return 0;
                }
                if (!bl) {
                    return 0;
                }
                n5 = this.c;
            } else {
                byArray4 = new byte[n3];
                System.arraycopy(byArray, n2, byArray4, 0, byArray4.length);
                n5 = this.c - 1;
            }
            try {
                byArray4 = this.a(byArray4, n5);
            }
            catch (ConversionException conversionException) {
                throw new IllegalArgumentException(conversionException.getMessage());
            }
            catch (RSAException rSAException) {
                throw new IllegalArgumentException(rSAException.getMessage());
            }
            if (this.h == 4) {
                byArray4 = this.b.transform(byArray4, 0, byArray4.length, true);
            }
            System.arraycopy(byArray4, 0, byArray2, n4, byArray4.length);
            return byArray4.length;
        }
        throw new IllegalStateException("wrong mode");
    }

    public boolean verify(byte[] byArray, int n2, int n3) {
        try {
            int n4;
            if (this.h != 2) {
                throw new IllegalStateException("wrong mode");
            }
            if (n3 != this.c || this.d == null) {
                return false;
            }
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            byte[] byArray3 = this.a(byArray2, this.c - 1);
            if (this.d.length != byArray3.length) {
                return false;
            }
            for (n4 = 0; n4 < this.d.length && this.d[n4] == byArray3[n4]; ++n4) {
            }
            return n4 == this.d.length;
        }
        catch (ConversionException conversionException) {
            return false;
        }
        catch (RSAException rSAException) {
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private byte[] a(byte[] byArray, int n2) throws ConversionException, RSAException {
        BigInteger bigInteger = Conversion.OS2IP(byArray);
        BigInteger bigInteger2 = this.a.calc(bigInteger);
        return Conversion.I2OSP(bigInteger2, n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(new Integer(this.c));
        objectOutputStream.writeObject(this.d);
        objectOutputStream.writeObject(new Boolean(this.e));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (RSAPrimitive)objectInputStream.readObject();
        this.b = (CryptoTransform)objectInputStream.readObject();
        this.c = (Integer)objectInputStream.readObject();
        this.d = (byte[])objectInputStream.readObject();
        this.e = (Boolean)objectInputStream.readObject();
    }
}

