/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.rsa.RSAPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class RSAKeyFactorySpi
extends KeyFactorySpi {
    private static final Class h = a == null ? (a = RSAKeyFactorySpi.a("java.security.spec.RSAPrivateCrtKeySpec")) : a;
    private static final Class i = b == null ? (b = RSAKeyFactorySpi.a("java.security.spec.RSAPrivateKeySpec")) : b;
    private static final Class j = c == null ? (c = RSAKeyFactorySpi.a("java.security.spec.RSAPublicKeySpec")) : c;
    private static final Class k = d == null ? (d = RSAKeyFactorySpi.a("java.security.spec.PKCS8EncodedKeySpec")) : d;
    private static final Class l = e == null ? (e = RSAKeyFactorySpi.a("java.security.spec.X509EncodedKeySpec")) : e;
    private static final Class m = f == null ? (f = RSAKeyFactorySpi.a("com.certicom.ecc.rsa.RSAPublicKey")) : f;
    private static final Class n = g == null ? (g = RSAKeyFactorySpi.a("com.certicom.ecc.rsa.RSAPrivateKey")) : g;
    private CryptoTransform o = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "RSAKEYFAC");
    static Class a;
    static Class b;
    static Class c;
    static Class d;
    static Class e;
    static Class f;
    static Class g;

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            return new _RSAPrivateKey((RSAPrivateCrtKeySpec)keySpec);
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            return new _RSANDPrivateKey((RSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            this.o.init(5, new Object[]{n}, null);
            com.certicom.ecc.rsa.RSAPrivateKey rSAPrivateKey = (com.certicom.ecc.rsa.RSAPrivateKey)this.o.transformToObject(byArray, 0, byArray.length, true);
            if (rSAPrivateKey.hasCRT()) {
                return new _RSAPrivateKey(rSAPrivateKey);
            }
            return new _RSANDPrivateKey(rSAPrivateKey);
        }
        throw new InvalidKeySpecException("does not support " + keySpec.getClass().getName());
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            return new _RSAPublicKey((RSAPublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
            this.o.init(5, new Object[]{m}, null);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)this.o.transformToObject(byArray, 0, byArray.length, true);
            return new _RSAPublicKey(rSAPublicKey);
        }
        throw new InvalidKeySpecException("does not support " + keySpec.getClass().getName());
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        Key key2;
        try {
            key2 = RSAKeyFactorySpi.a(key, false);
            if (key2 != null) {
                key = key2;
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            if (j.isAssignableFrom(clazz)) {
                key2 = (java.security.interfaces.RSAPublicKey)key;
                return new RSAPublicKeySpec(key2.getModulus(), key2.getPublicExponent());
            }
            if (l.isAssignableFrom(clazz)) {
                return new X509EncodedKeySpec(((java.security.interfaces.RSAPublicKey)key).getEncoded());
            }
        } else if (key instanceof RSAPrivateKey) {
            key2 = (RSAPrivateKey)key;
            if (k.isAssignableFrom(clazz)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
            if (clazz.isAssignableFrom(h) && key2 instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key2;
                return new RSAPrivateCrtKeySpec(key2.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            }
            if (clazz.isAssignableFrom(i)) {
                return new RSAPrivateKeySpec(key2.getModulus(), key2.getPrivateExponent());
            }
        }
        throw new InvalidKeySpecException("Cannot use " + key.getClass().getName() + " with " + clazz.getName());
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        return RSAKeyFactorySpi.a(key, true);
    }

    static Key a(Key key, boolean bl) throws InvalidKeyException {
        if (key instanceof PrivateKey) {
            return RSAKeyFactorySpi.a((PrivateKey)key, bl);
        }
        if (key instanceof PublicKey) {
            return RSAKeyFactorySpi.a((PublicKey)key, bl);
        }
        if (bl) {
            RSAKeyFactorySpi.a(key);
        }
        return null;
    }

    static PrivateKey a(PrivateKey privateKey, boolean bl) throws InvalidKeyException {
        if (privateKey instanceof _RSAPrivateKey) {
            return privateKey;
        }
        if (privateKey instanceof _RSANDPrivateKey) {
            return privateKey;
        }
        if (privateKey instanceof RSAPrivateCrtKey) {
            return new _RSAPrivateKey((RSAPrivateCrtKey)privateKey);
        }
        if (privateKey instanceof RSAPrivateKey) {
            return new _RSANDPrivateKey((RSAPrivateKey)privateKey);
        }
        if (bl) {
            RSAKeyFactorySpi.a(privateKey);
        }
        return null;
    }

    private static void a(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("invalid key" + key.getClass().getName());
    }

    static PublicKey a(PublicKey publicKey, boolean bl) throws InvalidKeyException {
        if (publicKey instanceof _RSAPublicKey) {
            return publicKey;
        }
        if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            return new _RSAPublicKey((java.security.interfaces.RSAPublicKey)publicKey);
        }
        if (bl) {
            RSAKeyFactorySpi.a(publicKey);
        }
        return null;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class _RSAPublicKey
    extends RSAPublicKey
    implements Serializable,
    java.security.interfaces.RSAPublicKey {
        private static final long serialVersionUID = -7360894886751592889L;

        public _RSAPublicKey() {
        }

        protected _RSAPublicKey(RSAPublicKey rSAPublicKey) {
            super(rSAPublicKey.n(), rSAPublicKey.e());
        }

        protected _RSAPublicKey(java.security.interfaces.RSAPublicKey rSAPublicKey) {
            super(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }

        protected _RSAPublicKey(RSAPublicKeySpec rSAPublicKeySpec) {
            super(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
        }

        public BigInteger getModulus() {
            return this.n();
        }

        public BigInteger getPublicExponent() {
            return this.e();
        }

        public String getFormat() {
            return "X.509";
        }

        public String getAlgorithm() {
            return "RSA";
        }

        public byte[] getEncoded() {
            return super.getEncoded();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.getModulus());
            objectOutputStream.writeObject(this.getPublicExponent());
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.a((BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject());
        }
    }

    static class _RSAPrivateKey
    extends com.certicom.ecc.rsa.RSAPrivateKey
    implements Serializable,
    RSAPrivateCrtKey {
        public static final long serialVersionUID = -4169734952205230041L;

        public _RSAPrivateKey() {
        }

        protected _RSAPrivateKey(RSAPrivateCrtKey rSAPrivateCrtKey) {
            super(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
        }

        protected _RSAPrivateKey(RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec) {
            super(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
        }

        protected _RSAPrivateKey(com.certicom.ecc.rsa.RSAPrivateKey rSAPrivateKey) {
            super(rSAPrivateKey.n(), rSAPrivateKey.e(), rSAPrivateKey.d(), rSAPrivateKey.p(), rSAPrivateKey.q(), rSAPrivateKey.dP(), rSAPrivateKey.dQ(), rSAPrivateKey.qInv());
        }

        public BigInteger getModulus() {
            return this.n();
        }

        public BigInteger getPublicExponent() {
            return this.e();
        }

        public BigInteger getPrivateExponent() {
            return this.d();
        }

        public BigInteger getPrimeP() {
            return this.p();
        }

        public BigInteger getPrimeQ() {
            return this.q();
        }

        public BigInteger getPrimeExponentP() {
            return this.dP();
        }

        public BigInteger getPrimeExponentQ() {
            return this.dQ();
        }

        public BigInteger getCrtCoefficient() {
            return this.qInv();
        }

        public String getFormat() {
            return "PKCS#8";
        }

        public String getAlgorithm() {
            return "RSA";
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            this.a(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.a(objectInputStream);
        }
    }

    static class _RSANDPrivateKey
    extends com.certicom.ecc.rsa.RSAPrivateKey
    implements Serializable,
    RSAPrivateKey {
        private static final long serialVersionUID = -4079639163704997805L;

        public _RSANDPrivateKey(RSAPrivateKey rSAPrivateKey) {
            super(rSAPrivateKey.getModulus(), null, rSAPrivateKey.getPrivateExponent());
        }

        public _RSANDPrivateKey(RSAPrivateKeySpec rSAPrivateKeySpec) {
            super(rSAPrivateKeySpec.getModulus(), null, rSAPrivateKeySpec.getPrivateExponent());
        }

        protected _RSANDPrivateKey(com.certicom.ecc.rsa.RSAPrivateKey rSAPrivateKey) {
            super(rSAPrivateKey.n(), rSAPrivateKey.e(), rSAPrivateKey.d(), rSAPrivateKey.p(), rSAPrivateKey.q(), rSAPrivateKey.dP(), rSAPrivateKey.dQ(), rSAPrivateKey.qInv());
        }

        public BigInteger getPrivateExponent() {
            return this.d();
        }

        public BigInteger getModulus() {
            return this.n();
        }

        public String getAlgorithm() {
            return "RSA";
        }

        public String getFormat() {
            return "PKCS#8";
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            this.a(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.a(objectInputStream);
        }
    }
}

