/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.access;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.javaseis.util.access.JSIO;
import org.javaseis.util.access.JavaSeisIO;
import org.javaseis.util.access.JavaSeisReader;
import org.javaseis.util.access.JavaSeisWriter;

public class JavaSeisWrapper {
    public static final int NORMAL = 0;
    public static final int ERROR = -1;
    protected int _status = 0;
    protected String _error_message = "";
    protected JavaSeisIO _js;
    protected JSIO _jsw;
    protected ArrayList<String> _method_list = new ArrayList();
    protected AxisData _ad = new AxisData(1);
    protected BinData _bd = new BinData();
    protected String _path;
    protected String _rw_mode;
    protected String _property_name;
    protected String _property_description;
    protected String _axis_domain;
    protected String _axis_units;
    protected String _data_type;
    protected String _trace_format;
    protected static final int GET_TRACE_NUMBER = 0;
    protected static final int SET_TRACE_NUMBER = 1;
    protected static final int GET_TRACE = 2;
    protected static final int SET_TRACE = 3;
    protected static final int STATUS = 4;
    protected static final int IS_A_JAVASEIS_PATH = 5;
    protected static final int IS_READ_WRITE = 6;
    protected static final int PROPERTY_NAME = 7;
    protected static final int PROPERTY_DESCRIPTION = 8;
    protected static final int ADD_INT_PROPERTY = 9;
    protected static final int ADD_FLOAT_PROPERTY = 10;
    protected static final int ADD_DOUBLE_PROPERTY = 11;
    protected static final int ADD_LONG_PROPERTY = 12;
    protected static final int GET_INT_PROPERTY = 13;
    protected static final int GET_FLOAT_PROPERTY = 14;
    protected static final int GET_DOUBLE_PROPERTY = 15;
    protected static final int GET_LONG_PROPERTY = 16;
    protected static final int SET_INT_PROPERTY = 17;
    protected static final int SET_FLOAT_PROPERTY = 18;
    protected static final int SET_DOUBLE_PROPERTY = 19;
    protected static final int SET_LONG_PROPERTY = 20;
    protected static final int SAMPLE_COUNT = 21;
    protected static final int TRACE_COUNT = 22;
    protected static final int DIMENSION_COUNT = 23;
    protected static final int ERROR_MESSAGE = 24;
    protected static final int AXIS_DIMENSION = 25;
    protected static final int GET_AXIS = 26;
    protected static final int GET_AXIS_LENGTH = 27;
    protected static final int GET_AXIS_DOMAIN = 28;
    protected static final int GET_AXIS_UNITS = 29;
    protected static final int GET_AXIS_LOGICALS = 30;
    protected static final int GET_AXIS_PHYSICALS = 31;
    protected static final int SET_AXIS_LENGTH = 32;
    protected static final int SET_AXIS_DOMAIN = 33;
    protected static final int SET_AXIS_UNITS = 34;
    protected static final int SET_AXIS_LOGICALS = 35;
    protected static final int SET_AXIS_PHYSICALS = 36;
    protected static final int SET_AXIS = 37;
    protected static final int GET_DATA_TYPE = 38;
    protected static final int SET_DATA_TYPE = 39;
    protected static final int GET_TRACE_FORMAT = 40;
    protected static final int SET_TRACE_FORMAT = 41;
    protected static final int GET_BIN = 42;
    protected static final int GET_BIN_WORLD = 43;
    protected static final int GET_BIN_GRID = 44;
    protected static final int GET_BIN_LOGICAL = 45;
    protected static final int SET_BIN_WORLD = 46;
    protected static final int SET_BIN_GRID = 47;
    protected static final int SET_BIN_LOGICAL = 48;
    protected static final int SET_BIN = 49;
    protected static final int PATH = 50;
    protected static final int RW_MODE = 51;
    protected static final int INIT = 52;
    protected static final int OPEN = 53;
    protected static final int CLOSE = 54;
    protected static final int DELETE = 55;
    protected static final int NUM_METHODS = 56;

    public JavaSeisWrapper() {
        this._method_list.add(0, "getTraceNumber");
        this._method_list.add(1, "setTraceNumber");
        this._method_list.add(2, "getTrace");
        this._method_list.add(3, "setTrace");
        this._method_list.add(4, "status");
        this._method_list.add(5, "isAJavaSeisPath");
        this._method_list.add(6, "isReadWrite");
        this._method_list.add(7, "propertyName");
        this._method_list.add(8, "propertyDescription");
        this._method_list.add(9, "addIntProperty");
        this._method_list.add(10, "addFloatProperty");
        this._method_list.add(11, "addDoubleProperty");
        this._method_list.add(12, "addLongProperty");
        this._method_list.add(13, "getIntProperty");
        this._method_list.add(14, "getFloatProperty");
        this._method_list.add(15, "getDoubleProperty");
        this._method_list.add(16, "getLongProperty");
        this._method_list.add(17, "setIntProperty");
        this._method_list.add(18, "setFloatProperty");
        this._method_list.add(19, "setDoubleProperty");
        this._method_list.add(20, "setLongProperty");
        this._method_list.add(21, "sampleCount");
        this._method_list.add(22, "traceCount");
        this._method_list.add(23, "dimensionCount");
        this._method_list.add(24, "errorMessage");
        this._method_list.add(25, "axisDimension");
        this._method_list.add(26, "getAxis");
        this._method_list.add(27, "getAxisLength");
        this._method_list.add(28, "getAxisDomain");
        this._method_list.add(29, "getAxisUnits");
        this._method_list.add(30, "getAxisLogicals");
        this._method_list.add(31, "getAxisPhysicals");
        this._method_list.add(32, "setAxisLength");
        this._method_list.add(33, "setAxisDomain");
        this._method_list.add(34, "setAxisUnits");
        this._method_list.add(35, "setAxisLogicals");
        this._method_list.add(36, "setAxisPhysicals");
        this._method_list.add(37, "setAxis");
        this._method_list.add(38, "getDataType");
        this._method_list.add(39, "setDataType");
        this._method_list.add(40, "getTraceFormat");
        this._method_list.add(41, "setTraceFormat");
        this._method_list.add(42, "getBin");
        this._method_list.add(43, "getBinWorld");
        this._method_list.add(44, "getBinGrid");
        this._method_list.add(45, "getBinLogical");
        this._method_list.add(46, "setBinWorld");
        this._method_list.add(47, "setBinGrid");
        this._method_list.add(48, "setBinLogical");
        this._method_list.add(49, "setBin");
        this._method_list.add(50, "path");
        this._method_list.add(51, "rwMode");
        this._method_list.add(52, "init");
        this._method_list.add(53, "open");
        this._method_list.add(54, "close");
        this._method_list.add(55, "delete");
    }

    public int none(String description) {
        int retval = this.verifyStatus();
        if (retval < 1) {
            return retval;
        }
        try {
            switch (this._method_list.indexOf(description)) {
                case 9: {
                    retval = this.addIntProperty();
                    break;
                }
                case 10: {
                    retval = this.addFloatProperty();
                    break;
                }
                case 11: {
                    retval = this.addDoubleProperty();
                    break;
                }
                case 12: {
                    retval = this.addLongProperty();
                    break;
                }
                case 53: {
                    retval = this.open();
                    break;
                }
                case 54: {
                    this.close();
                    break;
                }
                case 26: {
                    retval = this.getAxis();
                    break;
                }
                case 37: {
                    retval = this.setAxis();
                    break;
                }
                case 42: {
                    retval = this.getBin();
                    break;
                }
                case 49: {
                    retval = this.setBin();
                    break;
                }
                case 52: {
                    retval = this.init();
                    break;
                }
                case 55: {
                    retval = this.delete();
                    break;
                }
                default: {
                    this.handleError("JavaSeisWrapper.noargs: Unrecognized request: " + description, null);
                    retval = this.verifyStatus();
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.noargs: Failed: " + description, e);
            retval = this.verifyStatus();
        }
        return retval;
    }

    public int bytes(String description, byte[] byts) {
        int retval = this.verifyStatus();
        if (retval < 1) {
            return retval;
        }
        try {
            switch (this._method_list.indexOf(description)) {
                case 7: {
                    retval = this.setPropertyName(new String(byts));
                    break;
                }
                case 8: {
                    retval = this.setPropertyDescription(new String(byts));
                    break;
                }
                case 24: {
                    retval = this.getBytes(this.getErrorMessage(), byts);
                    break;
                }
                case 29: {
                    retval = this.getBytes(this.getAxisUnits(), byts);
                    break;
                }
                case 34: {
                    retval = this.setAxisUnits(new String(byts));
                    break;
                }
                case 28: {
                    retval = this.getBytes(this.getAxisDomain(), byts);
                    break;
                }
                case 33: {
                    retval = this.setAxisDomain(new String(byts));
                    break;
                }
                case 38: {
                    retval = this.getBytes(this.getDataType(), byts);
                    break;
                }
                case 39: {
                    retval = this.setDataType(new String(byts));
                    break;
                }
                case 40: {
                    retval = this.getBytes(this.getTraceFormat(), byts);
                    break;
                }
                case 41: {
                    retval = this.setTraceFormat(new String(byts));
                    break;
                }
                case 50: {
                    retval = this.setPath(new String(byts));
                    break;
                }
                case 51: {
                    retval = this.setRWMode(new String(byts));
                    break;
                }
                default: {
                    this.handleError("JavaSeisWrapper.bytes: Unrecognized request: " + description, null);
                    retval = this.verifyStatus();
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.bytes: Failed: " + description, e);
            retval = this.verifyStatus();
        }
        return retval;
    }

    public int floats(String description, float[] flts) {
        int retval = this.verifyStatus();
        if (retval < 1) {
            return retval;
        }
        try {
            switch (this._method_list.indexOf(description)) {
                case 2: {
                    retval = this.getTrace(flts);
                    break;
                }
                case 3: {
                    retval = this.setTrace(flts);
                    break;
                }
                case 14: {
                    flts[0] = this.getFloatProperty();
                    retval = this.verifyStatus();
                    break;
                }
                case 18: {
                    retval = this.setFloatProperty(flts[0]);
                    break;
                }
                default: {
                    this.handleError("JavaSeisWrapper.floats: Unrecognized request: " + description, null);
                    retval = this.verifyStatus();
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.floats: Failed: " + description, e);
            retval = this.verifyStatus();
        }
        return retval;
    }

    public int doubles(String description, double[] dbls) {
        int retval = this.verifyStatus();
        if (retval < 1) {
            return retval;
        }
        try {
            switch (this._method_list.indexOf(description)) {
                case 15: {
                    dbls[0] = this.getDoubleProperty();
                    break;
                }
                case 19: {
                    retval = this.setDoubleProperty(dbls[0]);
                    break;
                }
                case 31: {
                    retval = this.getAxisPhysicals(dbls);
                    break;
                }
                case 36: {
                    retval = this.setAxisPhysicals(dbls);
                    break;
                }
                case 43: {
                    retval = this.getBinWorld(dbls);
                    break;
                }
                case 46: {
                    retval = this.setBinWorld(dbls);
                    break;
                }
                case 44: {
                    retval = this.getBinGrid(dbls);
                    break;
                }
                case 47: {
                    retval = this.setBinGrid(dbls);
                    break;
                }
                default: {
                    this.handleError("JavaSeisWrapper.doubles: Unrecognized request: " + description, null);
                    retval = this.verifyStatus();
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.doubles: Failed: " + description, e);
            retval = this.verifyStatus();
        }
        return retval;
    }

    public int ints(String description, int[] ints) {
        int retval = this.verifyStatus();
        if (retval < 1) {
            return retval;
        }
        try {
            switch (this._method_list.indexOf(description)) {
                case 4: {
                    ints[0] = this.getStatus();
                    retval = this.verifyStatus();
                    break;
                }
                case 5: {
                    ints[0] = this.isAJavaSeisPath();
                    retval = this.verifyStatus();
                    break;
                }
                case 6: {
                    ints[0] = this.isReadWrite();
                    retval = this.verifyStatus();
                    break;
                }
                case 13: {
                    ints[0] = this.getIntProperty();
                    retval = this.verifyStatus();
                    break;
                }
                case 17: {
                    retval = this.setIntProperty(ints[0]);
                    break;
                }
                case 21: {
                    ints[0] = this.getSampleCount();
                    retval = this.verifyStatus();
                    break;
                }
                case 23: {
                    ints[0] = this.getNumDimensions();
                    retval = this.verifyStatus();
                    break;
                }
                case 25: {
                    retval = this.setAxisDimension(ints[0]);
                    break;
                }
                case 27: {
                    ints[0] = this.getAxisLength();
                    retval = this.verifyStatus();
                    break;
                }
                case 32: {
                    retval = this.setAxisLength(ints[0]);
                    break;
                }
                default: {
                    this.handleError("JavaSeisWrapper.ints: Unrecognized request: " + description, null);
                    retval = this.verifyStatus();
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.ints: Failed: " + description, e);
            retval = this.verifyStatus();
        }
        return retval;
    }

    public int longs(String description, long[] lngs) {
        int retval = this.verifyStatus();
        if (retval < 1) {
            return retval;
        }
        try {
            switch (this._method_list.indexOf(description)) {
                case 0: {
                    lngs[0] = this.getTraceNumber();
                    break;
                }
                case 1: {
                    retval = this.setTraceNumber(lngs[0]);
                    break;
                }
                case 16: {
                    lngs[0] = this.getLongProperty();
                    break;
                }
                case 20: {
                    retval = this.setLongProperty(lngs[0]);
                    break;
                }
                case 22: {
                    lngs[0] = this.getTraceCount();
                    break;
                }
                case 30: {
                    retval = this.getAxisLogicals(lngs);
                    break;
                }
                case 35: {
                    retval = this.setAxisLogicals(lngs);
                    break;
                }
                case 45: {
                    retval = this.getBinLogical(lngs);
                    break;
                }
                case 48: {
                    retval = this.setBinLogical(lngs);
                    break;
                }
                default: {
                    this.handleError("JavaSeisWrapper.longs: Unrecognized request: " + description, null);
                    retval = this.verifyStatus();
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.longs: Failed: " + description, e);
            retval = this.verifyStatus();
        }
        return retval;
    }

    public int setPropertyName(String property_name) {
        this._property_name = property_name;
        return this.verifyString(this._property_name);
    }

    public int setPropertyDescription(String property_description) {
        this._property_description = property_description;
        return this.verifyString(this._property_description);
    }

    public String getAxisUnits() {
        String retval;
        if (!this._ad._just_got_data) {
            this._status = -1;
            retval = null;
        } else {
            retval = this._status == 0 ? this._ad._units[0] : null;
        }
        return retval;
    }

    public int setAxisUnits(String axis_units) {
        try {
            if (this._status == 0 && !this._ad._units[0].equalsIgnoreCase(axis_units)) {
                ((AxisData)this._ad)._units[0] = axis_units;
                this._ad._just_got_data = false;
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.setAxisUnits: ", e);
        }
        return this.verifyStatus();
    }

    public String getAxisDomain() {
        String retval;
        if (!this._ad._just_got_data) {
            this._status = -1;
            retval = null;
        } else {
            retval = this._status == 0 ? this._ad._domain[0] : null;
        }
        return retval;
    }

    public int setAxisDomain(String axis_domain) {
        try {
            if (this._status == 0 && !this._ad._domain[0].equalsIgnoreCase(axis_domain)) {
                ((AxisData)this._ad)._domain[0] = axis_domain;
                this._ad._just_got_data = false;
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.setAxisDomain: ", e);
        }
        return this.verifyStatus();
    }

    public String getDataType() {
        String retval;
        try {
            retval = this._js.getDataType();
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.getDataType: ", e);
            retval = null;
        }
        return retval;
    }

    public int setDataType(String data_type_name) {
        try {
            if (!this._jsw.setDataType(data_type_name)) {
                this.handleError("JavaSeisWrapper.setDataType: Name " + data_type_name, null);
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.setDataType: Name " + data_type_name, e);
        }
        return this.verifyStatus();
    }

    public String getTraceFormat() {
        String retval;
        try {
            retval = this._js.getTraceFormat();
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.getTraceFormat: ", e);
            retval = null;
        }
        return retval;
    }

    public int setTraceFormat(String format_name) {
        try {
            if (!this._jsw.setTraceFormat(format_name)) {
                this.handleError("JavaSeisWrapper.setTraceFormat: Name " + format_name, null);
            }
        }
        catch (Exception e) {
            this._status = -1;
            this.handleError("JavaSeisWrapper.setTraceFormat: Name " + format_name, e);
        }
        return this.verifyStatus();
    }

    public int setPath(String path) {
        this._path = path;
        return this.verifyString(this._path);
    }

    public int setRWMode(String rw_mode) {
        this._rw_mode = rw_mode;
        return this.verifyString(this._rw_mode);
    }

    public int getTrace(float[] trace) {
        if (this._status != 0) {
            return 0;
        }
        return this._js.getTrace(trace);
    }

    public int setTrace(float[] trace) {
        int retval;
        if (this._status != 0) {
            retval = 0;
        } else {
            try {
                int count = this._jsw.putTrace(trace);
                retval = Math.min(trace.length, count);
            }
            catch (Exception e) {
                this.handleError("JavaSeisWrapper.setTrace: ", e);
                retval = 0;
            }
        }
        return retval;
    }

    public int getAxisPhysicals(double[] dbls) {
        if (!this._ad._just_got_data) {
            this._status = -1;
        } else if (this._status == 0) {
            try {
                dbls[0] = this._ad._physical_origin[0];
                dbls[1] = this._ad._physical_delta[0];
            }
            catch (Exception e) {
                this.handleError("JavaSeisWrapper.getAxisPhysicals: ", e);
            }
        }
        return this.verifyStatus();
    }

    public int setAxisPhysicals(double[] dbls) {
        if (this._status == 0) {
            try {
                if (this._ad._physical_origin[0] != dbls[0] || this._ad._physical_delta[0] != dbls[1]) {
                    ((AxisData)this._ad)._physical_origin[0] = dbls[0];
                    ((AxisData)this._ad)._physical_delta[0] = dbls[1];
                    this._ad._just_got_data = false;
                }
            }
            catch (Exception e) {
                this.handleError("JavaSeisWrapper.setAxisPhysicals: ", e);
            }
        }
        return this.verifyStatus();
    }

    public int setAxisDimension(int dimension) {
        if (this._status == 0 && this._ad._dimension != dimension) {
            this._ad._dimension = dimension;
            this._ad._just_got_data = false;
        }
        return this.verifyStatus();
    }

    public int getAxis() {
        if (this._status == 0) {
            if (!this._js.getAxis(this._ad._dimension, this._ad._length, this._ad._domain, this._ad._units, this._ad._logical_origin, this._ad._logical_delta, this._ad._physical_origin, this._ad._physical_delta)) {
                this.handleError("JavaSeisWrapper.getAxis: " + this._js.errorMessage(), null);
            }
            this._ad._just_got_data = this._status == 0;
        }
        return this.verifyStatus();
    }

    public int getAxisLength() {
        int retval;
        if (!this._ad._just_got_data) {
            this._status = -1;
            retval = 0;
        } else {
            retval = this._status == 0 ? this._ad._length[0] : 0;
        }
        return retval;
    }

    public int setAxisLength(int length) {
        if (this._status == 0 && this._ad._length[0] != length) {
            ((AxisData)this._ad)._length[0] = length;
            this._ad._just_got_data = false;
        }
        return this.verifyStatus();
    }

    public int setAxis() {
        if (this._status == 0 && !this._jsw.setAxis(this._ad._dimension, this._ad._length[0], this._ad._domain[0], this._ad._units[0], this._ad._logical_origin[0], this._ad._logical_delta[0], this._ad._physical_origin[0], this._ad._physical_delta[0])) {
            this.handleError("JavaSeisWrapper.setAxis: " + this._jsw.errorMessage(), null);
        }
        return this.verifyStatus();
    }

    public int getAxisLogicals(long[] lngs) {
        if (!this._ad._just_got_data) {
            this._status = -1;
        } else if (this._status == 0) {
            try {
                lngs[0] = this._ad._logical_origin[0];
                lngs[1] = this._ad._logical_delta[0];
            }
            catch (Exception e) {
                this.handleError("JavaSeisWrapper.getAxisLogicals: ", e);
            }
        }
        return this.verifyStatus();
    }

    public int setAxisLogicals(long[] lngs) {
        if (this._status == 0) {
            try {
                if (this._ad._logical_origin[0] != lngs[0] || this._ad._logical_delta[0] != lngs[1]) {
                    ((AxisData)this._ad)._logical_origin[0] = lngs[0];
                    ((AxisData)this._ad)._logical_delta[0] = lngs[1];
                    this._ad._just_got_data = false;
                }
            }
            catch (Exception e) {
                this.handleError("JavaSeisWrapper.setAxisLogicals: ", e);
            }
        }
        return this.verifyStatus();
    }

    public int init() {
        boolean read_write = this._rw_mode.equalsIgnoreCase("rw") || this._rw_mode.equalsIgnoreCase("w");
        if (!read_write) {
            JavaSeisReader jsr = new JavaSeisReader(this._path);
            if (!jsr.preExisted()) {
                this._status = -1;
                this._error_message = "JavaSeisWrapper.init: file not found " + this._path;
            } else {
                if (!jsr.open() || jsr.status() == -1) {
                    this._status = -1;
                    this._error_message = "JavaSeisWrapper.init: " + jsr.errorMessage();
                }
                this._js = jsr;
            }
        } else {
            this._jsw = new JavaSeisWriter(this._path);
            if (this._jsw.preExisted() && (!this._jsw.open() || this._jsw.status() == -1)) {
                this._status = -1;
                this._error_message = "JavaSeisWrapper.init: " + this._jsw.errorMessage();
            }
            this._js = (JavaSeisIO)this._jsw;
        }
        if (this._js == null) {
            this._status = -1;
            this._error_message = "JavaSeisWrapper.init: Failed";
        }
        return this.verifyStatus();
    }

    public int getStatus() {
        return this._status;
    }

    public String getErrorMessage() {
        return this._error_message;
    }

    public int isAJavaSeisPath() {
        if (this._status == 0) {
            return 1;
        }
        return 0;
    }

    public int isReadWrite() {
        if (this._status == 0) {
            return this._js.isReadWrite() ? 1 : 0;
        }
        return 0;
    }

    public long getTraceCount() {
        if (this._status != 0) {
            return 0L;
        }
        return this._js.getTraceCount();
    }

    public int getNumDimensions() {
        if (this._status != 0) {
            return 0;
        }
        return this._js.getNumDimensions();
    }

    public int getSampleCount() {
        if (this._status != 0) {
            return 0;
        }
        return this._js.getSampleCount();
    }

    public float[] getTrace() {
        if (this._status != 0) {
            return null;
        }
        return this._js.getTrace();
    }

    public int setTraceNumber(long trace_num) {
        int retval = this._js.setIndex(trace_num) ? 1 : 0;
        return retval;
    }

    public long getTraceNumber() {
        long retval = this._status != 0 ? 0L : this._js.getIndex();
        return retval;
    }

    public int open() {
        int retval = 1;
        if (this._status == 0) {
            if (this._js.isReadWrite() && !this._js.preExisted() && !this._jsw.open()) {
                retval = 0;
            }
        } else {
            retval = 0;
        }
        return retval;
    }

    public int setBinWorld(double[] world) {
        if (this._status == 0) {
            try {
                int k2;
                boolean changed = false;
                for (k2 = 0; !changed && k2 < this._bd._world.length; ++k2) {
                    changed = this._bd._world[k2] != world[k2];
                }
                if (changed) {
                    for (k2 = 0; k2 < this._bd._world.length; ++k2) {
                        ((BinData)this._bd)._world[k2] = world[k2];
                    }
                    this._bd._just_got_data = false;
                }
            }
            catch (Exception e) {
                this.handleError("JavaSeisWrapper.setBinWorld: ", e);
            }
        }
        return this.verifyStatus();
    }

    public int setBinGrid(double[] grid) {
        if (this._status == 0) {
            try {
                int k2;
                boolean changed = false;
                for (k2 = 0; !changed && k2 < this._bd._grid.length; ++k2) {
                    changed = this._bd._grid[k2] != grid[k2];
                }
                if (changed) {
                    for (k2 = 0; k2 < this._bd._grid.length; ++k2) {
                        ((BinData)this._bd)._grid[k2] = grid[k2];
                    }
                    this._bd._just_got_data = false;
                }
            }
            catch (Exception e) {
                this.handleError("JavaSeisWrapper.setBinGrid: ", e);
            }
        }
        return this.verifyStatus();
    }

    public int setBinLogical(long[] logical) {
        if (this._status == 0) {
            try {
                int k2;
                boolean changed = false;
                for (k2 = 0; !changed && k2 < this._bd._logical.length; ++k2) {
                    changed = this._bd._logical[k2] != logical[k2];
                }
                if (changed) {
                    for (k2 = 0; k2 < this._bd._logical.length; ++k2) {
                        ((BinData)this._bd)._logical[k2] = logical[k2];
                    }
                    this._bd._just_got_data = false;
                }
            }
            catch (Exception e) {
                this.handleError("JavaSeisWrapper.setBinLogical: ", e);
            }
        }
        return this.verifyStatus();
    }

    public int setBin() {
        if (this._status == 0 && !this._jsw.setBinGrid(this._bd._world, this._bd._grid, this._bd._logical)) {
            this.handleError("JavaSeisWrapper.setBinGrid: " + this._jsw.errorMessage(), null);
        }
        return this.verifyStatus();
    }

    public int addIntProperty() {
        try {
            if (!this._jsw.addIntProperty(this._property_name, this._property_description)) {
                this.handleError("JavaSeisWrapper.addIntProperty: Name " + this._property_name, null);
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.addIntProperty: Name " + this._property_name + ":", e);
        }
        return this.verifyStatus();
    }

    public int addFloatProperty() {
        try {
            if (!this._jsw.addFloatProperty(this._property_name, this._property_description)) {
                this.handleError("JavaSeisWrapper.addFloatProperty: Name " + this._property_name, null);
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.addFloatProperty: Name " + this._property_name + ":", e);
        }
        return this.verifyStatus();
    }

    public int addDoubleProperty() {
        try {
            if (!this._jsw.addDoubleProperty(this._property_name, this._property_description)) {
                this.handleError("JavaSeisWrapper.addDoubleProperty: Name " + this._property_name, null);
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.addDoubleProperty: Name " + this._property_name + ": ", e);
        }
        return this.verifyStatus();
    }

    public int addLongProperty() {
        try {
            if (!this._jsw.addLongProperty(this._property_name, this._property_description)) {
                this.handleError("JavaSeisWrapper.addLongProperty: Name " + this._property_name, null);
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.addLongProperty: Name " + this._property_name + ":", e);
        }
        return this.verifyStatus();
    }

    public int setIntProperty(int value) {
        try {
            if (!this._jsw.putIntPropertyValue(this._property_name, value)) {
                this.handleError("JavaSeisWrapper.putIntPropertyValue: Name " + this._property_name, null);
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.putIntPropertyValue: Name " + this._property_name + ":", e);
        }
        return this.verifyStatus();
    }

    public int setFloatProperty(float value) {
        try {
            if (!this._jsw.putFloatPropertyValue(this._property_name, value)) {
                this.handleError("JavaSeisWrapper.putFloatPropertyValue: Name " + this._property_name, null);
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.putFloatPropertyValue: Name " + this._property_name + ":", e);
        }
        return this.verifyStatus();
    }

    public int setDoubleProperty(double value) {
        try {
            if (!this._jsw.putDoublePropertyValue(this._property_name, value)) {
                this.handleError("JavaSeisWrapper.putDoublePropertyValue: Name " + this._property_name, null);
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.putDoublePropertyValue: Name " + this._property_name + ":", e);
        }
        return this.verifyStatus();
    }

    public int setLongProperty(long value) {
        try {
            if (!this._jsw.putLongPropertyValue(this._property_name, value)) {
                this.handleError("JavaSeisWrapper.putLongPropertyValue: Name " + this._property_name, null);
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.putLongPropertyValue: Name " + this._property_name + ":", e);
        }
        return this.verifyStatus();
    }

    public int getIntProperty() {
        int retval;
        try {
            retval = this._js.getIntPropertyValue(this._property_name);
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.getIntPropertyValue: Name " + this._property_name + ": ", e);
            retval = -999;
        }
        return retval;
    }

    public float getFloatProperty() {
        float retval;
        try {
            retval = this._js.getFloatPropertyValue(this._property_name);
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.getFloatPropertyValue: Name " + this._property_name + ": ", e);
            retval = -999.0f;
        }
        return retval;
    }

    public double getDoubleProperty() {
        double retval;
        try {
            retval = this._js.getDoublePropertyValue(this._property_name);
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.getDoublePropertyValue: Name " + this._property_name + ": ", e);
            retval = -999.0;
        }
        return retval;
    }

    public long getLongProperty() {
        long retval;
        try {
            retval = this._js.getLongPropertyValue(this._property_name);
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.getLongPropertyValue: Name " + this._property_name + ": ", e);
            retval = -999L;
        }
        return retval;
    }

    public int getBin() {
        if (this._status == 0) {
            if (!this._js.getBinGrid(this._bd._world, this._bd._grid, this._bd._logical)) {
                this.handleError("JavaSeisWrapper.getBin: " + this._js.errorMessage(), null);
            }
            this._bd._just_got_data = this._status == 0;
        }
        return this.verifyStatus();
    }

    public int getBinWorld(double[] world) {
        if (!this._bd._just_got_data) {
            this._status = -1;
        } else if (this._status == 0) {
            try {
                for (int k2 = 0; k2 < this._bd._world.length; ++k2) {
                    world[k2] = this._bd._world[k2];
                }
            }
            catch (Exception e) {
                this.handleError("JavaSeisWrapper.getBinWorld: ", e);
            }
        }
        return this.verifyStatus();
    }

    public int getBinGrid(double[] grid) {
        if (!this._bd._just_got_data) {
            this._status = -1;
        } else if (this._status == 0) {
            try {
                for (int k2 = 0; k2 < this._bd._grid.length; ++k2) {
                    grid[k2] = this._bd._grid[k2];
                }
            }
            catch (Exception e) {
                this.handleError("JavaSeisWrapper.getBinGrid: ", e);
            }
        }
        return this.verifyStatus();
    }

    public int getBinLogical(long[] logical) {
        if (!this._bd._just_got_data) {
            this._status = -1;
        } else if (this._status == 0) {
            try {
                for (int k2 = 0; k2 < this._bd._logical.length; ++k2) {
                    logical[k2] = this._bd._logical[k2];
                }
            }
            catch (Exception e) {
                this.handleError("JavaSeisWrapper.getBinLogical: ", e);
            }
        }
        return this.verifyStatus();
    }

    public void close() {
        if (this._status == 0) {
            this._js.close();
            this.handleError("JavaSeisWrapper.close: File not open", null);
        }
    }

    public int delete() {
        int retval = 1;
        this.close();
        try {
            if (!this._jsw.delete()) {
                this.handleError("JavaSeisWrapper.delete: " + this._jsw.errorMessage(), null);
                retval = 0;
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.delete: ", e);
            retval = 0;
        }
        return retval;
    }

    protected int getBytes(String string, byte[] byts) {
        Arrays.fill(byts, (byte)0);
        int retval = Math.min(string.trim().length(), byts.length);
        if (retval < 1) {
            return retval;
        }
        try {
            ByteBuffer bb = ByteBuffer.wrap(string.getBytes("US-ASCII"), 0, retval);
            bb.get(byts, 0, retval);
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.getBytes: ", e);
            retval = 0;
        }
        return retval;
    }

    protected int verifyString(String string) {
        try {
            this._status = this._status == 0 && string.length() > 0 ? 0 : -1;
        }
        catch (Exception e) {
            this.handleError("JavaSeisWrapper.verifyString: ", e);
        }
        return this.verifyStatus();
    }

    protected int verifyStatus() {
        int retval = this._status == 0 ? 1 : 0;
        return retval;
    }

    protected void handleError(String prefix, Exception e) {
        this._status = -1;
        String loc_prefix = prefix != null ? prefix : "";
        String loc_suffix = e != null ? e.getMessage() : "";
        String error_message = loc_prefix + loc_suffix;
        if (error_message.length() > 0) {
            this._error_message = error_message;
        }
    }

    private class BinData {
        private double[] _world = new double[6];
        private double[] _grid;
        private long[] _logical;
        private boolean _just_got_data;

        private BinData() {
            this._world[0] = 0.0;
            this._world[1] = 0.0;
            this._world[2] = 1.0;
            this._world[3] = 0.0;
            this._world[4] = 0.0;
            this._world[5] = 1.0;
            this._grid = new double[4];
            this._grid[0] = 0.0;
            this._grid[1] = 0.0;
            this._grid[2] = 1.0;
            this._grid[3] = 1.0;
            this._logical = new long[8];
            this._logical[0] = 0L;
            this._logical[1] = 0L;
            this._logical[2] = 1L;
            this._logical[3] = 0L;
            this._logical[4] = 0L;
            this._logical[5] = 1L;
            this._logical[6] = 1L;
            this._logical[7] = 1L;
        }
    }

    private class AxisData {
        private int _dimension;
        private int[] _length = new int[1];
        private String[] _domain = new String[1];
        private String[] _units = new String[1];
        private long[] _logical_origin = new long[1];
        private long[] _logical_delta = new long[1];
        private double[] _physical_origin = new double[1];
        private double[] _physical_delta = new double[1];
        private boolean _just_got_data;

        private AxisData(int dimension) {
            this._dimension = dimension;
            this._length[0] = 1;
            switch (this._dimension) {
                case 1: {
                    this._domain[0] = "time";
                    this._units[0] = "miliseconds";
                    break;
                }
                case 2: 
                case 3: {
                    this._domain[0] = "space";
                    this._units[0] = "feet";
                    break;
                }
                default: {
                    this._domain[0] = "offset";
                    this._units[0] = "unitless";
                }
            }
            this._logical_origin[0] = 0L;
            this._logical_delta[0] = 1L;
            this._physical_origin[0] = 0.0;
            this._physical_delta[0] = 1.0;
        }
    }
}

