/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.access;

import org.javaseis.properties.TraceProperties;
import org.javaseis.util.SeisException;
import org.javaseis.util.access.Frame;
import org.javaseis.util.access.TraceAccessor;

public class FrameBuffer {
    private TraceAccessor _sta;
    private Frame[] _frames;
    private int _count;
    private int _frame_index = -1;

    public FrameBuffer(TraceAccessor sta, int count) {
        if (count < 1) {
            count = 1;
        }
        this._sta = sta;
        this._frames = new Frame[count];
        for (int k2 = 0; k2 < this._frames.length; ++k2) {
            this._frames[k2] = new Frame(this._sta.isReadWrite(), this.usingHeaders());
        }
    }

    public boolean setTraceIndex(long index) {
        boolean retval = false;
        this._frame_index = -1;
        for (int k2 = 0; !retval && k2 < this._count; ++k2) {
            if (!this._frames[k2].includes(index)) continue;
            this._frames[k2].setTraceIndex(index);
            this._frame_index = k2;
            retval = true;
        }
        return retval;
    }

    public float[] readTrace() throws SeisException {
        float[] retval = this.validFrame() ? this._frames[this._frame_index].readTrace() : null;
        return retval;
    }

    public float[][] readFrame(long first_trace_in_frame, long last_trace_in_frame, long cur_trace) throws SeisException {
        float[][] retval = null;
        if (this.validFrame()) {
            retval = this._frames[this._frame_index].getArray();
        } else {
            if (this._frames.length > 1 && this._count > 0) {
                for (int k2 = this._frames.length - 1; k2 > 1; --k2) {
                    this._frames[k2].setFrom(this._frames[k2 - 1]);
                }
                this._frames[1].init();
                if (!this._frames[1].copyFrom(this._frames[0])) {
                    return retval;
                }
            }
            if (this._count < this._frames.length) {
                ++this._count;
            }
            this._sta.getSeisio().readFrame(this._sta.getSeisioPosition(first_trace_in_frame));
            this._frames[0].setArray(this._sta.getSeisio().getTraceDataArray());
            this._frames[0].setProperties(this._sta.getSeisio().getTraceProperties());
            this._frames[0].setRange(first_trace_in_frame, last_trace_in_frame);
            this._frames[0].setTraceIndex(cur_trace);
            this._frame_index = 0;
            retval = this._frames[0].getArray();
        }
        return retval;
    }

    public int writeTrace(float[] trace) throws SeisException {
        int retval = this.validFrame() ? this._frames[this._frame_index].writeTrace(trace) : 0;
        return retval;
    }

    public int writeFrame() throws SeisException {
        int retval;
        if (this.couldHaveChanged()) {
            Frame cur_frame_0 = null;
            if (this._frame_index != 0) {
                cur_frame_0 = new Frame(this._sta.isReadWrite(), this.usingHeaders());
                cur_frame_0.copyFrom(this._frames[0]);
                this._frames[this._frame_index].copyTo(this._frames[0]);
            }
            retval = this._sta.getSeisio().writeFrame(this._sta.getSeisioPosition(this._frames[0].getFirstTrace()), this._frames[0].getTraceCount());
            if (this._frame_index != 0) {
                cur_frame_0.copyTo(this._frames[0]);
            }
            if (retval > 0) {
                this.resetWrite();
            }
        } else {
            retval = 0;
        }
        return retval;
    }

    private void resetWrite() {
        if (this.validFrame()) {
            this._frames[this._frame_index].resetWrite();
        }
    }

    public TraceProperties getHeader(long index) {
        TraceProperties retval = null;
        if (this.validFrame()) {
            retval = this._frames[this._frame_index].getHeader();
        }
        return retval;
    }

    private boolean validFrame() {
        boolean retval;
        boolean bl = retval = this._frame_index > -1 && this._frame_index < this._count;
        if (retval) {
            retval = this._frames[this._frame_index].valid();
        }
        return retval;
    }

    public boolean couldHaveChanged() {
        boolean retval = this.validFrame();
        if (retval) {
            this._frames[this._frame_index].couldHaveChanged();
        }
        return retval;
    }

    public void flush() throws SeisException {
        Frame cur_frame_0 = null;
        String errmsg = "FrameBuffer.flush: Failed to copy frame";
        for (int k2 = 0; k2 < this._count; ++k2) {
            int count;
            if (!this._frames[k2].couldHaveChanged()) continue;
            if (k2 != 0) {
                if (cur_frame_0 == null && !(cur_frame_0 = new Frame(this._sta.isReadWrite(), this.usingHeaders())).copyFrom(this._frames[0])) {
                    throw new SeisException(errmsg);
                }
                if (!this._frames[k2].copyTo(this._frames[0])) {
                    throw new SeisException(errmsg);
                }
            }
            if ((count = this._sta.getSeisio().writeFrame(this._sta.getSeisioPosition(this._frames[k2].getFirstTrace()), this._frames[k2].getTraceCount())) <= 0) continue;
            this._frames[k2].resetWrite();
        }
        if (cur_frame_0 != null && !cur_frame_0.copyTo(this._frames[0])) {
            throw new SeisException(errmsg);
        }
    }

    public boolean isFull() {
        return this._count >= this._frames.length;
    }

    public int getFrameIndex() {
        return this._frame_index;
    }

    public void setFrameIndex(int frame_index) {
        this._frame_index = frame_index;
    }

    public int oldestModifiedFrame() {
        int retval = -1;
        for (int k2 = this._count - 1; retval == -1 && k2 > -1; --k2) {
            if (!this._frames[k2].couldHaveChanged()) continue;
            retval = k2;
        }
        return retval;
    }

    private boolean usingHeaders() {
        boolean retval = this._sta.getSeisio().getHeaderIO() != null;
        return retval;
    }
}

