/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class MemoryReporter {
    private long currentUsedHeapMemory = 0L;
    private long maxUsedHeapMemory = 0L;
    private long commitedHeapMemory = 0L;
    private long maxHeapMemory = 0L;
    private final MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
    private boolean needGC = false;

    public MemoryReporter() {
        this(10L);
    }

    public MemoryReporter(long intervel) {
        final long sleepms = intervel;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        MemoryUsage memUsage = MemoryReporter.this.memory.getHeapMemoryUsage();
                        MemoryReporter.this.currentUsedHeapMemory = memUsage.getUsed();
                        MemoryReporter.this.commitedHeapMemory = memUsage.getCommitted();
                        MemoryReporter.this.maxHeapMemory = memUsage.getMax();
                        if (MemoryReporter.this.currentUsedHeapMemory > MemoryReporter.this.maxUsedHeapMemory) {
                            MemoryReporter.this.maxUsedHeapMemory = MemoryReporter.this.currentUsedHeapMemory;
                        }
                        if (MemoryReporter.this.needGC) {
                            System.gc();
                        }
                        Thread.sleep(sleepms);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setName("memory-monitor");
        thread.setDaemon(true);
        thread.start();
    }

    public void reset() {
        System.gc();
        MemoryUsage memUsage = this.memory.getHeapMemoryUsage();
        this.currentUsedHeapMemory = memUsage.getUsed();
        this.commitedHeapMemory = memUsage.getCommitted();
        this.maxHeapMemory = memUsage.getMax();
        this.maxUsedHeapMemory = this.currentUsedHeapMemory;
    }

    public long getCurrentUsedHeapMemory() {
        return this.currentUsedHeapMemory;
    }

    public long getMaxUsedHeapMemory() {
        return this.maxUsedHeapMemory;
    }

    public long getMaxHeapMemory() {
        return this.maxHeapMemory;
    }

    public long getCommitedHeapMemory() {
        return this.commitedHeapMemory;
    }

    public String getMemoryUsage() {
        return "Max Used Heap Memory: " + this.convertToMemoryString(this.maxUsedHeapMemory) + ", Current Used Heap Memory: " + this.convertToMemoryString(this.currentUsedHeapMemory) + ", Max Heap Memory: " + this.convertToMemoryString(this.maxHeapMemory);
    }

    private String convertToMemoryString(long size) {
        String out;
        if (size > 0x10000000000L) {
            float dsize = (float)((double)size / 1.099511627776E12);
            out = String.format("%.3f TB", Float.valueOf(dsize));
        } else if (size > 0x40000000L) {
            float dsize = (float)((double)size / 1.073741824E9);
            out = String.format("%.3f GB", Float.valueOf(dsize));
        } else if (size > 0x100000L) {
            float dsize = (float)((double)size / 1048576.0);
            out = String.format("%.3f MB", Float.valueOf(dsize));
        } else if (size > 1024L) {
            float dsize = (float)((double)size / 1024.0);
            out = String.format("%.3f KB", Float.valueOf(dsize));
        } else {
            out = Long.toString(size);
        }
        return out;
    }
}

