/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import junit.framework.TestCase;
import org.javaseis.io.ExtentPolicyMinMax;
import org.javaseis.io.ExtentPolicyRandom;
import org.javaseis.io.JSUtilFile;
import org.javaseis.io.VirtualFolder;
import org.javaseis.io.VirtualFoldersSS;
import org.javaseis.tests.TestUtil;
import org.javaseis.util.SeisException;

public class JTestAllocationPolicies
extends TestCase {
    public void test1() throws SeisException {
        VirtualFolder[] folders;
        String name = "JTestAllocationPolicies.js";
        String path = TestUtil.getDatasetPath("area1/line1/" + name);
        VirtualFoldersSS vFolders = new VirtualFoldersSS(path, TestUtil.getVirtualFolders(path, "area1", "line1").getSecondary(), new ExtentPolicyRandom());
        for (VirtualFolder v : folders = vFolders.getFolders()) {
            v.setAttribute(VirtualFolder.Attribute.READ_ONLY);
        }
        ExtentPolicyRandom policy = new ExtentPolicyRandom();
        int index = -1;
        System.out.println("Testing with no RW folders and no Overflow");
        index = policy.getNextExtentFolder(0, 25, vFolders);
        JTestAllocationPolicies.assertTrue((index < 0 ? 1 : 0) != 0);
        System.out.println("Testing with no RW folders and one Overflow");
        folders[0].setAttribute(VirtualFolder.Attribute.OVERFLOW_ONLY);
        index = policy.getNextExtentFolder(0, 25, vFolders);
        JTestAllocationPolicies.assertTrue((index == 0 ? 1 : 0) != 0);
        System.out.println("Testing with all deprecated");
        for (VirtualFolder v : folders) {
            v.setAttribute(VirtualFolder.Attribute.RETIRED);
        }
        folders[0].setAttribute(VirtualFolder.Attribute.RETIRED);
        index = policy.getNextExtentFolder(0, 25, vFolders);
        JTestAllocationPolicies.assertTrue((index == -1 ? 1 : 0) != 0);
        System.out.println("Testing with one deprecated and RW");
        for (VirtualFolder v : folders) {
            v.setAttribute(VirtualFolder.Attribute.READ_WRITE);
        }
        folders[0].setAttribute(VirtualFolder.Attribute.RETIRED);
        index = policy.getNextExtentFolder(0, 25, vFolders);
        JTestAllocationPolicies.assertTrue((index != 0 ? 1 : 0) != 0);
        System.out.println("Testing with RW folders and one Overflow");
        for (VirtualFolder v : folders) {
            v.setAttribute(VirtualFolder.Attribute.READ_WRITE);
        }
        folders[0].setAttribute(VirtualFolder.Attribute.OVERFLOW_ONLY);
        int[] counts = new int[vFolders.count()];
        for (int i = 0; i < 100; ++i) {
            int ind;
            int n = ind = policy.getNextExtentFolder(0, 25, vFolders);
            counts[n] = counts[n] + 1;
        }
        JTestAllocationPolicies.assertTrue((counts[0] == 0 ? 1 : 0) != 0);
        long space = JSUtilFile.diskCapacityBytes(folders[0].getPath());
        System.out.println("Testing with all RW folders but global required free space fails");
        ExtentPolicyRandom rPolicy = (ExtentPolicyRandom)vFolders.getPolicy();
        rPolicy.setGlobalMinFreeSpace(space * 2L);
        for (VirtualFolder v : folders) {
            v.setAttribute(VirtualFolder.Attribute.READ_WRITE);
        }
        index = rPolicy.getNextExtentFolder(0, 25, vFolders);
        JTestAllocationPolicies.assertTrue((index == -1 ? 1 : 0) != 0);
        System.out.println("Testing with all RW folders and enough free space");
        rPolicy.setGlobalMinFreeSpace(space / 2L);
        index = rPolicy.getNextExtentFolder(0, 25, vFolders);
        JTestAllocationPolicies.assertTrue((index != -1 ? 1 : 0) != 0);
        System.out.println("*** org.javaseis.io.test.JTestAllocationPolicies SUCCESS");
    }

    public void test2() throws SeisException {
        String name = "JTestAllocationPolicies2.js";
        String path = TestUtil.getDatasetPath("area1/line1/" + name);
        System.out.println(path);
        VirtualFoldersSS vFolders = new VirtualFoldersSS(path, TestUtil.getVirtualFolders(path, "area1", "line1").getSecondary(), new ExtentPolicyRandom());
        VirtualFolder[] folders = vFolders.getFolders();
        ExtentPolicyMinMax policy = new ExtentPolicyMinMax();
        long space = JSUtilFile.diskCapacityBytes(folders[0].getPath());
        int index = -1;
        policy.setMinMaxSpace(space / 10L, space * 2L);
        for (VirtualFolder v : folders) {
            v.setAttribute(VirtualFolder.Attribute.READ_ONLY);
        }
        System.out.println("No RW and no overflow");
        folders[0].setAttribute(VirtualFolder.Attribute.READ_ONLY);
        index = policy.getNextExtentFolder(0, 25, vFolders);
        JTestAllocationPolicies.assertTrue((index == -1 ? 1 : 0) != 0);
        folders[0].setAttribute(VirtualFolder.Attribute.READ_WRITE);
        index = policy.getNextExtentFolder(0, 25, vFolders);
        JTestAllocationPolicies.assertTrue((index == 0 ? 1 : 0) != 0);
        System.out.println("All RW but not enough space");
        for (VirtualFolder v : folders) {
            v.setAttribute(VirtualFolder.Attribute.READ_WRITE);
        }
        policy.setMinMaxSpace(space * 2L, space * 3L);
        index = policy.getNextExtentFolder(0, 25, vFolders);
        JTestAllocationPolicies.assertTrue((index == -1 ? 1 : 0) != 0);
        System.out.println("Added Overflow at folder 0");
        folders[0].setAttribute(VirtualFolder.Attribute.OVERFLOW_ONLY);
        index = policy.getNextExtentFolder(0, 25, vFolders);
        JTestAllocationPolicies.assertTrue((index == 0 ? 1 : 0) != 0);
        System.out.println("Min and Max OK should be anything but 0");
        policy.setMinMaxSpace(space / 10L, space / 2L);
        index = policy.getNextExtentFolder(0, 25, vFolders);
        JTestAllocationPolicies.assertTrue((index != 0 ? 1 : 0) != 0);
        for (VirtualFolder v : folders) {
            v.setAttribute(VirtualFolder.Attribute.READ_WRITE);
        }
        folders[0].setAttribute(VirtualFolder.Attribute.OVERFLOW_ONLY);
        int[] counts = new int[vFolders.count()];
        for (int i = 0; i < 10; ++i) {
            int ind;
            int n = ind = policy.getNextExtentFolder(0, 25, vFolders);
            counts[n] = counts[n] + 1;
        }
        JTestAllocationPolicies.assertTrue((counts[0] == 0 ? 1 : 0) != 0);
        System.out.println("*** org.javaseis.io.test.JTestAllocationPolicies2 SUCCESS");
    }
}

