/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Logger;
import org.javaseis.io.ExtentBaseNameFilter;
import org.javaseis.io.ExtentList;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.ExtentPolicyFolder1;
import org.javaseis.io.ExtentPolicyMinMax;
import org.javaseis.io.ExtentPolicyRandom;
import org.javaseis.io.ExtentPolicySrv;
import org.javaseis.io.VirtualFolder;
import org.javaseis.io.VirtualFoldersSS;
import org.javaseis.io.VirtualFoldersSimple;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.util.SeisException;

public abstract class VirtualFolders {
    public static final String VIRTUAL_FOLDERS_XML = "VirtualFolders.xml";
    public static final String VIRTUAL_FOLDERS_PSETNAME = "VirtualFolders";
    private static final String VERSION_PARM_NAME = "Version";
    private static final String HEADER_PARM_NAME = "Header";
    private static final String VIRTUAL_FOLDER_TYPE = "Type";
    protected static final String NDIR = "NDIR";
    private static final String vfioVersion = "2006.2";
    protected static final String vfioHeader = "VFIO org.javaseis.io.VirtualFolder 2006.2";
    protected VirtualFolder[] _folders;
    protected String _datasetPath;
    protected ExtentPolicy _policy;
    protected String[] _precomputedTraceExtents = new String[0];
    protected String[] _precomputedHeaderExtents = new String[0];
    protected boolean _containsPrecomputedExtents = false;
    private static final Logger LOG = Logger.getLogger(VirtualFolders.class.getName());

    public abstract String getType();

    protected abstract void store(ParameterSet var1) throws SeisException;

    protected abstract void load(ParameterSet var1) throws SeisException;

    protected abstract boolean addFolder(String var1, VirtualFolder var2);

    protected abstract boolean removeFolder(String var1, VirtualFolder var2);

    public VirtualFolder[] getFolders() {
        return this._folders;
    }

    public static VirtualFolders factory(String path) throws SeisException {
        if (path == null || path.length() < 1) {
            throw new IllegalArgumentException("Invalid dataset path: " + path);
        }
        if (!new File(path + File.separatorChar + VIRTUAL_FOLDERS_XML).exists()) {
            return null;
        }
        ParameterSet parameterSet = null;
        try {
            parameterSet = ParameterSetIO.readFile(path + File.separatorChar + VIRTUAL_FOLDERS_XML);
        }
        catch (IOException e) {
            throw new SeisException(e.toString());
        }
        catch (Exception e) {
            throw new SeisException(e.toString());
        }
        String type = ParameterSetIO.getRequiredString(parameterSet, VIRTUAL_FOLDER_TYPE);
        String policyID = ParameterSetIO.getRequiredString(parameterSet, "POLICY_ID");
        ExtentPolicy policy = VirtualFolders.extentPolicyFactory(policyID);
        policy.load(parameterSet);
        VirtualFolders vf = null;
        if (type.compareToIgnoreCase("SIMPLE") == 0) {
            vf = new VirtualFoldersSimple(path, policy);
        } else if (type.compareToIgnoreCase("SS") == 0) {
            vf = new VirtualFoldersSS(path, policy);
        } else {
            throw new SeisException("Unrecognized type of VirtualFolders: " + type);
        }
        ((VirtualFolders)vf).load(parameterSet);
        return vf;
    }

    public static boolean delete(String path) {
        File f = new File(path + File.separatorChar + VIRTUAL_FOLDERS_XML);
        return !f.exists() || f.delete();
    }

    public static boolean isVirtual(String path) {
        return new File(path + File.separatorChar + VIRTUAL_FOLDERS_XML).exists();
    }

    public String getLockFolder() {
        return this._datasetPath;
    }

    public String[] getExtentPathNames(String baseName) {
        if ("TraceFile".compareToIgnoreCase(baseName) == 0) {
            return this._precomputedTraceExtents;
        }
        if ("TraceHeaders".compareToIgnoreCase(baseName) == 0) {
            return this._precomputedHeaderExtents;
        }
        throw new IllegalArgumentException("baseName parameter is not valid: " + baseName);
    }

    public void preComputedExtents(String[] precomputedTraceExtents, String[] preComputedHeaderExtents) {
        this._precomputedTraceExtents = precomputedTraceExtents;
        this._precomputedHeaderExtents = preComputedHeaderExtents;
        this._containsPrecomputedExtents = true;
    }

    public void findExtents() throws SeisException {
        HashMap<String, String> traceExtents = new HashMap<String, String>();
        HashMap<String, String> headerExtents = new HashMap<String, String>();
        for (VirtualFolder folder : this._folders) {
            String[] t_list;
            File dir = new File(folder.getPath());
            if (!dir.exists()) {
                LOG.warning("Virtual folder '" + dir + "' does not exist");
            }
            if ((t_list = dir.list(new ExtentBaseNameFilter("TraceFile", ExtentList.EXCLUDE_EXTN))) == null) {
                LOG.warning("dir.list returned null: " + dir.getAbsolutePath());
            } else {
                for (String t : t_list) {
                    String previous = traceExtents.put(t, dir.getAbsolutePath() + File.separator + t);
                    if (previous == null) continue;
                    throw new SeisException("Duplicate extent encountered: \n" + previous + dir.getAbsolutePath() + File.separator + t);
                }
            }
            String[] h_list = dir.list(new ExtentBaseNameFilter("TraceHeaders", ExtentList.EXCLUDE_EXTN));
            if (h_list == null) {
                LOG.warning("dir.list returned null: " + dir.getAbsolutePath());
                continue;
            }
            for (String h : h_list) {
                String previous = headerExtents.put(h, dir.getAbsolutePath() + File.separator + h);
                if (previous == null) continue;
                throw new SeisException("Duplicate extent encountered: \n" + previous + dir.getAbsolutePath() + File.separator + h);
            }
        }
        this.preComputedExtents(traceExtents.values().toArray(new String[0]), headerExtents.values().toArray(new String[0]));
    }

    public boolean containPrecomputeExtents() {
        return this._containsPrecomputedExtents;
    }

    public void store() throws SeisException {
        ParameterSet parameterSet = new ParameterSet(VIRTUAL_FOLDERS_PSETNAME);
        this.store(parameterSet);
        parameterSet.setString(VERSION_PARM_NAME, vfioVersion);
        parameterSet.setString(HEADER_PARM_NAME, vfioHeader);
        parameterSet.setString(VIRTUAL_FOLDER_TYPE, this.getType());
        this._policy.store(parameterSet);
        try {
            ParameterSetIO.writeFile(parameterSet, this._datasetPath + File.separatorChar + VIRTUAL_FOLDERS_XML);
        }
        catch (IOException e) {
            throw new SeisException(e.toString());
        }
    }

    protected void load() throws SeisException {
        ParameterSet parameterSet = null;
        try {
            parameterSet = ParameterSetIO.readFile(this._datasetPath + File.separatorChar + VIRTUAL_FOLDERS_XML);
        }
        catch (IOException e) {
            throw new SeisException(e.toString());
        }
        this.load(parameterSet);
    }

    public int count() {
        return this._folders.length;
    }

    public String[] getSecondary() {
        String[] secondary = new String[this._folders.length];
        for (int i = 0; i < this._folders.length; ++i) {
            secondary[i] = this._folders[i].getPath();
        }
        return secondary;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (VirtualFolder folder : this._folders) {
            buf.append(folder.getPath() + "\n");
        }
        return buf.toString();
    }

    public static void resolve(String path, VirtualFolder[] folders) throws SeisException {
        VirtualFolders vf = VirtualFolders.factory(path);
        for (VirtualFolder folder : folders) {
            vf.addFolder(path, folder);
        }
        for (VirtualFolder existingFolder : vf.getFolders()) {
            boolean found = false;
            for (VirtualFolder folder : folders) {
                if (!folder.equals(existingFolder)) continue;
                existingFolder.setAttribute(folder.getAttribute());
                found = true;
                break;
            }
            if (found) continue;
            vf.removeFolder(path, existingFolder);
        }
        new File(path + File.separatorChar + VIRTUAL_FOLDERS_XML).delete();
        vf.store();
    }

    public Integer[] getIndexes(VirtualFolder.Attribute attrib) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this._folders.length; ++i) {
            if (!this._folders[i].getAttribute().equals((Object)attrib)) continue;
            indexes.add(i);
        }
        return indexes.toArray(new Integer[0]);
    }

    public ExtentPolicy getPolicy() {
        return this._policy;
    }

    public int getPsuedoRandom(int segmentIndex, int secondaryCount) {
        long seed = this._datasetPath.hashCode();
        Random r = new Random(seed);
        int start = r.nextInt(secondaryCount);
        int index = (start + segmentIndex) % secondaryCount;
        LOG.finer("VirtualFolders getPsuedoRandom index = " + index + " seed = " + seed + " segmentIndex = " + segmentIndex + " secoundaryCount = " + secondaryCount);
        return index;
    }

    public static ExtentPolicy extentPolicyFactory(String id) {
        ExtentPolicy policy = null;
        if (id.compareToIgnoreCase("MIN_MAX") == 0) {
            policy = new ExtentPolicyMinMax();
        } else if (id.compareToIgnoreCase("RANDOM") == 0) {
            policy = new ExtentPolicyRandom();
        } else if (id.compareToIgnoreCase("Folder1") == 0) {
            policy = new ExtentPolicyFolder1();
        } else if (id.compareToIgnoreCase("ExtentAllocationService") == 0) {
            policy = new ExtentPolicySrv();
        } else {
            throw new IllegalArgumentException("Policy " + id + " is not defined in ExtentManager");
        }
        return policy;
    }

    public static String[] listPolicies() {
        String[] list = new String[]{"RANDOM", "MIN_MAX"};
        return list;
    }
}

