/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.javaseis.io.ExtentList;
import org.javaseis.io.ExtentListEntry;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.JSUtilFile;
import org.javaseis.io.VirtualFolder;
import org.javaseis.io.VirtualFolders;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.util.SeisException;

public class ExtentManager {
    private static final String vfioVersion = "2006.2";
    private static final String vfioHeader = "VFIO org.javaseis.io.ExtentManager 2006.2";
    public static final String EXTENT_MANAGER_PARSET_NAME = "ExtentManager";
    private static final String VFIO_VERSION = "VFIO_VERSION";
    private static final String VFIO_EXTSIZE = "VFIO_EXTSIZE";
    private static final String VFIO_MAXFILE = "VFIO_MAXFILE";
    private static final String VFIO_MAXPOS = "VFIO_MAXPOS";
    private static final String VFIO_EXTNAME = "VFIO_EXTNAME";
    private static final String VFIO_POLICY = "VFIO_POLICY";
    private ParameterSet _extentParameters;
    private ExtentList _extentList;
    private VirtualFolders _vFolders;
    private String _vfioExtentBaseName;
    private long _vfioMaxPosition;
    private int _vfioMaxFiles;
    private long _vfioExtentSize;
    private boolean _readOnly = false;
    private boolean _trackTime = false;
    private String _vfolderFile;
    private static final Logger LOG = Logger.getLogger(ExtentManager.class.getName());

    public ExtentManager(String virtualFileProperties, String mode, VirtualFolders vFolders) throws SeisException {
        if (virtualFileProperties == null || virtualFileProperties.length() == 0) {
            throw new IllegalArgumentException("virtualFileProperties is not valid");
        }
        if (mode == null || mode.length() == 0) {
            throw new IllegalArgumentException("mode is not valid");
        }
        if (vFolders == null) {
            throw new IllegalArgumentException("vFolders argument is null");
        }
        this._vfolderFile = virtualFileProperties;
        if (mode.equals("r") || mode.equals("R")) {
            this._readOnly = true;
        }
        try {
            this._extentParameters = ParameterSetIO.readFile(virtualFileProperties);
        }
        catch (IOException e) {
            throw new SeisException("ExtentManager: could not load virtualFileProperties: " + virtualFileProperties + "\n" + e.getMessage());
        }
        this.load(this._extentParameters);
        this._vFolders = vFolders;
        this._extentList = new ExtentList(this._vfioExtentBaseName, this._vfioMaxFiles, this._vfioMaxPosition, this._vfioExtentSize, this._vFolders, this._readOnly);
        this._extentList.load();
    }

    public ExtentManager(String virtualFileProperties, String extentBaseName, VirtualFolders vFolders, long fileLength, int numExtents, long frameSize) throws SeisException {
        if (virtualFileProperties == null || virtualFileProperties.length() == 0) {
            throw new IllegalArgumentException("virtualFileProperties is not valid");
        }
        if (extentBaseName == null || extentBaseName.length() == 0) {
            throw new IllegalArgumentException("extentBaseName is not valid");
        }
        if (numExtents <= 0) {
            throw new IllegalArgumentException("Invalid number of extents");
        }
        if (fileLength <= 0L) {
            throw new IllegalArgumentException("Invalid file length");
        }
        this._vfolderFile = virtualFileProperties;
        this._vFolders = vFolders;
        this._extentParameters = new ParameterSet(EXTENT_MANAGER_PARSET_NAME);
        this._vfioExtentBaseName = extentBaseName;
        this._vfioExtentSize = this.computeExtentSize(fileLength, numExtents, frameSize);
        this._readOnly = false;
        this._extentList = new ExtentList(extentBaseName, numExtents, fileLength, this._vfioExtentSize, vFolders, this._readOnly);
        this._vfioMaxFiles = numExtents;
        this._vfioMaxPosition = fileLength;
        this.store(this._extentParameters);
        this.create(virtualFileProperties, vFolders);
    }

    private long computeExtentSize(long fileLength, int numExtents, long frameSize) {
        assert (fileLength > 0L);
        assert (numExtents > 0);
        assert (frameSize > 0L);
        long extentCreateSize = fileLength / (long)numExtents;
        if (fileLength % (long)numExtents != 0L) {
            ++extentCreateSize;
        }
        long fact = extentCreateSize / frameSize;
        if (extentCreateSize % frameSize != 0L) {
            ++fact;
        }
        extentCreateSize = frameSize * fact;
        return extentCreateSize;
    }

    private void create(String virtualFileProperties, VirtualFolders vFolders) throws SeisException {
        assert (virtualFileProperties != null && virtualFileProperties.length() > 0);
        assert (vFolders != null);
        VirtualFolder[] dirs = vFolders.getFolders();
        for (int i = 0; i < dirs.length; ++i) {
            File file = new File(dirs[i].getPath());
            if (!file.isDirectory()) {
                throw new SeisException("Path is not a directory: " + file.getAbsolutePath());
            }
            if (file.canWrite()) continue;
            throw new SeisException("Cannot write in directory: " + file.getAbsolutePath());
        }
        try {
            ParameterSetIO.writeFile(this._extentParameters, virtualFileProperties);
        }
        catch (IOException e) {
            throw new SeisException(e.toString());
        }
    }

    private void store(ParameterSet parameterSet) {
        parameterSet.setString(VFIO_VERSION, vfioVersion);
        parameterSet.setLong(VFIO_EXTSIZE, this._vfioExtentSize);
        parameterSet.setInt(VFIO_MAXFILE, this._vfioMaxFiles);
        parameterSet.setLong(VFIO_MAXPOS, this._vfioMaxPosition);
        parameterSet.setString(VFIO_EXTNAME, this._vfioExtentBaseName);
        parameterSet.setString(VFIO_POLICY, this._vFolders.getPolicy().getID());
    }

    private void load(ParameterSet parameterSet) throws SeisException {
        ParameterSetIO.checkRequiredParameter(parameterSet, VFIO_VERSION);
        this._vfioMaxPosition = ParameterSetIO.getRequiredLong(parameterSet, VFIO_MAXPOS);
        this._vfioExtentBaseName = ParameterSetIO.getRequiredString(parameterSet, VFIO_EXTNAME);
        this._vfioExtentSize = ParameterSetIO.getRequiredLong(parameterSet, VFIO_EXTSIZE);
        this._vfioMaxFiles = ParameterSetIO.getRequiredInt(parameterSet, VFIO_MAXFILE);
    }

    public ExtentPolicy getExtentPolicy() {
        return this._vFolders.getPolicy();
    }

    String getBaseName() {
        return this._vfioExtentBaseName;
    }

    public ExtentListEntry getExtent(long position) throws SeisException {
        return this._extentList.getExtent(position);
    }

    public ExtentListEntry[] getExtents() {
        return this._extentList.getExtents();
    }

    static boolean delete(String basePath, VirtualFolders vFolders, boolean removeBase) {
        JSUtilFile ufile;
        boolean ok = true;
        JSUtilFile jSUtilFile = ufile = basePath != null ? new JSUtilFile(basePath) : null;
        if (vFolders != null) {
            for (VirtualFolder folder : vFolders.getFolders()) {
                JSUtilFile vdir;
                String dir = folder.getPath();
                if (dir.equals(basePath) || !(vdir = new JSUtilFile(dir)).exists()) continue;
                ok &= vdir.recursiveDelete();
            }
        }
        if (ok && removeBase && ufile != null && ufile.exists()) {
            ok &= ufile.recursiveDelete();
        }
        return ok;
    }

    public boolean delete() {
        boolean ok = ExtentManager.delete(null, this._vFolders, true);
        if (ok) {
            ok = new File(this._vfolderFile).delete();
        }
        return ok;
    }

    public void close() throws SeisException {
        this._extentList = null;
        this._vFolders = null;
    }

    public static void main(String[] args) throws SeisException {
    }

    public float getLockTime() {
        return this._extentList.getLockTime();
    }

    public float getLoadTime() {
        return this._extentList.getLoadTime();
    }

    public void trackTime(boolean flag) {
        this._trackTime = flag;
        this._extentList.trackTime(flag);
    }
}

