/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.examples;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.util.Iterator;
import org.javaseis.fft.SeisFft2d;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.Seisio;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.util.SeisException;

public class Compute2Dfft {
    public static void main(String[] args) throws SeisException {
        int i;
        int j;
        int ntrc;
        ParameterSet parset = ParameterSetIO.argsToParameters(args);
        String path = parset.getString("path", System.getProperty("user.home") + File.separator + "jsCreateTest");
        System.out.println("Calculate 2D FFT for frames in a JavaSeis dataset\nPath: " + path);
        Seisio sio = new Seisio(path);
        sio.open("r");
        GridDefinition grid = sio.getGridDefinition();
        int n0 = (int)grid.getAxisLength(0);
        int n1 = (int)grid.getAxisLength(1);
        new SeisFft2d(n0, n1, 0.0f, 0.0f);
        float[][] trc = sio.getTraceDataArray();
        Iterator<int[]> frames = sio.frameIterator();
        double rms = 0.0;
        double sum = 0.0;
        while (frames.hasNext()) {
            frames.next();
            ntrc = sio.getTracesInFrame();
            for (j = 0; j < ntrc; ++j) {
                for (i = 0; i < trc[j].length; ++i) {
                    sum += 1.0;
                    rms += (double)(trc[j][i] * trc[j][i]);
                }
            }
        }
        rms = Math.sqrt(rms / sum);
        System.out.println("RMS Value of dataset = " + rms);
        frames = sio.frameIterator();
        rms = 0.0;
        sum = 0.0;
        while (frames.hasNext()) {
            frames.next();
            ntrc = sio.getTracesInFrame();
            for (j = 0; j < ntrc; ++j) {
                for (i = 0; i < trc[j].length; ++i) {
                    sum += 1.0;
                    rms += (double)(trc[j][i] * trc[j][i]);
                }
            }
        }
        rms = Math.sqrt(rms / sum);
        System.out.println("RMS Value of dataset = " + rms);
    }
}

