/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.Certicom;
import com.certicom.ecc.jcae.ExtendedSecureRandom;
import com.certicom.ecc.jcae.SHA1RNGSpi;
import com.certicom.ecc.jcae.SHA224RNGSpi;
import com.certicom.ecc.jcae.SHA256RNGSpi;
import com.certicom.ecc.jcae.SHA384RNGSpi;
import com.certicom.ecc.jcae.SHA512RNGSpi;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import com.certicom.ecc.util.DRBG;
import com.certicom.ecc.util.Random;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;

public class RNGSpi
extends ExtendedSecureRandom.ExtendedSecureRandomSpi
implements Serializable {
    private static final long serialVersionUID = 2195798257910487884L;
    private Random b;
    private DRBG c;
    private boolean d = false;
    static Class a;

    protected RNGSpi(String string) {
        this.c = (DRBG)CryptoManager.getInstance(a == null ? (a = RNGSpi.a("com.certicom.ecc.util.DRBG")) : a, string);
        this.b = this.c;
        this.d = true;
    }

    protected void a(boolean bl, DRBG.SeedingSource seedingSource, byte[] byArray, byte[] byArray2) throws IllegalStateException {
        if (this.c == null) {
            throw new IllegalStateException("Not a DRBG");
        }
        this.c.init(bl, seedingSource, byArray, byArray2);
    }

    protected void a(byte[] byArray, byte[] byArray2) {
        if (this.c == null) {
            throw new IllegalStateException("Not a DRBG");
        }
        this.c.nextBytes(byArray, byArray2);
    }

    protected void a(byte[] byArray) {
        if (this.c != null) {
            if (byArray == null) {
                this.c.drbgReseed();
            } else {
                this.c.drbgReseed(byArray);
            }
        } else {
            throw new IllegalStateException("Not a DRBG");
        }
    }

    public RNGSpi() {
        this.b = new Random();
    }

    protected byte[] engineGenerateSeed(int n2) {
        return Random.generateSeed(n2);
    }

    protected void engineNextBytes(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("buffer is null");
        }
        if (!this.d) {
            byte[] byArray2 = this.engineGenerateSeed(20);
            this.engineSetSeed(byArray2);
        }
        this.b.nextBytes(byArray);
    }

    protected void engineSetSeed(byte[] byArray) {
        this.b.addSeed(byArray);
        this.d = true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(this.c);
        objectOutputStream.writeBoolean(this.d);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.b = (Random)objectInputStream.readObject();
        this.c = (DRBG)objectInputStream.readObject();
        this.d = objectInputStream.readBoolean();
    }

    static SecureRandom a() {
        int n2 = SystemConfig.getConfig().getSecurityStrength();
        if (n2 <= 80) {
            return new SecureRandomWrapper(new SHA1RNGSpi());
        }
        if (n2 <= 112) {
            return new SecureRandomWrapper(new SHA224RNGSpi());
        }
        if (n2 <= 128) {
            return new SecureRandomWrapper(new SHA256RNGSpi());
        }
        if (n2 <= 192) {
            return new SecureRandomWrapper(new SHA384RNGSpi());
        }
        return new SecureRandomWrapper(new SHA512RNGSpi());
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SecureRandomWrapper
    extends SecureRandom {
        public SecureRandomWrapper(SecureRandomSpi secureRandomSpi) {
            super(secureRandomSpi, Certicom.a());
        }
    }
}

