/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.BlockCipherSpi;
import com.certicom.ecc.jcae.RNGSpi;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public final class ARC2CipherSpi
extends BlockCipherSpi {
    static Class h;
    static Class j;

    public ARC2CipherSpi() {
        super((CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "ARC2"), "ARC2");
    }

    protected final int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey && (key.getAlgorithm().equals("ARC2") || key.getAlgorithm().equals("RC2"))) {
            int n2 = key.getEncoded().length;
            if (n2 > 128) {
                throw new InvalidKeyException("Invalid ARC2 key length.");
            }
            return n2 * 8;
        }
        throw new InvalidKeyException("Invalid ARC2 key.");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void a(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof SecretKey)) throw new InvalidKeyException("wrong key");
        if (!key.getAlgorithm().equals("ARC2") && !key.getAlgorithm().equals("RC2")) {
            throw new InvalidKeyException("wrong key");
        }
        byte[] byArray = key.getEncoded();
        if (byArray.length > 128) throw new InvalidKeyException("wrong key");
        if (byArray.length < 1) {
            throw new InvalidKeyException("wrong key");
        }
        this.b[0] = this.e;
        this.b[1] = new Integer(byArray.length * 8);
        this.b[2] = byArray;
        if (algorithmParameterSpec == null) {
            if (this.e.equals("ECB")) return;
            if (this.c == 4) {
                throw new InvalidAlgorithmParameterException("wrong params");
            }
            byte[] byArray2 = new byte[this.engineGetBlockSize()];
            if (this.d == null) {
                RNGSpi.a().nextBytes(byArray2);
            } else {
                this.d.nextBytes(byArray2);
            }
            this.b[3] = byArray2;
            return;
        }
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("wrong params");
            if (this.e.equalsIgnoreCase("ECB")) throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
            this.b[3] = ((IvParameterSpec)algorithmParameterSpec).getIV();
            return;
        }
        RC2ParameterSpec rC2ParameterSpec = (RC2ParameterSpec)algorithmParameterSpec;
        int n2 = rC2ParameterSpec.getEffectiveKeyBits();
        this.b[1] = new Integer(n2);
        if (!this.e.equalsIgnoreCase("ECB")) {
            this.b[3] = rC2ParameterSpec.getIV();
            return;
        }
        if (rC2ParameterSpec.getIV() == null) return;
        throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
    }

    protected Class[] b() {
        return new Class[]{h == null ? (h = ARC2CipherSpi.a("javax.crypto.spec.RC2ParameterSpec")) : h, j == null ? (j = ARC2CipherSpi.a("javax.crypto.spec.IvParameterSpec")) : j};
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = AlgorithmParameters.getInstance("RC2");
            if (this.b[1] == null || this.b[3] == null) {
                return null;
            }
            algorithmParameters.init(new RC2ParameterSpec((Integer)this.b[1], (byte[])this.b[3]));
        }
        catch (Exception exception) {
            return null;
        }
        return algorithmParameters;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

