/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import edu.mines.jtk.util.ParameterSet;
import java.util.Random;
import mpi.MPI;
import mpi.MPIException;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.parallel.MPIContext;
import org.javaseis.parset.ParameterSetIO;

public class CommunicationBenchmark {
    public static void runTransposeBenchmark(IParallelContext pc, int bufsize, int count) throws MPIException {
        int rank = pc.rank();
        int size = pc.size();
        pc.masterPrint("JavaSeis Transpose Communication Benchmark");
        pc.masterPrint("\nBuffer size: " + bufsize + "\nIteration count: " + count);
        float[] buf = new float[bufsize];
        Random r = new Random();
        for (int i = 0; i < bufsize; ++i) {
            buf[i] = r.nextFloat();
        }
        int n1p = bufsize / size;
        float[] fbuf = new float[n1p];
        pc.barrier();
        double t0 = MPI.Wtime();
        for (int j = 0; j < count; ++j) {
            pc.ttranFloat(n1p, buf, 0, fbuf);
        }
        pc.barrier();
        double et = MPI.Wtime() - t0;
        double mbytes = (double)count * (double)bufsize / 262144.0;
        double rate = mbytes / et;
        double mbTot = mbytes * (double)size;
        double rateTot = rate * (double)size;
        pc.masterPrint("\nTranspose summary results:");
        if (rank == 0) {
            System.out.format("  Time, sec    = %8.2f\n", et);
            System.out.format("  Mb per task  = %8.2f\n", mbytes);
            System.out.format("  Mb/task/sec  = %8.2f\n", rate);
            System.out.format("  Mbytes total = %8.2f\n", mbTot);
            System.out.format("  Mb/sec total = %8.2f\n", rateTot);
        }
        pc.masterPrint("\n");
        pc.barrier();
    }

    public static void runBroadcastBenchmark(IParallelContext pc, int bufsize, int count) throws MPIException {
        int rank = pc.rank();
        int size = pc.size();
        pc.masterPrint("JavaSeis Broadcast Communication Benchmark");
        pc.masterPrint("\nBuffer size: " + bufsize + "\nIteration count: " + count);
        float[] buf = new float[bufsize];
        Random r = new Random();
        for (int i = 0; i < bufsize; ++i) {
            buf[i] = r.nextFloat();
        }
        pc.barrier();
        double t0 = MPI.Wtime();
        for (int j = 0; j < count; ++j) {
            pc.bcastFloat(99, buf, 0, bufsize, 0);
        }
        pc.barrier();
        double et = MPI.Wtime() - t0;
        double mbytes = (double)count * (double)bufsize / 262144.0;
        double rate = mbytes / et;
        double mbTot = mbytes * (double)size;
        double rateTot = rate * (double)size;
        pc.masterPrint("\nBroadcast summary results:");
        if (rank == 0) {
            System.out.format("  Time, sec    = %8.2f\n", et);
            System.out.format("  Mb per task  = %8.2f\n", mbytes);
            System.out.format("  Mb/task/sec  = %8.2f\n", rate);
            System.out.format("  Mbytes total = %8.2f\n", mbTot);
            System.out.format("  Mb/sec total = %8.2f\n", rateTot);
        }
        pc.masterPrint("\n");
        pc.barrier();
    }

    public static void main(String[] args) throws MPIException {
        MPIContext pc = new MPIContext();
        pc.init(args);
        int rank = pc.rank();
        int size = pc.size();
        String className = pc.getClass().toString();
        pc.masterPrint(className);
        pc.masterPrint("JavaSeis Communication Benchmarks");
        pc.serialPrint(MPI.Get_processor_name() + " Task " + rank);
        ParameterSet parset = ParameterSetIO.argsToParameters(args);
        String s = parset.getString("size", "1024k");
        int len = s.length();
        int bufsize = 0;
        bufsize = s.charAt(len - 1) == 'k' ? Integer.parseInt(s.substring(0, len - 1)) * 1024 : (s.charAt(len - 1) == 'm' ? Integer.parseInt(s.substring(0, len - 1)) * 1024 * 1024 : Integer.parseInt(s));
        int count = parset.getInt("count", 10);
        CommunicationBenchmark.runBroadcastBenchmark(pc, bufsize, count);
        CommunicationBenchmark.runTransposeBenchmark(pc, bufsize, count);
        pc.finish();
    }
}

