/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import mpi.MPIException;
import org.javaseis.io.SortIOParms;
import org.javaseis.io.SortMapIO;
import org.javaseis.io.test.JTestSortMapIO;
import org.javaseis.parallel.Decomposition;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.parallel.MPIContext;
import org.javaseis.parallel.UniprocessorContext;

public class TestSortmapIOParallel {
    private static final Logger LOG = Logger.getLogger(TestSortmapIOParallel.class.getName());

    public TestSortmapIOParallel(String[] args) throws MPIException, IOException {
        IParallelContext pc = null;
        try {
            pc = new MPIContext();
            pc.init(args);
        }
        catch (UnsatisfiedLinkError e) {
            LOG.warning("MPI libraries not found, using UniProcessorContext");
            pc = new UniprocessorContext();
        }
        pc.masterPrint(LOG, "Parallel Sortmap write Tests");
        int size = pc.size();
        int nVolumes = 3 * size;
        int nFrames = 5;
        int nTracesPerFrame = 97;
        SortIOParms parms = null;
        Object[] strings = new String[2];
        if (pc.rank() == 0) {
            File out = File.createTempFile("sortmap_test", "js");
            out.delete();
            out.mkdir();
            strings[0] = out.getAbsolutePath();
            strings[1] = System.currentTimeMillis() + "";
            parms = JTestSortMapIO.createParms((String)strings[0], (String)strings[1], nVolumes, nFrames, nTracesPerFrame);
            LOG.info("Creating sortmap definition");
        }
        pc.barrier();
        int tag = 1121;
        pc.bcast(tag, strings, 0, 2, 0);
        LOG.info("strings = " + Arrays.toString(strings));
        Decomposition decomp = new Decomposition(Decomposition.BLOCK, nVolumes, pc);
        int[] range = decomp.getIndexRange();
        LOG.info("range = " + Arrays.toString(range));
        JTestSortMapIO.write((String)strings[0], (String)strings[1], range[0], range[1], range[1] - range[0] + 1, nFrames, nTracesPerFrame);
        pc.barrier();
        if (pc.rank() == 0) {
            JTestSortMapIO.validate((String)strings[0], (String)strings[1], parms);
            SortMapIO.delete((String)strings[0]);
            new File((String)strings[0]).delete();
        }
        pc.barrier();
        pc.finish();
        LOG.info("Completed");
    }

    public static void main(String[] args) throws Exception {
        new TestSortmapIOParallel(args);
    }
}

