/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import java.io.File;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.logging.Logger;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.javaseis.io.TraceMap;
import org.javaseis.tests.TestUtil;
import org.javaseis.util.SeisException;

public class JTestTraceMapBuffering
extends TestCase {
    private static final Logger LOG = Logger.getLogger(JTestTraceMapBuffering.class.getName());
    private static final int MULTIPLIER = 10;

    public void test4DNoBuffering() throws SeisException {
        String folder = TestUtil.getFolder("TestMap-Test");
        this.test4D(50L, 30L, folder, "w");
        JTestTraceMapBuffering.assertTrue((JTestTraceMapBuffering.getSizeAndRemove(folder) == 6000L ? 1 : 0) != 0);
    }

    public void test4DWithBuffering() throws SeisException {
        String folder = TestUtil.getFolder("TestMap-Test");
        this.test4D(50L, 30L, folder, "wb");
        JTestTraceMapBuffering.assertTrue((JTestTraceMapBuffering.getSizeAndRemove(folder) == 6000L ? 1 : 0) != 0);
    }

    public void test4DWithBufferingCircular() throws SeisException {
        String folder = TestUtil.getFolder("TestMap-Test");
        this.test4DCircularDecomp(50L, 30L, folder, "wb");
        JTestTraceMapBuffering.assertTrue((JTestTraceMapBuffering.getSizeAndRemove(folder) == 6000L ? 1 : 0) != 0);
    }

    public void test4DWR() throws SeisException {
        String folder = TestUtil.getFolder("TestMap-Test");
        this.test4DWriteAndRead(50L, 30L, folder, "wb");
        JTestTraceMapBuffering.assertTrue((JTestTraceMapBuffering.getSizeAndRemove(folder) == 6000L ? 1 : 0) != 0);
    }

    private void test4D(long nVolumes, long nFrames, String path, String writeMode) throws SeisException {
        int fold;
        int ifrm;
        int numDiminsions = 4;
        long[] axisLengths = new long[numDiminsions];
        axisLengths[3] = nVolumes;
        axisLengths[2] = nFrames;
        int[] position = new int[numDiminsions];
        Arrays.fill(position, 0);
        TraceMap tm = new TraceMap(axisLengths, ByteOrder.LITTLE_ENDIAN, path, writeMode);
        tm.intializeTraceMapOnDisk();
        int ivol = 0;
        while ((long)ivol < nVolumes) {
            ifrm = 0;
            while ((long)ifrm < nFrames) {
                fold = ivol + ifrm;
                position[3] = ivol;
                position[2] = ifrm++;
                tm.putFold(position, fold);
                int foldCheck = tm.getFold(position);
                JTestTraceMapBuffering.assertEquals((int)fold, (int)foldCheck);
            }
            ++ivol;
        }
        tm.close();
        LOG.info("Start validation step");
        tm = new TraceMap(axisLengths, ByteOrder.LITTLE_ENDIAN, path, "r");
        ivol = 0;
        while ((long)ivol < nVolumes) {
            ifrm = 0;
            while ((long)ifrm < nFrames) {
                position[3] = ivol;
                position[2] = ifrm;
                fold = tm.getFold(position);
                JTestTraceMapBuffering.assertTrue((fold == ivol + ifrm ? 1 : 0) != 0);
                ++ifrm;
            }
            ++ivol;
        }
        tm.close();
        LOG.info("test4D (mode=" + writeMode + ")  SUCCESSFUL");
    }

    private void test4DCircularDecomp(long nVolumes, long nFrames, String path, String writeMode) throws SeisException {
        int fold;
        int numDiminsions = 4;
        long[] axisLengths = new long[numDiminsions];
        axisLengths[3] = nVolumes;
        axisLengths[2] = nFrames;
        int[] position = new int[numDiminsions];
        Arrays.fill(position, 0);
        TraceMap tm = new TraceMap(axisLengths, ByteOrder.LITTLE_ENDIAN, path, writeMode);
        tm.intializeTraceMapOnDisk();
        int ifrm = 0;
        while ((long)ifrm < nFrames) {
            int ivol = 0;
            while ((long)ivol < nVolumes) {
                fold = ivol + ifrm;
                position[3] = ivol++;
                position[2] = ifrm;
                tm.putFold(position, fold);
                int foldCheck = tm.getFold(position);
                JTestTraceMapBuffering.assertEquals((int)fold, (int)foldCheck);
            }
            ++ifrm;
        }
        tm.close();
        LOG.info("Start validation step");
        tm = new TraceMap(axisLengths, ByteOrder.LITTLE_ENDIAN, path, "r");
        int ivol = 0;
        while ((long)ivol < nVolumes) {
            int ifrm2 = 0;
            while ((long)ifrm2 < nFrames) {
                position[3] = ivol;
                position[2] = ifrm2;
                fold = tm.getFold(position);
                JTestTraceMapBuffering.assertTrue((fold == ivol + ifrm2 ? 1 : 0) != 0);
                ++ifrm2;
            }
            ++ivol;
        }
        tm.close();
        LOG.info("test4D emulate circular decomposition (mode=" + writeMode + ")  SUCCESSFUL");
    }

    private void test4DWriteAndRead(long nVolumes, long nFrames, String path, String writeMode) throws SeisException {
        int fold;
        int ifrm;
        int numDiminsions = 4;
        long[] axisLengths = new long[numDiminsions];
        axisLengths[3] = nVolumes;
        axisLengths[2] = nFrames;
        int[] position = new int[numDiminsions];
        Arrays.fill(position, 0);
        TraceMap tm = new TraceMap(axisLengths, ByteOrder.LITTLE_ENDIAN, path, writeMode);
        tm.intializeTraceMapOnDisk();
        boolean count = false;
        int ivol = 0;
        while ((long)ivol < nVolumes) {
            ifrm = 0;
            while ((long)ifrm < nFrames) {
                fold = ivol + ifrm;
                position[3] = ivol;
                position[2] = ifrm++;
                tm.putFold(position, fold);
                int fold2 = tm.getFold(position);
                JTestTraceMapBuffering.assertEquals((int)fold, (int)fold2);
            }
            ++ivol;
        }
        tm.close();
        LOG.info("Start validation step");
        tm = new TraceMap(axisLengths, ByteOrder.LITTLE_ENDIAN, path, "r");
        ivol = 0;
        while ((long)ivol < nVolumes) {
            ifrm = 0;
            while ((long)ifrm < nFrames) {
                position[3] = ivol;
                position[2] = ifrm;
                fold = tm.getFold(position);
                JTestTraceMapBuffering.assertTrue((fold == ivol + ifrm ? 1 : 0) != 0);
                ++ifrm;
            }
            ++ivol;
        }
        tm.close();
        LOG.info("4D Write/Read (mode=" + writeMode + ") SUCCESSFUL");
    }

    private static long getSizeAndRemove(String path) {
        File f = new File(path, "TraceMap");
        if (!f.exists()) {
            return -1L;
        }
        long size = f.length();
        f.delete();
        return size;
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run(JTestTraceMapBuffering.class);
    }
}

