/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.util.ArrayList;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.VirtualFolder;
import org.javaseis.io.VirtualFolders;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.util.SeisException;

public class VirtualFoldersSS
extends VirtualFolders {
    public static final String TYPE = "SS";

    public VirtualFoldersSS(String path, ExtentPolicy policy) {
        this._datasetPath = path;
        this._policy = policy;
    }

    public VirtualFoldersSS(String datasetPath, String[] directories, ExtentPolicy policy) {
        if (datasetPath == null || datasetPath.length() < 1) {
            throw new IllegalArgumentException("Path to the dataset is invalid");
        }
        if (directories == null || directories.length < 1) {
            throw new IllegalArgumentException("Virtual folders cannot be null or zero length");
        }
        if (policy == null) {
            throw new IllegalArgumentException("The extent allocation policy cannot be null");
        }
        this._datasetPath = datasetPath;
        this._folders = new VirtualFolder[directories.length];
        this._policy = policy;
        for (int i = 0; i < directories.length; ++i) {
            this._folders[i] = new VirtualFolder(directories[i]);
        }
    }

    @Override
    public void store(ParameterSet parameterSet) throws SeisException {
        parameterSet.setInt("NDIR", this._folders.length);
        for (int i = 0; i < this._folders.length; ++i) {
            String fs = this._folders[i].getPath().equals(this._datasetPath) ? "." : new File(this._folders[i].getPath()).getParentFile().getParentFile().getParent();
            parameterSet.setString("FILESYSTEM-" + i, fs + "," + this._folders[i].getAttribute().toString());
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void load(ParameterSet parameterSet) throws SeisException {
        int count = ParameterSetIO.getRequiredInt(parameterSet, "NDIR");
        this._folders = new VirtualFolder[count];
        File tmp = new File(this._datasetPath);
        String dsName = tmp.getName();
        String line = tmp.getParentFile().getName();
        String area = tmp.getParentFile().getParentFile().getName();
        for (int i = 0; i < count; ++i) {
            VirtualFolder f = new VirtualFolder(ParameterSetIO.getRequiredString(parameterSet, "FILESYSTEM-" + i));
            if (f.getPath().equals(".")) {
                f.setPath(this._datasetPath);
            } else {
                f.addElement(area);
                f.addElement(line);
                f.addElement(dsName);
            }
            this._folders[i] = f;
        }
    }

    @Override
    public boolean addFolder(String path, VirtualFolder folder) {
        ArrayList<VirtualFolder> vfs = new ArrayList<VirtualFolder>();
        for (VirtualFolder vFolder : this._folders) {
            if (vFolder.equals(folder)) {
                return false;
            }
            vfs.add(vFolder);
        }
        vfs.add(folder);
        this._folders = vfs.toArray(new VirtualFolder[0]);
        return true;
    }

    @Override
    protected boolean removeFolder(String path, VirtualFolder folder) {
        if (folder.count() > 0) {
            return false;
        }
        File dir = new File(folder.getPath());
        dir.delete();
        dir = null;
        ArrayList<VirtualFolder> vfs = new ArrayList<VirtualFolder>();
        for (VirtualFolder vFolder : this._folders) {
            if (vFolder.equals(folder)) continue;
            vfs.add(vFolder);
        }
        this._folders = vfs.toArray(new VirtualFolder[0]);
        return true;
    }
}

