/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.logging.Logger;
import org.javaseis.compress.TraceCompressor;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.Seisio;
import org.javaseis.io.SortMapIO;
import org.javaseis.properties.AxisDefinition;
import org.javaseis.properties.AxisLabel;
import org.javaseis.properties.DataFormat;
import org.javaseis.util.SeisException;

public class SortRead {
    private static final Logger LOG = Logger.getLogger(SortRead.class.getName());
    public static final String FRAME_SORT_SECONDARY = "FrameSortSecondary";
    public static final String FRAME_SORT_TERTIARY = "FrameSortTertiary";
    public static final String FRAMEMAP_NAME = "SortFrameMap";
    public static final String PROPERTIES_NAME = "SortProperties";
    public static final String TRACEMAP_NAME = "SortTraceMap";
    public static final String VOLUMEMAP_NAME = "SortVolumeMap";
    public static final String PARAMETER_SET_NAME = "SortProperties";
    private Seisio _sio;
    private float[][] _traceData;
    private SortMapIO _sortmapIO;
    private ByteBuffer _sortReadtraceBuffer;
    private ByteBuffer _sortReadheaderBuffer;
    private TraceCompressor _traceCompressor;

    public SortRead(Seisio sioFile, String name, boolean open) throws SeisException {
        try {
            this._sortmapIO = new SortMapIO(sioFile.getBasePath(), name);
        }
        catch (IOException e) {
            throw new SeisException(e.getMessage());
        }
        if (open) {
            this._sio = sioFile;
            this._sortmapIO.open("r");
            ByteOrder byteOrder = this._sio.getDataDefinition().getByteOrder();
            int tracesPerFrame = this._sortmapIO.getNumTracesPerFrame();
            if (this._sio._usesHeaderProperties) {
                int headerLengthBytes = this._sio.getTraceProperties().getRecordLength();
                this._sortReadheaderBuffer = ByteBuffer.allocateDirect(tracesPerFrame * headerLengthBytes);
                this._sortReadheaderBuffer.order(byteOrder);
            }
        }
    }

    public SortRead(Seisio sioFile, String name) throws SeisException {
        this(sioFile, name, true);
    }

    private void allocTraceData() throws SeisException {
        if (this._traceData == null) {
            DataFormat traceFormat = this._sio.getDataDefinition().getTraceFormat();
            if (traceFormat == DataFormat.SEISPEG) {
                throw new SeisException("A dataset compressed using SeisPEG compression cannot be read using a sortmap\nInline Merge sort can be used to sort a SeisPEG compressed dataset in parallel");
            }
            int numSamples = (int)this._sio.getGridDefinition().getAxisLength(0);
            int traceLengthInBytes = TraceCompressor.getRecordLength(traceFormat, numSamples);
            ByteOrder byteOrder = this._sio.getDataDefinition().getByteOrder();
            int tracesPerFrame = this._sortmapIO.getNumTracesPerFrame();
            this._sortReadtraceBuffer = ByteBuffer.allocateDirect(tracesPerFrame * traceLengthInBytes);
            this._sortReadtraceBuffer.order(byteOrder);
            this._traceData = new float[tracesPerFrame][numSamples];
            this._traceCompressor = new TraceCompressor(traceFormat, numSamples, this._sortReadtraceBuffer);
        }
    }

    public int setLogicalPosition(int[] logicalPosition) throws SeisException {
        assert (logicalPosition.length == 4) : "Sort orders only supported for 4 dimensions";
        int n = this.setLogicalVolume(logicalPosition[3]);
        if (n == 0) {
            return 0;
        }
        return this.setLogicalFrame(logicalPosition[2]);
    }

    public int setLogicalVolume(int logicalVolumePosition) throws SeisException {
        int ivol = this._sortmapIO.findLogicalVolume(logicalVolumePosition);
        if (ivol < 0) {
            return 0;
        }
        return this._sortmapIO.setVolume(ivol);
    }

    public int setLogicalFrame(int logicalFramePosition) throws SeisException {
        int iframe = this._sortmapIO.findLogicalFrame(logicalFramePosition);
        if (iframe < 0) {
            return 0;
        }
        return this._sortmapIO.setFrame(iframe);
    }

    public float[][] getTraceDataArray() {
        try {
            this.allocTraceData();
        }
        catch (SeisException e) {
            e.printStackTrace();
            LOG.warning("getTraceDataArray() returns null.");
            return null;
        }
        return this._traceData;
    }

    public int readFrame() throws SeisException {
        this.allocTraceData();
        int tracesInFrame = this._sortmapIO.getCurrentTracesInFrame();
        if (tracesInFrame < 1) {
            throw new SeisException("Current position in sort order is invalid");
        }
        long[] traceList = this._sortmapIO.getCurrentTraceList();
        this._sio.readFrameScattered(tracesInFrame, traceList, this._sortReadtraceBuffer, this._sortReadheaderBuffer, this._traceCompressor, this._traceData);
        return tracesInFrame;
    }

    public int readFrameHdrs() throws SeisException {
        int tracesInFrame = this._sortmapIO.getCurrentTracesInFrame();
        if (tracesInFrame < 1) {
            throw new SeisException("Current position in sort order is invalid");
        }
        long[] traceList = this._sortmapIO.getCurrentTraceList();
        this._sio.readFrameHdrsScattered(tracesInFrame, traceList, this._sortReadheaderBuffer);
        return tracesInFrame;
    }

    public int getNumTracesPerFrame() {
        return this._sortmapIO.getNumTracesPerFrame();
    }

    public String getVolumeLabel() {
        return this._sortmapIO.getVolumeLabel();
    }

    public String getFrameLabel() {
        return this._sortmapIO.getFrameLabel();
    }

    public String getTraceLabel() {
        return this._sortmapIO.getTraceLabel();
    }

    public int getTraceLogicalOrigin() {
        return this._sortmapIO.getTraceLogicalOrigin();
    }

    public int getTraceRange() {
        return this._sortmapIO.getTraceRange();
    }

    public int getTraceLogicalDelta() {
        return this._sortmapIO.getTraceLogicalIncrement();
    }

    public int getFrameLogicalOrigin() {
        return this._sortmapIO.getFrameLogicalOrigin();
    }

    public int getFrameRange() {
        return this._sortmapIO.getFrameRange();
    }

    public int getFrameLogicalDelta() {
        return this._sortmapIO.getFrameLogicalIncrement();
    }

    public int getVolumeLogicalOrigin() {
        return this._sortmapIO.getVolumeLogicalOrigin();
    }

    public int getVolumeRange() {
        return this._sortmapIO.getVolumeRange();
    }

    public int getVolumeAxisLength() {
        return (int)Math.ceil((double)this.getVolumeRange() * 1.0 / (double)this._sortmapIO.getVolumeLogicalIncrement());
    }

    public int getFrameAxisLength() {
        return (int)Math.ceil((double)this._sortmapIO.getFrameRange() * 1.0 / (double)this._sortmapIO.getFrameLogicalIncrement());
    }

    public int getVolumeLogicalDelta() {
        return this._sortmapIO.getVolumeLogicalIncrement();
    }

    public void close() {
        this._sortmapIO.close();
    }

    public GridDefinition getGridDefinition(GridDefinition baseDatasetGrid) {
        int numDimensions = baseDatasetGrid.getNumDimensions();
        int numDimsOut = 4;
        String volumeLabel = this.getVolumeLabel();
        if (volumeLabel.isEmpty() || volumeLabel.compareToIgnoreCase("NONE") == 0) {
            numDimsOut = 3;
        }
        String frameLabel = this.getFrameLabel();
        AxisDefinition[] axis = new AxisDefinition[numDimsOut];
        axis[0] = baseDatasetGrid.getAxis(0);
        AxisDefinition originalTraceAxis = baseDatasetGrid.getAxis(1);
        AxisLabel axisLabel = originalTraceAxis.getLabel();
        String axis2 = this.getTraceLabel();
        long traceLogicalOrigin = originalTraceAxis.getLogicalOrigin();
        long traceLogicalDelta = this.getTraceLogicalDelta();
        long traceLogicalLength = this.getNumTracesPerFrame();
        float physicalOrigin = 0.0f;
        float physicalDelta = 1.0f;
        if (axis2 == null || axis2.length() == 0 || axis2.equals("NONE")) {
            axis2 = "SEQNO";
        }
        axisLabel = new AxisLabel(axis2, "");
        traceLogicalOrigin = axis2.equals("SEQNO") ? 1L : (long)this.getTraceLogicalOrigin();
        traceLogicalLength = this.getNumTracesPerFrame();
        axis[1] = new AxisDefinition(axisLabel, originalTraceAxis.getUnits(), originalTraceAxis.getDomain(), traceLogicalLength, traceLogicalOrigin, traceLogicalDelta, physicalOrigin, physicalDelta);
        AxisDefinition originalFrameAxis = baseDatasetGrid.getAxis(2);
        axis[2] = new AxisDefinition(new AxisLabel(this.getFrameLabel(), ""), originalFrameAxis.getUnits(), originalFrameAxis.getDomain(), this.getFrameAxisLength(), this.getFrameLogicalOrigin(), this.getFrameLogicalDelta(), 0.0, 1.0);
        if (numDimsOut > 3) {
            if (numDimensions > 3) {
                AxisDefinition originalVolumeAxis = baseDatasetGrid.getAxis(3);
                axis[3] = new AxisDefinition(new AxisLabel(this.getVolumeLabel(), ""), originalVolumeAxis.getUnits(), originalVolumeAxis.getDomain(), this.getVolumeAxisLength(), this.getVolumeLogicalOrigin(), this.getVolumeLogicalDelta(), 0.0, 1.0);
            } else {
                axis[3] = new AxisDefinition(new AxisLabel(this.getVolumeLabel(), ""), originalFrameAxis.getUnits(), originalFrameAxis.getDomain(), this.getVolumeAxisLength(), this.getVolumeLogicalOrigin(), this.getVolumeLogicalDelta(), 0.0, 1.0);
            }
        }
        return new GridDefinition(numDimsOut, axis);
    }

    public void readTraceMap(int[][] storage) throws SeisException {
        int framesPerVolume = this._sortmapIO.getNumUniqueFramesPerVolume();
        int volumes = this._sortmapIO.getNumUniqueVolumes();
        int minLogVol = this._sortmapIO.getParms().minLogVol;
        int maxLogVol = this._sortmapIO.getParms().maxLogVol;
        int volumeInc = this._sortmapIO.getParms().logVolInc;
        int minLogFrm = this._sortmapIO.getParms().minLogFrm;
        int maxLogFrm = this._sortmapIO.getParms().maxLogFrm;
        int frameInc = this._sortmapIO.getParms().logFrmInc;
        int[] buf = new int[2];
        if (storage == null) {
            throw new IllegalArgumentException("Tracemap array cannot be null");
        }
        for (int lvol = minLogVol; lvol <= maxLogVol; lvol += volumeInc) {
            long framesInVolume = this.setLogicalVolume(lvol);
            int arrayVolumeIndex = (lvol - minLogVol) / volumeInc;
            Arrays.fill(storage[arrayVolumeIndex], 0);
            if (framesInVolume <= 0L) continue;
            int i = 0;
            while ((long)i < framesInVolume) {
                this._sortmapIO.getFrameDetails(i, buf);
                int lfrm = buf[0];
                int fold = buf[1];
                int frameArrayIndex = lfrm - minLogFrm;
                if (frameArrayIndex % frameInc == 0) {
                    frameArrayIndex = (lfrm - minLogFrm) / frameInc;
                    storage[arrayVolumeIndex][frameArrayIndex] = fold;
                }
                ++i;
            }
        }
    }

    public static boolean exists(String path, String name) {
        return SortMapIO.exists(path, name);
    }

    public static boolean exists(Seisio sio, String name) {
        return SortRead.exists(sio.getBasePath(), name);
    }

    public static String[] list(String path) {
        return SortMapIO.list(path);
    }

    public static String[] list(Seisio seisio) {
        return SortRead.list(seisio.getBasePath());
    }

    public String[] getFrameSortParms() {
        return this._sortmapIO.getFrameSortParms();
    }

    public static boolean delete(String path, String name) {
        return SortMapIO.delete(path, name);
    }

    public static boolean delete(String path) {
        return SortMapIO.delete(path);
    }

    public static void main(String[] args) throws SeisException {
        if (args.length == 0) {
            System.out.println("usage path_to_dataset sormap_name volume, frame");
            System.exit(1);
        }
        String path = args[0];
        String name = args[1];
        assert (Seisio.isJavaSeis(path)) : "Could not find " + path;
        Seisio sio = new Seisio(path);
        try {
            sio.open("r");
        }
        catch (SeisException e) {
            throw new SeisException("Could not open " + path + "\n" + e.getMessage() + "\n");
        }
        SortRead sortRead = new SortRead(sio, name);
        int[][] foldmap = new int[sortRead.getVolumeRange()][sortRead.getFrameRange()];
        sortRead.readTraceMap(foldmap);
        int lvolMin = sortRead.getVolumeLogicalOrigin();
        int lframeMin = sortRead.getFrameLogicalOrigin();
        for (int i = 0; i < args.length - 2; ++i) {
            String str = args[i + 2];
            System.out.println(str);
            String[] parts = str.split(",");
            int lvol = Integer.parseInt(parts[0]);
            int lframe = Integer.parseInt(parts[1]);
            System.out.println("Looking for volume=" + lvol + " and frame = " + lframe);
            int framesInVol = sortRead.setLogicalVolume(lvol);
            System.out.println("Live Frames in Volume = " + framesInVol);
            if (framesInVol == 0) continue;
            int fold = sortRead.setLogicalFrame(lframe);
            int fm_fold = foldmap[lvol - lvolMin][lframe - lframeMin];
            System.out.println("setLogicalFrame returned " + fold + " foldmap returned " + fm_fold);
            assert (fold == foldmap[lvol - lvolMin][lframe - lframeMin]);
            if (fold > 0) {
                System.out.println("logical volume = " + lvol + " logical Frame = " + lframe + " fold = " + fold);
                int tracesread = sortRead.readFrame();
                System.out.println("fold = " + fold + " traces read = " + tracesread);
                assert (fold == tracesread);
            }
            System.out.println("fold from foldmap = " + foldmap[lvol - lvolMin][lframe - lframeMin]);
            if (fold <= 0) continue;
            long[] traceList = sortRead._sortmapIO.getCurrentTraceList();
            System.out.println(Arrays.toString(traceList));
        }
    }

    public ByteBuffer getHeaderBuffer() {
        return this._sortReadheaderBuffer;
    }
}

