/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.logging.Logger;
import org.javaseis.io.ISeisLock;
import org.javaseis.util.SeisException;

public class SeisLock
implements ISeisLock {
    public static String EXTN = ".lock";
    private RandomAccessFile lockFile;
    private String _path;
    private int retry;
    private long maxSleep;
    private boolean isLocked;
    private boolean trackTime = false;
    private long lockTime = 0L;
    private long t0 = 0L;
    private FileChannel fc;
    private FileLock fl;
    private static final Logger log = Logger.getLogger(SeisLock.class.getName());

    public SeisLock(String path) throws SeisException {
        this(path, 8, 100L);
    }

    public SeisLock(String path, int retryCount) throws SeisException {
        this(path, retryCount, 100L);
    }

    public SeisLock(String path, int retryCount, long maxsleep) throws SeisException {
        if (path == null || path.length() < 1) {
            throw new IllegalArgumentException("Invalid path");
        }
        this._path = path + EXTN;
        this.isLocked = false;
        if (retryCount < 1) {
            throw new IllegalArgumentException("Retry count parameter is invalid");
        }
        this.retry = retryCount;
        this.maxSleep = maxsleep > 10000L ? 10000L : maxsleep;
        try {
            this.lockFile = new RandomAccessFile(this._path, "rw");
            this.fc = this.lockFile.getChannel();
        }
        catch (FileNotFoundException e) {
            throw new SeisException(e.toString());
        }
    }

    @Override
    public boolean lock() throws SeisException {
        if (this.isLocked) {
            throw new SeisException("File already locked by this process" + this._path);
        }
        if (this.trackTime) {
            this.t0 = System.nanoTime();
        }
        long isleep = 0L;
        this.isLocked = false;
        for (int i = 0; i < this.retry; ++i) {
            try {
                this.fl = this.fc.tryLock();
                if (this.fl != null) {
                    this.isLocked = true;
                    break;
                }
                log.info("Retry " + (i + 1) + " to obtain lock on file " + this._path);
                isleep = (long)((double)this.maxSleep * Math.random());
                try {
                    Thread.sleep(isleep);
                }
                catch (InterruptedException e) {
                    log.info("Retry " + (i + 1) + " interrupted");
                }
                continue;
            }
            catch (IOException ex) {
                log.info("Retry " + (i + 1) + " to obtain lock on file " + this._path);
                try {
                    Thread.sleep(isleep);
                    continue;
                }
                catch (InterruptedException e) {
                    log.info("Retry " + (i + 1) + " interrupted");
                }
            }
        }
        if (!this.isLocked) {
            log.severe("Could not obtain lock on file " + this._path);
        }
        if (this.trackTime) {
            this.lockTime += System.nanoTime() - this.t0;
        }
        return this.isLocked;
    }

    @Override
    public void release() throws SeisException {
        if (!this.isLocked) {
            log.severe("Attempt to release a lock that does not exist");
            return;
        }
        try {
            this.fl.release();
        }
        catch (IOException e) {
            throw new SeisException("Lock release failed: \n" + e.getMessage());
        }
        this.isLocked = false;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public void trackTime(boolean trackTime) {
        this.trackTime = trackTime;
    }

    @Override
    public float getTime() {
        return 1.0E-9f * (float)this.lockTime;
    }
}

