/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.ECA;
import com.certicom.ecc.ECFactory;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.scheme.KeyAgreement;
import com.certicom.ecc.spec.SharedInfoParameterSpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public final class ECDH
extends KeyAgreement
implements Serializable {
    private static final long serialVersionUID = 3158760549997981589L;
    private Boolean e = null;

    public ECDH() {
        super("ECDH");
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        if (n2 != 6 && n2 != 7 || objectArray == null || objectArray.length < 2) {
            throw new IllegalArgumentException("wrong params");
        }
        ECPrivateKey eCPrivateKey = (ECPrivateKey)objectArray[0];
        ECPublicKey eCPublicKey = (ECPublicKey)objectArray[1];
        int n3 = objectArray.length;
        if (n3 > 2) {
            for (int i2 = 2; i2 < n3; ++i2) {
                if (objectArray[i2] instanceof Boolean) {
                    this.e = new Boolean((Boolean)objectArray[i2]);
                    continue;
                }
                if (objectArray[i2] instanceof SharedInfoParameterSpec) {
                    this.b = ((SharedInfoParameterSpec)objectArray[i2]).getSharedInfo(0);
                    continue;
                }
                if (!(objectArray[i2] instanceof String)) continue;
                this.c = (String)objectArray[i2];
            }
        }
        super.init(n2, objectArray, random);
        ECParams eCParams = eCPrivateKey.getECParams();
        try {
            ECFactory eCFactory = ECFactory.a(eCParams);
            ECA eCA = eCFactory.a(eCPublicKey.getX(), eCPublicKey.getY());
            eCA = this.a(eCA, eCPrivateKey.getExp(), eCParams);
            if (eCA.equals(eCA.d())) {
                this.reset();
                throw new IllegalArgumentException("keys are invalid.");
            }
            this.a = eCA.e().f();
        }
        catch (Exception exception) {
            this.reset();
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    private ECA a(ECA eCA, byte[] byArray, ECParams eCParams) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (this.e == null && this.j == 32 || Boolean.TRUE.equals(this.e)) {
            return eCA.a(bigInteger.multiply(BigInteger.valueOf(eCParams.getCofactor())).mod(new BigInteger(1, eCParams.getPointOrder())));
        }
        return eCA.a(bigInteger.mod(new BigInteger(1, eCParams.getPointOrder())));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.e);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.e = (Boolean)objectInputStream.readObject();
    }
}

