/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.PointParams;
import com.certicom.ecc.jcae.CurveList;
import com.certicom.ecc.jcae.ECPrivateKey;
import com.certicom.ecc.jcae.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import com.certicom.ecc.util.JDKVersion;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.security.spec.ECKeySpec;
import javax.security.spec.ECParameterSpec;
import javax.security.spec.ECPrivateKeySpec;
import javax.security.spec.ECPublicKeySpec;
import javax.security.spec.ECRawPublicKeySpec;

public final class ECKeyFactorySpi
extends KeyFactorySpi {
    private AlgorithmParameterSpec g;
    private CryptoTransform h;
    private int i;
    private int j;
    private static final Class k = a == null ? (a = ECKeyFactorySpi.a("com.certicom.ecc.interfaces.ECPrivateKey")) : a;
    private static final Class l = b == null ? (b = ECKeyFactorySpi.a("com.certicom.ecc.interfaces.ECPublicKey")) : b;
    private static final Class m = c == null ? (c = ECKeyFactorySpi.a("java.security.spec.X509EncodedKeySpec")) : c;
    private static final Class n = d == null ? (d = ECKeyFactorySpi.a("java.security.spec.PKCS8EncodedKeySpec")) : d;
    private static final Class o = e == null ? (e = ECKeyFactorySpi.a("javax.security.spec.ECRawPublicKeySpec")) : e;
    static Class a;
    static Class b;
    static Class c;
    static Class d;
    static Class e;
    static Class f;

    public ECKeyFactorySpi() {
        SystemConfig systemConfig = SystemConfig.getConfig();
        this.g = CurveList.byName("ImplicitlyCA");
        this.i = systemConfig.getFormat();
        this.j = systemConfig.getPtCompression();
        this.h = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "KEYFAC");
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        keySpec = JDKVersion.getTranslator().translateECKeySpec_1_5_to_1_3(keySpec);
        ECPrivateKey eCPrivateKey = null;
        if (keySpec instanceof ECPrivateKeySpec) {
            ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)keySpec;
            ECParameterSpec eCParameterSpec = eCPrivateKeySpec.getParams();
            ECParams eCParams = (ECParams)((Object)CurveList.convertParams(eCParameterSpec));
            eCPrivateKey = new ECPrivateKey(this.i, eCPrivateKeySpec.getExp(), eCParams);
        } else if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            com.certicom.ecc.spec.ECPrivateKeySpec eCPrivateKeySpec = new com.certicom.ecc.spec.ECPrivateKeySpec(11, null, byArray, 0, byArray.length);
            eCPrivateKey = new ECPrivateKey(11, eCPrivateKeySpec);
        } else {
            throw new InvalidKeySpecException("does not support " + keySpec.getClass().getName());
        }
        return (PrivateKey)JDKVersion.getTranslator().translateECKey_1_3_to_1_5(eCPrivateKey);
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        Object object3;
        keySpec = JDKVersion.getTranslator().translateECKeySpec_1_5_to_1_3(keySpec);
        ECPublicKey eCPublicKey = null;
        PrivateKey privateKey = null;
        try {
            privateKey = this.engineGeneratePrivate(keySpec);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (privateKey != null) {
            try {
                object3 = (CryptoTransform)CryptoManager.getInstance(f == null ? (f = ECKeyFactorySpi.a("com.certicom.ecc.scheme.CryptoTransform")) : f, "KEYDERIVE");
                ((CryptoTransform)object3).init(5, new Object[]{JDKVersion.getTranslator().translateECKey_1_5_to_1_3(privateKey)}, null);
                object2 = (com.certicom.ecc.interfaces.ECPublicKey)((CryptoTransform)object3).transformToObject(null, 0, 0, false);
                object = SystemConfig.getConfig();
                eCPublicKey = new ECPublicKey(((SystemConfig)object).getFormat(), ((SystemConfig)object).getPtCompression(), (com.certicom.ecc.interfaces.ECPublicKey)object2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new InvalidKeySpecException(throwable.getMessage());
            }
        }
        if (eCPublicKey == null) {
            if (keySpec instanceof ECPublicKeySpec) {
                PointParams pointParams;
                object3 = (ECPublicKeySpec)keySpec;
                object2 = ((ECKeySpec)object3).getParams();
                object = ((ECPublicKeySpec)object3).getX();
                byte[] byArray = ((ECPublicKeySpec)object3).getY();
                ECParams eCParams = (ECParams)((Object)CurveList.convertParams((javax.security.interfaces.ECParams)object2));
                int n2 = eCParams.getSize();
                if (((byte[])object).length != byArray.length && ((byte[])object).length != n2 + 7 >>> 3) {
                    throw new InvalidKeySpecException("invalid public key");
                }
                byte[] byArray2 = new byte[1 + ((byte[])object).length + byArray.length];
                byArray2[0] = 4;
                System.arraycopy(object, 0, byArray2, 1, ((Object)object).length);
                System.arraycopy(byArray, 0, byArray2, 1 + ((Object)object).length, byArray.length);
                PointParams pointParams2 = eCParams.getPoint();
                try {
                    pointParams = pointParams2.getDecoded(byArray2, 0, byArray2.length);
                }
                catch (Exception exception) {
                    throw new InvalidKeySpecException("invalid public key");
                }
                eCPublicKey = new ECPublicKey(this.i, this.j, pointParams.getX(), pointParams.getY(), eCParams);
            } else if (keySpec instanceof X509EncodedKeySpec) {
                object3 = ((X509EncodedKeySpec)keySpec).getEncoded();
                this.h.init(5, new Object[]{l, this.g}, null);
                eCPublicKey = new ECPublicKey(this.i, this.j, (com.certicom.ecc.interfaces.ECPublicKey)this.h.transformToObject((byte[])object3, 0, ((Object)object3).length, true));
            } else if (keySpec instanceof ECRawPublicKeySpec) {
                PointParams pointParams;
                object3 = (ECRawPublicKeySpec)keySpec;
                object2 = ((ECKeySpec)object3).getParams();
                object = ((ECRawPublicKeySpec)object3).getPt();
                ECParams eCParams = (ECParams)((Object)CurveList.convertParams((javax.security.interfaces.ECParams)object2));
                PointParams pointParams3 = eCParams.getPoint();
                try {
                    pointParams = pointParams3.getDecoded((byte[])object, 0, ((byte[])object).length);
                }
                catch (Exception exception) {
                    throw new InvalidKeySpecException("invalid public key");
                }
                eCPublicKey = new ECPublicKey(this.i, this.j, pointParams.getX(), pointParams.getY(), eCParams);
            } else {
                throw new InvalidKeySpecException("does not support " + keySpec.getClass().getName());
            }
        }
        return (PublicKey)JDKVersion.getTranslator().translateECKey_1_3_to_1_5(eCPublicKey);
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        key = JDKVersion.getTranslator().translateECKey_1_5_to_1_3(key);
        if (key instanceof ECKey) {
            KeySpec keySpec = null;
            if (m.isAssignableFrom(clazz)) {
                ECKey eCKey = (ECKey)((Object)key);
                if (key instanceof com.certicom.ecc.interfaces.ECPublicKey && key.getFormat().equals("X.509")) {
                    keySpec = new X509EncodedKeySpec(eCKey.getEncoded());
                }
            } else if (n.isAssignableFrom(clazz)) {
                ECKey eCKey = (ECKey)((Object)key);
                if (key instanceof com.certicom.ecc.interfaces.ECPrivateKey) {
                    if (key.getFormat().equals("PKCS#8")) {
                        keySpec = new PKCS8EncodedKeySpec(eCKey.getEncoded());
                    } else {
                        ECPrivateKey eCPrivateKey;
                        ECPrivateKey eCPrivateKey2 = eCPrivateKey = (ECPrivateKey)key;
                        eCPrivateKey2.getECParams();
                        com.certicom.ecc.spec.ECPrivateKeySpec eCPrivateKeySpec = new com.certicom.ecc.spec.ECPrivateKeySpec(11, new BigInteger(1, eCPrivateKey.getExp()), eCPrivateKey2.getECParams());
                        keySpec = new PKCS8EncodedKeySpec(eCPrivateKeySpec.getEncoded());
                    }
                }
            } else if (o.isAssignableFrom(clazz)) {
                if (key instanceof com.certicom.ecc.interfaces.ECPublicKey) {
                    com.certicom.ecc.interfaces.ECPublicKey eCPublicKey = (com.certicom.ecc.interfaces.ECPublicKey)((Object)key);
                    byte[] byArray = eCPublicKey.getPoint().getEncoded(this.j);
                    ECParameterSpec eCParameterSpec = (ECParameterSpec)CurveList.convertParams(eCPublicKey.getECParams(), true);
                    keySpec = new ECRawPublicKeySpec(byArray, eCParameterSpec);
                }
            } else {
                ECParams eCParams = ((ECKey)((Object)key)).getECParams();
                ECParameterSpec eCParameterSpec = (ECParameterSpec)CurveList.convertParams(eCParams, true);
                if (key instanceof com.certicom.ecc.interfaces.ECPrivateKey) {
                    byte[] byArray = ((com.certicom.ecc.interfaces.ECPrivateKey)((Object)key)).getExp();
                    keySpec = new ECPrivateKeySpec(byArray, eCParameterSpec);
                } else {
                    com.certicom.ecc.interfaces.ECPublicKey eCPublicKey = (com.certicom.ecc.interfaces.ECPublicKey)((Object)key);
                    keySpec = new ECPublicKeySpec(eCPublicKey.getX(), eCPublicKey.getY(), eCParameterSpec);
                }
                keySpec = JDKVersion.getTranslator().translateECKeySpec_1_3_to_1_5(keySpec);
                if (!clazz.isInstance(keySpec)) {
                    keySpec = null;
                }
            }
            if (keySpec == null) {
                throw new InvalidKeySpecException("does not support " + clazz.getName());
            }
            return keySpec;
        }
        throw new InvalidKeySpecException("do not support " + key.getClass().getName());
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (Class.forName("java.security.interfaces.ECKey").isInstance(key)) {
                return key;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (key instanceof ECKey) {
            return key;
        }
        if (key instanceof javax.security.interfaces.ECKey) {
            javax.security.interfaces.ECParams eCParams = ((javax.security.interfaces.ECKey)key).getParams();
            ECParams eCParams2 = (ECParams)((Object)CurveList.convertParams(eCParams));
            if (key instanceof javax.security.interfaces.ECPrivateKey) {
                byte[] byArray = ((javax.security.interfaces.ECPrivateKey)key).getExp();
                return new ECPrivateKey(this.i, byArray, eCParams2);
            }
            javax.security.interfaces.ECPublicKey eCPublicKey = (javax.security.interfaces.ECPublicKey)key;
            return new ECPublicKey(this.i, this.j, eCPublicKey.getX(), eCPublicKey.getY(), eCParams2);
        }
        throw new InvalidKeyException("invalid key" + key.getClass().getName());
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

