#include <stdlib.h>
#include <sys/stat.h>
#include <string.h>
#include <errno.h>
#include <jni.h>
#include <sys/types.h>

#include <string.h>
#include <pwd.h>
#include <sys/vfs.h>
#include <fcntl.h>

#include "org_javaseis_io_test_TestODirect.h"

/*
 *  * Class:     com_lgc_prodesk_io_UtilFile
 *   * Method:    setODIRECT
 *    * Signature: (Ljava/io/FileDescriptor;)V
 *     */
JNIEXPORT void JNICALL Java_org_javaseis_io_test_TestODirect_setODIRECT
  (JNIEnv *env, jclass clazz, jobject obj){
#if defined(LINUX) /* { */
  jfieldID fid;
  jint ufd;
  int mode;
/* Get class of the FileDescriptor passed in */
  jclass cls = env->GetObjectClass( obj );
/* Get the field ID of the "fd" field within the File Descriptor */
  fid = env->GetFieldID( cls, "fd", "I" );
/* Get the value of the Unix file descriptor */
  ufd = env->GetIntField( obj, fid );
/* Set the O_DIRECT flag for the file */
  mode = fcntl( ufd, F_GETFL );
  mode = mode | O_DIRECT;
  fcntl( ufd, F_SETFL, mode );
#else
#endif
}
