#!/bin/sh
 
# This script was automatically generated by Phoenix
 
# ******************************************************************************
# Explanation, please read
 
# A "node" (or "host") is an indepedent compute unit, typically one physical server or machine.
 
# A "socket" is roughly equivalent to a CPU chip. Each node will have at least one socket, 
# and modern nodes will likely have two or more. if unsure, leave "Sockets per node" to "1"
 
# A "core" is a processing unit inside a CPU/socket. If hyper-threading is enabled  
# each core can run 2 or more threads.
 
# A "process" runs its own copy of the executable. It is a separate, independent 
# operating system process with its own private memory. Each process is assigned a "rank"
 
# For Phoenix tomography jobs, a common set of options would be:
#   - "Sockets per node" = "1". (Possibly more depending on hardware)
#   - "Number of processes per socket" = "1". 
#   - "Threads per process" = "32". (Or whatever your hardware will permit)
 
# The "Include default command line options" option adds the following:
#   - "--map-by socket:PE=(NumThreads) --bind-to core:overload-allowed --report-bindings" command line option
#   - "export OMP_PLACES=cores
#   - "export OMP_PROC_BIND=spread
 
# ******************************************************************************
 
#  MPI executable creation date: 07/15/2024
#  MPI executable modification date: 02/12/2026
 
PATH=/home/xtgeo/MPI/OpenMPI-4.1.8/bin:$PATH
export PATH
echo $PATH
 
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/home/xtgeo/phoenix_package/Flatirons++_CPU
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/home/xtgeo/MPI/OpenMPI-4.1.8/lib
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/local/lib
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/home/xtgeo/libtorch_cpu/lib
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/home/xtgeo/phoenix_package/Flatirons++_CPU/libtorch
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/home/xtgeo/phoenix_package/Flatirons++_CPU/libtorch/lib
export LD_LIBRARY_PATH
echo $LD_LIBRARY_PATH
 
 
export OMP_NUM_THREADS=12
export MKL_NUM_THREADS=12
 
export PHOENIX_DATA_PATH=/home/xtgeo/PhoenixData
echo $PHOENIX_DATA_PATH
 
export DESIRED_THREADS_PER_PROCESS=12
echo $DESIRED_THREADS_PER_PROCESS
 
#  Parameter file directory: /home/xtgeo/PhoenixData/MPI_JobFiles
export MPI_XTGEO_PARAMETER_FILE=Thursday_February_12_2026_09_44_41_629
echo $MPI_XTGEO_PARAMETER_FILE
 
 
param_extra_1="  -x  OMPI_MCA_hwloc_base_binding_policy=none"
param_options="--bind-to none"
param_host=" -np 4 "
param_phoenix_data_path=" -x PHOENIX_DATA_PATH=/home/xtgeo/PhoenixData"
param_exe="/home/xtgeo/phoenix_package/Flatirons++_CPU/FRG_MPI /home/xtgeo/PhoenixData"
param_path=" -x PATH=/home/xtgeo/MPI/OpenMPI-4.1.8/bin:/usr/local/cuda-11.8/bin:/home/xtgeo/anaconda3/bin:/usr/local/texlive/2023/bin/x86_64-linux:/usr/local/cuda/bin:/home/xtgeo/.local/bin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/games:/usr/local/games:/snap/bin:/snap/bin:/home/xtgeo/.dotnet/tools"
param_library_path=" -x LD_LIBRARY_PATH=/home/xtgeo/phoenix_package/Flatirons++_CPU:/home/xtgeo/MPI/OpenMPI-4.1.8/lib:/usr/local/lib:/home/xtgeo/libtorch_cpu/lib:/home/xtgeo/phoenix_package/Flatirons++_CPU/libtorch:/home/xtgeo/phoenix_package/Flatirons++_CPU/libtorch/lib"
param_tpp=" -x DESIRED_THREADS_PER_PROCESS=12"
param_file=" -x MPI_XTGEO_PARAMETER_FILE=Thursday_February_12_2026_09_44_41_629"
param_omp_nt=" -x OMP_NUM_THREADS=12"
param_mkl_nt=" -x MKL_NUM_THREADS=12"
 
mpirun ${param_options} ${param_extra_1} ${param_path} ${param_library_path} ${param_tpp} ${param_phoenix_data_path} ${param_file} ${param_omp_nt} ${param_mkl_nt} ${param_host} ${param_exe}
