/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.ECTransform;
import com.certicom.ecc.spec.ECPublicKeySpec;
import com.certicom.ecc.spec.SharedInfoParameterSpec;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;

public class ECIES
extends ECTransform
implements Serializable {
    private static final long serialVersionUID = 220462448837071717L;
    private byte[] a = null;
    private byte[] b = null;
    private byte[] c = null;
    private int d;
    private ECPrivateKey e;
    private ECPublicKey f;
    private ECKey[] k;
    private CryptoTransform l = (CryptoTransform)CryptoManager.getInstance(TYPE, "KDF");
    private CryptoTransform m = (CryptoTransform)CryptoManager.getInstance(TYPE, "HMAC");
    private ECParams n;
    private int o;
    private boolean p;

    public ECIES() {
        super("ECIES");
        this.m.init(5, new Object[]{"SHA-1", new byte[]{1}}, null);
        this.d = this.m.outputSize(0, true);
    }

    public void reset() {
        this.a = null;
        this.b = null;
        this.c = null;
        this.l.reset();
        this.e = null;
        this.f = null;
        this.n = null;
        this.k = null;
        this.o = 0;
        this.p = false;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        if (n2 != 3 && n2 != 4) {
            throw new IllegalArgumentException("wrong mode");
        }
        if (objectArray == null) {
            throw new IllegalArgumentException("wrong params");
        }
        this.reset();
        super.init(n2, objectArray, random);
        for (int i2 = 1; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] instanceof SharedInfoParameterSpec) {
                byte[][] byArray = ((SharedInfoParameterSpec)objectArray[i2]).getSharedInfo();
                if (byArray == null) continue;
                if (byArray.length > 2) {
                    throw new IllegalArgumentException("only up to two shared infos are expecting");
                }
                this.a = byArray[0];
                if (byArray.length <= 1) continue;
                this.b = byArray[1];
                continue;
            }
            if (objectArray[i2] instanceof Boolean) {
                this.p = (Boolean)objectArray[i2];
                continue;
            }
            if (objectArray[i2] == null) continue;
            throw new IllegalArgumentException("Unexpected argument " + objectArray[i2]);
        }
        if (n2 == 3) {
            this.f = (ECPublicKey)objectArray[0];
            CryptoTransform cryptoTransform = (CryptoTransform)CryptoManager.getInstance(TYPE, "KEYGEN");
            cryptoTransform.init(5, new Object[]{this.f.getECParams()}, random);
            this.k = (ECKey[])cryptoTransform.transformToObject(null, 0, 0, true);
            int n3 = SystemConfig.getConfig().getPtCompression();
            this.c = ((ECPublicKey)this.k[1]).getPoint().getEncoded(n3);
            this.o = this.c.length;
        } else {
            this.e = (ECPrivateKey)objectArray[0];
            this.n = this.e.getECParams();
        }
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (byArray == null || n2 + n3 > byArray.length) {
            throw new IllegalArgumentException("wrong input");
        }
        if (byArray2 == null || byArray2 == byArray) {
            throw new IllegalArgumentException("wrong output");
        }
        if (this.h == 3) {
            int n5 = n3;
            System.arraycopy(this.c, 0, byArray2, n4, this.c.length);
            n4 += this.c.length;
            CryptoTransform cryptoTransform = (CryptoTransform)CryptoManager.getInstance(TYPE, "ECDH");
            cryptoTransform.setConformance(this.getConformance());
            cryptoTransform.init(6, new Object[]{this.k[0], this.f}, this.g);
            byte[] byArray3 = cryptoTransform.transform(null, 0, 0, true);
            this.l.init(5, new Object[]{byArray3, this.a, null, new Boolean(true)}, this.g);
            byte[] byArray4 = this.l.transform(null, n2, n5 + this.d, true);
            byte[] byArray5 = new byte[n5];
            byte[] byArray6 = new byte[this.d];
            if (this.p) {
                System.arraycopy(byArray4, 0, byArray5, 0, n5);
                System.arraycopy(byArray4, n5, byArray6, 0, this.d);
            } else {
                System.arraycopy(byArray4, 0, byArray6, 0, this.d);
                System.arraycopy(byArray4, this.d, byArray5, 0, n5);
            }
            int n6 = n4;
            int n7 = 0;
            while (n7 < n5) {
                byArray2[n4] = (byte)(byArray5[n7] ^ byArray[n2]);
                ++n7;
                ++n4;
                ++n2;
            }
            n7 = n4 - n6;
            this.a(byArray2, n6, n7, byArray6, false);
            if (this.d > byArray2.length - n4) {
                throw new IllegalStateException("output buffer is too short");
            }
            byte[] byArray7 = this.b != null ? this.a(this.b, 0, this.b.length, null, true) : this.a(null, 0, 0, null, true);
            System.arraycopy(byArray7, 0, byArray2, n4, this.d);
            return n4 + this.d;
        }
        if (this.h == 4) {
            int n8;
            if (byArray[n2] == 2 || byArray[n2] == 3) {
                n8 = 2;
            } else if (byArray[n2] == 4) {
                n8 = 4;
            } else if (byArray[n2] == 6 || byArray[n2] == 7) {
                n8 = 6;
            } else {
                throw new IllegalStateException("Invalid compression cipher mode");
            }
            this.o = this.n.getPoint().getEncoded(n8).length;
            this.c = new byte[this.o];
            System.arraycopy(byArray, 0, this.c, 0, this.o);
            int n9 = byArray.length - this.o - this.d;
            byte[] byArray8 = new byte[n9];
            System.arraycopy(byArray, this.o, byArray8, 0, n9);
            byte[] byArray9 = new byte[this.d];
            System.arraycopy(byArray, this.o + n9, byArray9, 0, this.d);
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(10, n8, this.n, this.c, 0, this.o);
            CryptoTransform cryptoTransform = (CryptoTransform)CryptoManager.getInstance(TYPE, "ECDH");
            cryptoTransform.setConformance(this.getConformance());
            cryptoTransform.init(6, new Object[]{this.e, eCPublicKeySpec}, this.g);
            byte[] byArray10 = cryptoTransform.transform(null, 0, 0, true);
            this.l.init(5, new Object[]{byArray10, this.a, null, new Boolean(true)}, this.g);
            byte[] byArray11 = this.l.transform(null, 0, n9 + this.d, true);
            byte[] byArray12 = new byte[n9];
            byte[] byArray13 = new byte[this.d];
            if (this.p) {
                System.arraycopy(byArray11, 0, byArray12, 0, n9);
                System.arraycopy(byArray11, n9, byArray13, 0, this.d);
            } else {
                System.arraycopy(byArray11, 0, byArray13, 0, this.d);
                System.arraycopy(byArray11, this.d, byArray12, 0, n9);
            }
            this.a(byArray8, 0, byArray8.length, byArray13, false);
            byte[] byArray14 = this.b != null ? this.a(this.b, 0, this.b.length, null, true) : this.a(null, 0, 0, null, true);
            if (!this.a(byArray14, byArray9)) {
                throw new IllegalArgumentException("MAC is invalid");
            }
            int n10 = 0;
            while (n10 < byArray8.length) {
                byArray2[n4] = (byte)(byArray8[n10] ^ byArray12[n10]);
                ++n10;
                ++n4;
            }
            return byArray8.length;
        }
        throw new IllegalArgumentException("wrong mode");
    }

    private byte[] a(byte[] byArray, int n2, int n3, byte[] byArray2, boolean bl) {
        if (!bl) {
            this.m.init(5, new Object[]{"SHA-1", byArray2}, null);
        }
        return this.m.transform(byArray, n2, n3, bl);
    }

    public int outputSize(int n2, boolean bl) throws IllegalStateException {
        if (this.h != 3 && this.h != 4) {
            throw new IllegalStateException("wrong mode");
        }
        int n3 = this.h == 3 ? this.o + n2 + this.d : n2 - this.d;
        return n3;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public boolean isIncremental() {
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(this.c);
        objectOutputStream.writeObject(new Integer(this.d));
        objectOutputStream.writeObject(this.e);
        objectOutputStream.writeObject(this.f);
        objectOutputStream.writeObject(this.k);
        objectOutputStream.writeObject(this.l);
        objectOutputStream.writeObject(this.m);
        objectOutputStream.writeObject(this.n);
        objectOutputStream.writeObject(new Integer(this.o));
        objectOutputStream.writeObject(new Boolean(this.p));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (byte[])objectInputStream.readObject();
        this.a = (byte[])objectInputStream.readObject();
        this.c = (byte[])objectInputStream.readObject();
        this.d = (Integer)objectInputStream.readObject();
        this.e = (ECPrivateKey)objectInputStream.readObject();
        this.f = (ECPublicKey)objectInputStream.readObject();
        this.k = (ECKey[])objectInputStream.readObject();
        this.l = (CryptoTransform)objectInputStream.readObject();
        this.m = (CryptoTransform)objectInputStream.readObject();
        this.n = (ECParams)objectInputStream.readObject();
        this.o = (Integer)objectInputStream.readObject();
        this.p = (Boolean)objectInputStream.readObject();
    }
}

