/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.scheme.AESUtil;
import com.certicom.ecc.scheme.CryptoTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;

public final class AES
extends CryptoTransform
implements Serializable {
    private static final long serialVersionUID = -2742470944451612849L;
    private final int b = 1;
    private final int c = 2;
    private final int d = 3;
    private final int e = 4;
    private final int f = 7;
    private int k;
    private int l;
    private int m;
    private int n;
    private int[] o = new int[60];
    private int[] p = new int[4];
    private int[] q = new int[4];
    private int[] r = new int[4];
    private byte[] s = new byte[16];
    private byte[] t = new byte[16];
    private byte[] u = new byte[32];
    static final int[] a = new int[]{0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE, 0x1B000000, 0x36000000};
    private boolean v;
    public static final String CTR_SIGN_CHANGE_BUG_ENABLED_PROPERTY_NAME = "com.certicom.ecc.scheme.aes.ctrSignChangeBugEnabled";
    private static boolean w = Boolean.getBoolean("com.certicom.ecc.scheme.aes.ctrSignChangeBugEnabled");
    private static ThreadLocal x = new ThreadLocal();

    public AES() {
        super("AES");
    }

    public void reset() {
        super.reset();
        this.k = 0;
        this.l = 0;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        if (n2 != 3 && n2 != 4) {
            throw new IllegalArgumentException("Wrong mode.");
        }
        this.reset();
        super.init(n2, objectArray, random);
        this.v = AES.c();
        try {
            byte[] byArray;
            String string = (String)objectArray[0];
            if (string.equals("ECB")) {
                this.k = 1;
            } else if (string.equals("CBC")) {
                this.k = 2;
            } else if (string.equals("CFB128") || string.equals("CFB")) {
                this.k = 3;
            } else if (string.equals("OFB128") || string.equals("OFB")) {
                this.k = 4;
            } else if (string.equals("CTR")) {
                this.k = 7;
            } else {
                this.reset();
                throw new IllegalArgumentException("Wrong cipher mode.");
            }
            Integer n3 = (Integer)objectArray[1];
            if (this.k != 7 && n3 != 128) {
                this.reset();
                throw new IllegalArgumentException("Bad Block Length.");
            }
            if (this.k == 7) {
                this.n = n3;
                if (this.n == 0 || this.n > 128 || this.n % 8 != 0) {
                    throw new IllegalArgumentException("Bad Counter Bit set");
                }
            }
            byte[] byArray2 = null;
            if (objectArray.length >= 4 && objectArray[3] != null) {
                byArray2 = (byte[])objectArray[3];
            }
            if (byArray2 == null && this.k != 1) {
                this.reset();
                throw new IllegalArgumentException("Need IV.");
            }
            if (byArray2 != null && byArray2.length != 16) {
                this.reset();
                throw new IllegalArgumentException("Bad IV length.");
            }
            if (this.k != 1) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.p[i2] = this.a(byArray2, i2 * 4);
                }
            }
            if ((byArray = (byte[])objectArray[2]).length == 16) {
                this.l = 128;
                this.m = 10;
            } else if (byArray.length == 24) {
                this.l = 192;
                this.m = 12;
            } else if (byArray.length == 32) {
                this.l = 256;
                this.m = 14;
            } else {
                throw new IllegalArgumentException("Bad key length.");
            }
            System.arraycopy(byArray, 0, this.u, 0, byArray.length);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.reset();
            throw illegalArgumentException;
        }
        catch (NullPointerException nullPointerException) {
            this.reset();
            throw new IllegalArgumentException("Invalid Parameters.");
        }
        catch (ClassCastException classCastException) {
            this.reset();
            throw new IllegalArgumentException("Invalid Parameters.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.reset();
            throw new IllegalArgumentException("Invalid Parameters.");
        }
        if (n2 == 3 || this.k == 3 || this.k == 4 || this.k == 7) {
            this.c(this.u);
        } else {
            this.b(this.u);
        }
    }

    public int inputSize() {
        return 16;
    }

    public int outputSize(int n2, boolean bl) {
        if (n2 % this.inputSize() == 0 || this.k == 7) {
            return n2;
        }
        return 0;
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.h != 3 && this.h != 4) {
            throw new IllegalStateException("Not initialized.");
        }
        if (this.k != 7) {
            if (n3 % this.inputSize() != 0) {
                throw new IllegalArgumentException("Wrong block size.");
            }
        } else if (n3 % this.inputSize() != 0 && !bl) {
            throw new IllegalArgumentException("block size too small");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must be >= 0.");
        }
        if (n3 > 0) {
            if (byArray == null || n3 + n2 > byArray.length || n2 < 0) {
                throw new IllegalArgumentException("Invalid Argument");
            }
            if (byArray2 == null || n3 + n4 > byArray2.length || n4 < 0) {
                throw new IllegalArgumentException("Invalid Argument");
            }
            if (this.h == 3) {
                this.a(byArray, n2, n3, byArray2, n4);
            } else {
                this.b(byArray, n2, n3, byArray2, n4);
            }
        }
        if (bl) {
            this.reset();
        }
        return n3;
    }

    private void a(byte[] byArray) {
        int n2 = this.n >> 3;
        int n3 = byArray.length - n2;
        byte by = byArray[byArray.length - n2];
        int n4 = byArray.length - 1;
        for (int i2 = 0; i2 < n2 && n4 >= 0; ++i2) {
            int n5 = n4--;
            byArray[n5] = (byte)(byArray[n5] + 1);
            if (byArray[n5] != 0) break;
        }
        if (this.v && by == 127 && byArray[n3] == -128) {
            byArray[n3] = 0;
            if (n2 > 1) {
                byArray[n3 + 1] = -128;
            }
        }
    }

    private void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = new byte[16];
        int n5 = n3 >> 4;
        int n6 = n3 % this.inputSize();
        int n7 = byArray3.length;
        if (this.k != 7 || n6 > 0) {
            // empty if block
        }
        while (true) {
            int n8 = ++n5;
            --n5;
            if (n8 == 0) break;
            if (this.k == 4 || this.k == 3 || this.k == 7) {
                this.q[0] = this.p[0];
                this.q[1] = this.p[1];
                this.q[2] = this.p[2];
                this.q[3] = this.p[3];
            } else {
                this.q[0] = this.a(byArray, n2);
                this.q[1] = this.a(byArray, n2 + 4);
                this.q[2] = this.a(byArray, n2 + 8);
                this.q[3] = this.a(byArray, n2 + 12);
                if (this.k == 2) {
                    this.q[0] = this.q[0] ^ this.p[0];
                    this.q[1] = this.q[1] ^ this.p[1];
                    this.q[2] = this.q[2] ^ this.p[2];
                    this.q[3] = this.q[3] ^ this.p[3];
                }
            }
            this.b();
            if (this.k == 4 || this.k == 3 || this.k == 7) {
                if (this.k == 7) {
                    this.a(this.p[0], byArray3, 0);
                    this.a(this.p[1], byArray3, 4);
                    this.a(this.p[2], byArray3, 8);
                    this.a(this.p[3], byArray3, 12);
                    this.a(byArray3);
                    this.p[0] = this.a(byArray3, 0);
                    this.p[1] = this.a(byArray3, 4);
                    this.p[2] = this.a(byArray3, 8);
                    this.p[3] = this.a(byArray3, 12);
                } else {
                    this.p[0] = this.q[0];
                    this.p[1] = this.q[1];
                    this.p[2] = this.q[2];
                    this.p[3] = this.q[3];
                }
                if (this.k == 3) {
                    this.q[0] = this.a(byArray, n2);
                    this.q[1] = this.a(byArray, n2 + 4);
                    this.q[2] = this.a(byArray, n2 + 8);
                    this.q[3] = this.a(byArray, n2 + 12);
                    this.p[0] = this.p[0] ^ this.q[0];
                    this.p[1] = this.p[1] ^ this.q[1];
                    this.p[2] = this.p[2] ^ this.q[2];
                    this.p[3] = this.p[3] ^ this.q[3];
                    this.a(this.p[0], byArray2, n4);
                    this.a(this.p[1], byArray2, n4 + 4);
                    this.a(this.p[2], byArray2, n4 + 8);
                    this.a(this.p[3], byArray2, n4 + 12);
                } else {
                    this.a(this.q[0], this.t, 0);
                    this.a(this.q[1], this.t, 4);
                    this.a(this.q[2], this.t, 8);
                    this.a(this.q[3], this.t, 12);
                    if (n5 == 0 && n6 > 0 && this.k == 7) {
                        n7 = n6;
                    }
                    for (int i2 = 0; i2 < n7; ++i2) {
                        byArray2[n4 + i2] = (byte)(byArray[n2 + i2] ^ this.t[i2]);
                    }
                }
            } else {
                if (this.k == 2) {
                    this.p[0] = this.q[0];
                    this.p[1] = this.q[1];
                    this.p[2] = this.q[2];
                    this.p[3] = this.q[3];
                }
                this.a(this.q[0], byArray2, n4);
                this.a(this.q[1], byArray2, n4 + 4);
                this.a(this.q[2], byArray2, n4 + 8);
                this.a(this.q[3], byArray2, n4 + 12);
            }
            n2 += 16;
            n4 += 16;
        }
    }

    private void b(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = n3 >> 4;
        int n6 = n3 % this.inputSize();
        byte[] byArray3 = new byte[16];
        int n7 = byArray3.length;
        if (this.k != 7 || n6 > 0) {
            // empty if block
        }
        while (true) {
            int n8 = ++n5;
            --n5;
            if (n8 == 0) break;
            if (this.k == 4 || this.k == 3 || this.k == 7) {
                this.q[0] = this.p[0];
                this.q[1] = this.p[1];
                this.q[2] = this.p[2];
                this.q[3] = this.p[3];
                this.b();
            } else {
                this.q[0] = this.a(byArray, n2);
                this.q[1] = this.a(byArray, n2 + 4);
                this.q[2] = this.a(byArray, n2 + 8);
                this.q[3] = this.a(byArray, n2 + 12);
                if (this.k == 2) {
                    this.r[0] = this.q[0];
                    this.r[1] = this.q[1];
                    this.r[2] = this.q[2];
                    this.r[3] = this.q[3];
                }
                this.a();
            }
            if (this.k == 4 || this.k == 7) {
                if (this.k == 7) {
                    this.a(this.p[0], byArray3, 0);
                    this.a(this.p[1], byArray3, 4);
                    this.a(this.p[2], byArray3, 8);
                    this.a(this.p[3], byArray3, 12);
                    this.a(byArray3);
                    this.p[0] = this.a(byArray3, 0);
                    this.p[1] = this.a(byArray3, 4);
                    this.p[2] = this.a(byArray3, 8);
                    this.p[3] = this.a(byArray3, 12);
                } else {
                    this.p[0] = this.q[0];
                    this.p[1] = this.q[1];
                    this.p[2] = this.q[2];
                    this.p[3] = this.q[3];
                }
                this.a(this.q[0], this.s, 0);
                this.a(this.q[1], this.s, 4);
                this.a(this.q[2], this.s, 8);
                this.a(this.q[3], this.s, 12);
                if (n5 == 0 && n6 > 0 && this.k == 7) {
                    n7 = n6;
                }
                for (int i2 = 0; i2 < n7; ++i2) {
                    byArray2[n4 + i2] = (byte)(byArray[n2 + i2] ^ this.s[i2]);
                }
            } else {
                if (this.k != 1) {
                    if (this.k == 3) {
                        this.p[0] = this.a(byArray, n2);
                        this.p[1] = this.a(byArray, n2 + 4);
                        this.p[2] = this.a(byArray, n2 + 8);
                        this.p[3] = this.a(byArray, n2 + 12);
                    }
                    this.q[0] = this.q[0] ^ this.p[0];
                    this.q[1] = this.q[1] ^ this.p[1];
                    this.q[2] = this.q[2] ^ this.p[2];
                    this.q[3] = this.q[3] ^ this.p[3];
                    if (this.k == 2) {
                        this.p[0] = this.r[0];
                        this.p[1] = this.r[1];
                        this.p[2] = this.r[2];
                        this.p[3] = this.r[3];
                    }
                }
                this.a(this.q[0], byArray2, n4);
                this.a(this.q[1], byArray2, n4 + 4);
                this.a(this.q[2], byArray2, n4 + 8);
                this.a(this.q[3], byArray2, n4 + 12);
            }
            n2 += 16;
            n4 += 16;
        }
    }

    private int a(byte[] byArray, int n2) {
        return (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
    }

    private void a(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
    }

    private void b(byte[] byArray) {
        int n2;
        this.c(byArray);
        int n3 = 0;
        for (n2 = 4 * this.m; n3 < n2; n3 += 4, n2 -= 4) {
            int n4 = this.o[n3];
            this.o[n3] = this.o[n2];
            this.o[n2] = n4;
            n4 = this.o[n3 + 1];
            this.o[n3 + 1] = this.o[n2 + 1];
            this.o[n2 + 1] = n4;
            n4 = this.o[n3 + 2];
            this.o[n3 + 2] = this.o[n2 + 2];
            this.o[n2 + 2] = n4;
            n4 = this.o[n3 + 3];
            this.o[n3 + 3] = this.o[n2 + 3];
            this.o[n2 + 3] = n4;
        }
        n3 = 4;
        for (n2 = 0; n2 < this.m - 1; ++n2) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.o[n3] = AESUtil.a[AESUtil.j[this.o[n3] >>> 24] & 0xFF] ^ AESUtil.b[AESUtil.j[this.o[n3] >>> 16 & 0xFF] & 0xFF] ^ AESUtil.c[AESUtil.j[this.o[n3] >>> 8 & 0xFF] & 0xFF] ^ AESUtil.d[AESUtil.j[this.o[n3] & 0xFF] & 0xFF];
                ++n3;
            }
        }
    }

    private void c(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        this.o[0] = this.a(byArray, 0);
        this.o[1] = this.a(byArray, 4);
        this.o[2] = this.a(byArray, 8);
        this.o[3] = this.a(byArray, 12);
        if (this.l == 128) {
            while (true) {
                int n4 = this.o[n3 + 3];
                this.o[n3 + 4] = this.o[n3] ^ AESUtil.j[n4 >>> 16 & 0xFF] & 0xFF000000 ^ AESUtil.j[n4 >>> 8 & 0xFF] & 0xFF0000 ^ AESUtil.j[n4 & 0xFF] & 0xFF00 ^ AESUtil.j[n4 >>> 24] & 0xFF ^ a[n2];
                this.o[n3 + 5] = this.o[n3 + 1] ^ this.o[n3 + 4];
                this.o[n3 + 6] = this.o[n3 + 2] ^ this.o[n3 + 5];
                this.o[n3 + 7] = this.o[n3 + 3] ^ this.o[n3 + 6];
                if (++n2 == 10) {
                    return;
                }
                n3 += 4;
            }
        }
        this.o[4] = this.a(byArray, 16);
        this.o[5] = this.a(byArray, 20);
        if (this.l == 192) {
            while (true) {
                int n5 = this.o[n3 + 5];
                this.o[n3 + 6] = this.o[n3] ^ AESUtil.j[n5 >>> 16 & 0xFF] & 0xFF000000 ^ AESUtil.j[n5 >>> 8 & 0xFF] & 0xFF0000 ^ AESUtil.j[n5 & 0xFF] & 0xFF00 ^ AESUtil.j[n5 >>> 24] & 0xFF ^ a[n2];
                this.o[n3 + 7] = this.o[n3 + 1] ^ this.o[n3 + 6];
                this.o[n3 + 8] = this.o[n3 + 2] ^ this.o[n3 + 7];
                this.o[n3 + 9] = this.o[n3 + 3] ^ this.o[n3 + 8];
                if (++n2 == 8) {
                    return;
                }
                this.o[n3 + 10] = this.o[n3 + 4] ^ this.o[n3 + 9];
                this.o[n3 + 11] = this.o[n3 + 5] ^ this.o[n3 + 10];
                n3 += 6;
            }
        }
        this.o[6] = this.a(byArray, 24);
        this.o[7] = this.a(byArray, 28);
        if (this.l == 256) {
            while (true) {
                int n6 = this.o[n3 + 7];
                this.o[n3 + 8] = this.o[n3] ^ AESUtil.j[n6 >>> 16 & 0xFF] & 0xFF000000 ^ AESUtil.j[n6 >>> 8 & 0xFF] & 0xFF0000 ^ AESUtil.j[n6 & 0xFF] & 0xFF00 ^ AESUtil.j[n6 >>> 24] & 0xFF ^ a[n2];
                this.o[n3 + 9] = this.o[n3 + 1] ^ this.o[n3 + 8];
                this.o[n3 + 10] = this.o[n3 + 2] ^ this.o[n3 + 9];
                this.o[n3 + 11] = this.o[n3 + 3] ^ this.o[n3 + 10];
                if (++n2 == 7) {
                    return;
                }
                n6 = this.o[n3 + 11];
                this.o[n3 + 12] = this.o[n3 + 4] ^ AESUtil.j[n6 >>> 24] & 0xFF000000 ^ AESUtil.j[n6 >>> 16 & 0xFF] & 0xFF0000 ^ AESUtil.j[n6 >>> 8 & 0xFF] & 0xFF00 ^ AESUtil.j[n6 & 0xFF] & 0xFF;
                this.o[n3 + 13] = this.o[n3 + 5] ^ this.o[n3 + 12];
                this.o[n3 + 14] = this.o[n3 + 6] ^ this.o[n3 + 13];
                this.o[n3 + 15] = this.o[n3 + 7] ^ this.o[n3 + 14];
                n3 += 8;
            }
        }
        throw new IllegalArgumentException("Bad key length.");
    }

    private void a() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.m >> 1;
        int n7 = 0;
        int n8 = this.q[0] ^ this.o[0];
        int n9 = this.q[1] ^ this.o[1];
        int n10 = this.q[2] ^ this.o[2];
        int n11 = this.q[3] ^ this.o[3];
        while (true) {
            n5 = AESUtil.a[n8 >>> 24] ^ AESUtil.b[n11 >>> 16 & 0xFF] ^ AESUtil.c[n10 >>> 8 & 0xFF] ^ AESUtil.d[n9 & 0xFF] ^ this.o[n7 + 4];
            n4 = AESUtil.a[n9 >>> 24] ^ AESUtil.b[n8 >>> 16 & 0xFF] ^ AESUtil.c[n11 >>> 8 & 0xFF] ^ AESUtil.d[n10 & 0xFF] ^ this.o[n7 + 5];
            n3 = AESUtil.a[n10 >>> 24] ^ AESUtil.b[n9 >>> 16 & 0xFF] ^ AESUtil.c[n8 >>> 8 & 0xFF] ^ AESUtil.d[n11 & 0xFF] ^ this.o[n7 + 6];
            n2 = AESUtil.a[n11 >>> 24] ^ AESUtil.b[n10 >>> 16 & 0xFF] ^ AESUtil.c[n9 >>> 8 & 0xFF] ^ AESUtil.d[n8 & 0xFF] ^ this.o[n7 + 7];
            n7 += 8;
            if (--n6 == 0) break;
            n8 = AESUtil.a[n5 >>> 24] ^ AESUtil.b[n2 >>> 16 & 0xFF] ^ AESUtil.c[n3 >>> 8 & 0xFF] ^ AESUtil.d[n4 & 0xFF] ^ this.o[n7];
            n9 = AESUtil.a[n4 >>> 24] ^ AESUtil.b[n5 >>> 16 & 0xFF] ^ AESUtil.c[n2 >>> 8 & 0xFF] ^ AESUtil.d[n3 & 0xFF] ^ this.o[n7 + 1];
            n10 = AESUtil.a[n3 >>> 24] ^ AESUtil.b[n4 >>> 16 & 0xFF] ^ AESUtil.c[n5 >>> 8 & 0xFF] ^ AESUtil.d[n2 & 0xFF] ^ this.o[n7 + 2];
            n11 = AESUtil.a[n2 >>> 24] ^ AESUtil.b[n3 >>> 16 & 0xFF] ^ AESUtil.c[n4 >>> 8 & 0xFF] ^ AESUtil.d[n5 & 0xFF] ^ this.o[n7 + 3];
        }
        n8 = AESUtil.e[n5 >>> 24] & 0xFF000000 ^ AESUtil.e[n2 >>> 16 & 0xFF] & 0xFF0000 ^ AESUtil.e[n3 >>> 8 & 0xFF] & 0xFF00 ^ AESUtil.e[n4 & 0xFF] & 0xFF ^ this.o[n7];
        n9 = AESUtil.e[n4 >>> 24] & 0xFF000000 ^ AESUtil.e[n5 >>> 16 & 0xFF] & 0xFF0000 ^ AESUtil.e[n2 >>> 8 & 0xFF] & 0xFF00 ^ AESUtil.e[n3 & 0xFF] & 0xFF ^ this.o[n7 + 1];
        n10 = AESUtil.e[n3 >>> 24] & 0xFF000000 ^ AESUtil.e[n4 >>> 16 & 0xFF] & 0xFF0000 ^ AESUtil.e[n5 >>> 8 & 0xFF] & 0xFF00 ^ AESUtil.e[n2 & 0xFF] & 0xFF ^ this.o[n7 + 2];
        n11 = AESUtil.e[n2 >>> 24] & 0xFF000000 ^ AESUtil.e[n3 >>> 16 & 0xFF] & 0xFF0000 ^ AESUtil.e[n4 >>> 8 & 0xFF] & 0xFF00 ^ AESUtil.e[n5 & 0xFF] & 0xFF ^ this.o[n7 + 3];
        this.q[0] = n8;
        this.q[1] = n9;
        this.q[2] = n10;
        this.q[3] = n11;
    }

    private void b() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.m >> 1;
        int n7 = 0;
        int n8 = this.q[0] ^ this.o[0];
        int n9 = this.q[1] ^ this.o[1];
        int n10 = this.q[2] ^ this.o[2];
        int n11 = this.q[3] ^ this.o[3];
        while (true) {
            n5 = AESUtil.f[n8 >>> 24] ^ AESUtil.g[n9 >>> 16 & 0xFF] ^ AESUtil.h[n10 >>> 8 & 0xFF] ^ AESUtil.i[n11 & 0xFF] ^ this.o[n7 + 4];
            n4 = AESUtil.f[n9 >>> 24] ^ AESUtil.g[n10 >>> 16 & 0xFF] ^ AESUtil.h[n11 >>> 8 & 0xFF] ^ AESUtil.i[n8 & 0xFF] ^ this.o[n7 + 5];
            n3 = AESUtil.f[n10 >>> 24] ^ AESUtil.g[n11 >>> 16 & 0xFF] ^ AESUtil.h[n8 >>> 8 & 0xFF] ^ AESUtil.i[n9 & 0xFF] ^ this.o[n7 + 6];
            n2 = AESUtil.f[n11 >>> 24] ^ AESUtil.g[n8 >>> 16 & 0xFF] ^ AESUtil.h[n9 >>> 8 & 0xFF] ^ AESUtil.i[n10 & 0xFF] ^ this.o[n7 + 7];
            n7 += 8;
            if (--n6 == 0) break;
            n8 = AESUtil.f[n5 >>> 24] ^ AESUtil.g[n4 >>> 16 & 0xFF] ^ AESUtil.h[n3 >>> 8 & 0xFF] ^ AESUtil.i[n2 & 0xFF] ^ this.o[n7];
            n9 = AESUtil.f[n4 >>> 24] ^ AESUtil.g[n3 >>> 16 & 0xFF] ^ AESUtil.h[n2 >>> 8 & 0xFF] ^ AESUtil.i[n5 & 0xFF] ^ this.o[n7 + 1];
            n10 = AESUtil.f[n3 >>> 24] ^ AESUtil.g[n2 >>> 16 & 0xFF] ^ AESUtil.h[n5 >>> 8 & 0xFF] ^ AESUtil.i[n4 & 0xFF] ^ this.o[n7 + 2];
            n11 = AESUtil.f[n2 >>> 24] ^ AESUtil.g[n5 >>> 16 & 0xFF] ^ AESUtil.h[n4 >>> 8 & 0xFF] ^ AESUtil.i[n3 & 0xFF] ^ this.o[n7 + 3];
        }
        n8 = AESUtil.j[n5 >>> 24] & 0xFF000000 ^ AESUtil.j[n4 >>> 16 & 0xFF] & 0xFF0000 ^ AESUtil.j[n3 >>> 8 & 0xFF] & 0xFF00 ^ AESUtil.j[n2 & 0xFF] & 0xFF ^ this.o[n7];
        n9 = AESUtil.j[n4 >>> 24] & 0xFF000000 ^ AESUtil.j[n3 >>> 16 & 0xFF] & 0xFF0000 ^ AESUtil.j[n2 >>> 8 & 0xFF] & 0xFF00 ^ AESUtil.j[n5 & 0xFF] & 0xFF ^ this.o[n7 + 1];
        n10 = AESUtil.j[n3 >>> 24] & 0xFF000000 ^ AESUtil.j[n2 >>> 16 & 0xFF] & 0xFF0000 ^ AESUtil.j[n5 >>> 8 & 0xFF] & 0xFF00 ^ AESUtil.j[n4 & 0xFF] & 0xFF ^ this.o[n7 + 2];
        n11 = AESUtil.j[n2 >>> 24] & 0xFF000000 ^ AESUtil.j[n5 >>> 16 & 0xFF] & 0xFF0000 ^ AESUtil.j[n4 >>> 8 & 0xFF] & 0xFF00 ^ AESUtil.j[n3 & 0xFF] & 0xFF ^ this.o[n7 + 3];
        this.q[0] = n8;
        this.q[1] = n9;
        this.q[2] = n10;
        this.q[3] = n11;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(new Double(2.0));
        objectOutputStream.writeObject(new Boolean(this.v));
        objectOutputStream.writeObject(new Integer(this.k));
        objectOutputStream.writeObject(new Integer(this.l));
        objectOutputStream.writeObject(new Integer(this.m));
        objectOutputStream.writeObject(new Integer(this.n));
        objectOutputStream.writeObject(this.o);
        objectOutputStream.writeObject(this.p);
        objectOutputStream.writeObject(this.q);
        objectOutputStream.writeObject(this.r);
        objectOutputStream.writeObject(this.s);
        objectOutputStream.writeObject(this.t);
        objectOutputStream.writeObject(this.u);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = objectInputStream.readObject();
        if (object instanceof Double) {
            if ((Double)object != 2.0) throw new IOException("Unexpected format: " + object);
            this.v = (Boolean)objectInputStream.readObject();
            object = objectInputStream.readObject();
        } else {
            this.v = true;
        }
        this.k = (Integer)object;
        this.l = (Integer)objectInputStream.readObject();
        this.m = (Integer)objectInputStream.readObject();
        this.n = (Integer)objectInputStream.readObject();
        this.o = (int[])objectInputStream.readObject();
        this.p = (int[])objectInputStream.readObject();
        this.q = (int[])objectInputStream.readObject();
        this.r = (int[])objectInputStream.readObject();
        this.s = (byte[])objectInputStream.readObject();
        this.t = (byte[])objectInputStream.readObject();
        this.u = (byte[])objectInputStream.readObject();
    }

    public static void setThreadCTRSignChangeBugEnabled(Boolean bl) {
        x.set(bl);
    }

    public static void setCTRSignChangeBugEnabled(boolean bl) {
        w = bl;
    }

    public static Boolean getThreadCTRSignChangeBugEnabled() {
        return (Boolean)x.get();
    }

    public static boolean getCTRSignChangeBugEnabled() {
        return w;
    }

    private static boolean c() {
        Boolean bl = AES.getThreadCTRSignChangeBugEnabled();
        if (bl != null) {
            return bl;
        }
        return w;
    }
}

