/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.jcae.ECPrivateKey;
import com.certicom.ecc.jcae.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.CurveList;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.util.JDKVersion;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.security.spec.ECParameterSpec;
import javax.security.spec.ECPrivateKeySpec;
import javax.security.spec.ECPublicKeySpec;

public final class ECQV {
    private CryptoTransform e;
    private KeyFactory f;
    private String g;
    private ECParameterSpec h;
    private static final String[] i = new String[]{"SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "SHA-1", "SHA-224", "SHA-256", "SHA-384", "SHA-512", "MMO"};
    static Class a;
    static Class b;
    static Class c;
    static Class d;

    public ECQV() throws NoSuchAlgorithmException, NoSuchProviderException, IllegalArgumentException {
        this("SHA1");
    }

    public ECQV(String string) throws NoSuchAlgorithmException, NoSuchProviderException, IllegalArgumentException {
        this.a(string, "hash");
        boolean bl = false;
        for (int i2 = 0; !bl && i2 < i.length; ++i2) {
            if (!i[i2].equals(string)) continue;
            bl = true;
        }
        if (!bl) {
            throw new NoSuchAlgorithmException(string + " is not a supported hash");
        }
        this.e = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "ECQV");
        this.f = KeyFactory.getInstance("ECDSA", "Certicom");
        this.g = string;
    }

    public PublicKey caGeneratePublicKeyReconstructionData(PublicKey publicKey, PublicKey publicKey2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IllegalArgumentException {
        this.a(publicKey, "serverPubKeyRequest");
        this.a(publicKey2, "caEphemeralPubKey");
        this.a(algorithmParameterSpec, "paramSpec");
        this.a(secureRandom, "random");
        ECParams eCParams = this.a(algorithmParameterSpec);
        Object[] objectArray = new Object[]{eCParams, this.g, a == null ? (a = ECQV.a("com.certicom.ecc.interfaces.ECPublicKey")) : a, this.a(publicKey), this.a(publicKey2)};
        this.e.init(9, objectArray, secureRandom);
        return (PublicKey)this.a();
    }

    public PrivateKey caGeneratePrivateKeyReconstructionData(PrivateKey privateKey, PrivateKey privateKey2, byte[] byArray, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IllegalArgumentException {
        this.a(privateKey, "caPriKey");
        this.a(privateKey2, "caEphemeralPriKey");
        this.a(byArray, "implicitCertificate");
        ECParams eCParams = this.a(algorithmParameterSpec);
        Object[] objectArray = new Object[]{eCParams, this.g, b == null ? (b = ECQV.a("com.certicom.ecc.interfaces.ECPrivateKey")) : b, this.a(privateKey), this.a(privateKey2), byArray};
        this.e.init(9, objectArray, secureRandom);
        return (PrivateKey)this.a();
    }

    public PrivateKey serverDerivePrivateKey(PrivateKey privateKey, byte[] byArray, PrivateKey privateKey2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IllegalArgumentException {
        this.a(privateKey, "priKeyReconstruction");
        this.a(byArray, "implicitCertificate");
        this.a(privateKey2, "priKeyRequest");
        this.a(algorithmParameterSpec, "paramSpec");
        this.a(secureRandom, "random");
        ECParams eCParams = this.a(algorithmParameterSpec);
        Object[] objectArray = new Object[]{eCParams, this.g, b == null ? (b = ECQV.a("com.certicom.ecc.interfaces.ECPrivateKey")) : b, this.a(privateKey), byArray, this.a(privateKey2)};
        this.e.init(8, objectArray, secureRandom);
        return (PrivateKey)this.a();
    }

    public boolean serverVerifyPrivateKeyAndImplicitCertificate(PrivateKey privateKey, byte[] byArray, PublicKey publicKey, PublicKey publicKey2, PublicKey publicKey3, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IllegalArgumentException {
        this.a(privateKey, "priKeyReconstruction");
        this.a(byArray, "implicitCertificate");
        this.a(publicKey, "pubKeyRequest");
        ECParams eCParams = this.a(algorithmParameterSpec);
        Object[] objectArray = new Object[]{eCParams, this.g, c == null ? (c = ECQV.a("java.lang.Boolean")) : c, this.a(privateKey), byArray, this.a(publicKey), this.a(publicKey2), this.a(publicKey3)};
        this.e.init(8, objectArray, secureRandom);
        return (Boolean)this.a();
    }

    public PublicKey serverComputePublicKey(PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IllegalArgumentException {
        this.a(privateKey, "derivedPrivateKey");
        this.a(algorithmParameterSpec, "paramSpec");
        this.a(secureRandom, "random");
        ECParams eCParams = this.a(algorithmParameterSpec);
        Object[] objectArray = new Object[]{eCParams, this.g, a == null ? (a = ECQV.a("com.certicom.ecc.interfaces.ECPublicKey")) : a, this.a(privateKey)};
        this.e.init(8, objectArray, secureRandom);
        return (PublicKey)this.a();
    }

    public PublicKey userDerivePublicKey(PublicKey publicKey, byte[] byArray, PublicKey publicKey2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IllegalArgumentException {
        this.a(publicKey, "caPubKey");
        this.a(byArray, "implicitCertificate");
        this.a(publicKey2, "publicKeyReconstruction");
        this.a(algorithmParameterSpec, "paramSpec");
        this.a(secureRandom, "random");
        ECParams eCParams = this.a(algorithmParameterSpec);
        Object[] objectArray = new Object[]{eCParams, this.g, this.a(publicKey), byArray, this.a(publicKey2)};
        this.e.init(10, objectArray, secureRandom);
        return (PublicKey)this.a();
    }

    private Object a() {
        Object object = this.e.transformToObject(null, 0, 0, true);
        this.e.reset();
        if (object instanceof ECKey) {
            try {
                object = this.a((ECKey)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalStateException("failed to convert a key");
            }
        }
        return object;
    }

    private com.certicom.ecc.interfaces.ECPublicKey a(PublicKey publicKey) {
        return (ECPublicKey)JDKVersion.getTranslator().translateECKey_1_5_to_1_3(publicKey);
    }

    private com.certicom.ecc.interfaces.ECPrivateKey a(PrivateKey privateKey) {
        return (ECPrivateKey)JDKVersion.getTranslator().translateECKey_1_5_to_1_3(privateKey);
    }

    private ECParams a(AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException {
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("ECDSA", "Certicom");
        algorithmParameters.init(algorithmParameterSpec);
        this.h = (ECParameterSpec)algorithmParameters.getParameterSpec(d == null ? (d = ECQV.a("javax.security.spec.ECParameterSpec")) : d);
        if (algorithmParameterSpec instanceof ECParams) {
            return (ECParams)((Object)algorithmParameterSpec);
        }
        if (algorithmParameterSpec instanceof javax.security.interfaces.ECParams) {
            ECParams eCParams = CurveList.byOID(((javax.security.interfaces.ECParams)algorithmParameterSpec).getOID());
            return eCParams;
        }
        throw new IllegalArgumentException("parameter spec should be an instance of ECParams");
    }

    private Key a(ECKey eCKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        if (eCKey instanceof com.certicom.ecc.interfaces.ECPublicKey) {
            com.certicom.ecc.interfaces.ECPublicKey eCPublicKey = (com.certicom.ecc.interfaces.ECPublicKey)eCKey;
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPublicKey.getX(), eCPublicKey.getY(), this.h);
            return this.f.generatePublic(eCPublicKeySpec);
        }
        if (eCKey instanceof com.certicom.ecc.interfaces.ECPrivateKey) {
            com.certicom.ecc.interfaces.ECPrivateKey eCPrivateKey = (com.certicom.ecc.interfaces.ECPrivateKey)eCKey;
            ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(eCPrivateKey.getExp(), this.h);
            return this.f.generatePrivate(eCPrivateKeySpec);
        }
        throw new IllegalStateException("Incompatible key");
    }

    private void a(Object object, String string) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("Param " + string + " must not be null");
        }
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

