/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import edu.mines.jtk.util.ParameterSet;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.VirtualFolder;
import org.javaseis.io.VirtualFolders;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.util.SeisException;

public class VirtualFoldersSimple
extends VirtualFolders {
    public static final String TYPE = "SIMPLE";

    @Override
    public String getType() {
        return TYPE;
    }

    public VirtualFoldersSimple(String path, ExtentPolicy policy) {
        this._datasetPath = path;
        this._policy = policy;
    }

    public VirtualFoldersSimple(String datasetPath, String[] directories, ExtentPolicy policy) {
        if (datasetPath == null || datasetPath.length() < 1) {
            throw new IllegalArgumentException("Path to the dataset is invalid");
        }
        if (directories == null || directories.length < 1) {
            throw new IllegalArgumentException("Virtual folders cannot be null or zero length");
        }
        if (policy == null) {
            throw new IllegalArgumentException("The extent allocation policy cannot be null");
        }
        this._datasetPath = datasetPath;
        this._folders = new VirtualFolder[directories.length];
        this._policy = policy;
        for (int i = 0; i < directories.length; ++i) {
            this._folders[i] = new VirtualFolder(directories[i]);
        }
    }

    @Override
    public void store(ParameterSet parameterSet) throws SeisException {
        parameterSet.setInt("NDIR", this._folders.length);
        for (int i = 0; i < this._folders.length; ++i) {
            parameterSet.setString("DIR-" + i, this._folders[i].getPath());
        }
    }

    @Override
    public void load(ParameterSet parameterSet) throws SeisException {
        int count = ParameterSetIO.getRequiredInt(parameterSet, "NDIR");
        this._folders = new VirtualFolder[count];
        for (int i = 0; i < count; ++i) {
            VirtualFolder f;
            this._folders[i] = f = new VirtualFolder(ParameterSetIO.getRequiredString(parameterSet, "DIR-" + i));
        }
    }

    @Override
    protected boolean addFolder(String path, VirtualFolder newFolder) {
        return false;
    }

    @Override
    protected boolean removeFolder(String path, VirtualFolder folder) {
        return false;
    }
}

