/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.compress;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import org.javaseis.util.SeisException;

public class SeisCompress {
    int _type;
    int _nwindows;
    int _numsamp;
    int _numsamp2;
    int _recordLength;
    int _recordLengthShort;
    int _recordLengthFloat;
    int _scalarLengthShort;
    int _ibufLengthFloat;
    short[] _ibuf;
    float[] _scalars;
    ByteBuffer _buf;
    ShortBuffer _sbuf;
    FloatBuffer _fbuf;
    int _tracePosition;
    public static int NATIVE = 0;
    public static int SCALAR16 = 16;
    private static int LENWIN16 = 100;

    public SeisCompress(int type, int numsamp, ByteBuffer buf) {
        this._type = type == SCALAR16 ? SCALAR16 : NATIVE;
        if (this._type == SCALAR16) {
            this._nwindows = (numsamp + LENWIN16 - 1) / LENWIN16;
            this._numsamp = numsamp;
            this._numsamp2 = numsamp % 2 == 0 ? numsamp : numsamp + 1;
            this._recordLength = 4 * this._nwindows + 2 * this._numsamp2;
            this._scalars = new float[this._nwindows];
            this._ibuf = new short[this._numsamp2];
            this._buf = buf;
            this._sbuf = buf.asShortBuffer();
            this._fbuf = buf.asFloatBuffer();
            this._recordLengthFloat = this._recordLength / 4;
            this._recordLengthShort = this._recordLength / 2;
            this._scalarLengthShort = 2 * this._nwindows;
            this._ibufLengthFloat = this._numsamp2 / 2;
        } else if (this._type == NATIVE) {
            this._numsamp = numsamp;
            this._recordLength = 4 * this._numsamp;
            this._recordLengthFloat = this._numsamp;
            this._buf = buf;
            this._fbuf = buf.asFloatBuffer();
        }
        this._tracePosition = 0;
    }

    public static int recordLength(int type, int numsamp) {
        int len = type == SCALAR16 ? 2 * (numsamp + 1) + 4 * (numsamp + LENWIN16 - 1) / LENWIN16 : 4 * numsamp;
        return len;
    }

    public int position() {
        return this._tracePosition;
    }

    public int position(int tracePosition) {
        this._tracePosition = tracePosition;
        this._buf.position(this._tracePosition * this._recordLength);
        if (this._type == SCALAR16) {
            this._sbuf.position(this._tracePosition * this._recordLengthShort);
        }
        this._fbuf.position(this._tracePosition * this._recordLengthFloat);
        return this._tracePosition;
    }

    public void unpackFrame(int ntrc, float[][] trc) {
        for (int j = 0; j < ntrc; ++j) {
            this.position(j);
            if (this._type == SCALAR16) {
                this.unpackTrace16(trc[j]);
                continue;
            }
            this.unpackTrace(trc[j]);
        }
    }

    public void packFrame(int ntrc, float[][] frm) {
        for (int j = 0; j < ntrc; ++j) {
            this.position(j);
            if (this._type == SCALAR16) {
                this.packTrace16(frm[j]);
                continue;
            }
            this.packTrace(frm[j]);
        }
    }

    public void packTrace(float[] trc) {
        this._fbuf.put(trc, 0, this._numsamp);
    }

    public void packTrace16(float[] trc) {
        int i1 = 0;
        int i2 = 0;
        for (int k = 0; k < this._nwindows; ++k) {
            int i;
            i1 = i2;
            if ((i2 = i1 + LENWIN16) > this._numsamp) {
                i2 = this._numsamp;
            }
            float amax = 0.0f;
            for (i = i1; i < i2; ++i) {
                float val;
                float f = val = trc[i] < 0.0f ? -trc[i] : trc[i];
                if (!(val > amax)) continue;
                amax = val;
            }
            if ((double)amax > 0.0) {
                amax = 32766.0f / amax;
            }
            for (i = i1; i < i2; ++i) {
                this._ibuf[i] = (short)(0.5f + amax * trc[i]);
            }
            this._scalars[k] = amax;
        }
        this._fbuf.put(this._scalars);
        this._sbuf.position(this._sbuf.position() + this._scalarLengthShort);
        this._sbuf.put(this._ibuf);
        this._fbuf.position(this._fbuf.position() + this._ibufLengthFloat);
    }

    public void unpackTrace(float[] trc) {
        this._fbuf.get(trc, 0, this._numsamp);
    }

    public void unpackTrace16(float[] trc) {
        int i1 = 0;
        int i2 = 0;
        this._fbuf.get(this._scalars);
        this._sbuf.position(this._sbuf.position() + this._scalarLengthShort);
        this._sbuf.get(this._ibuf);
        for (int k = 0; k < this._nwindows; ++k) {
            i1 = i2;
            if ((i2 = i1 + LENWIN16) > this._numsamp) {
                i2 = this._numsamp;
            }
            float amax = (double)this._scalars[k] > 0.0 ? 1.0f / this._scalars[k] : 0.0f;
            for (int i = i1; i < i2; ++i) {
                trc[i] = amax * (float)this._ibuf[i];
            }
        }
    }

    int numWindows(int numsamp) {
        return (numsamp + LENWIN16 - 1) / LENWIN16;
    }

    public static void main(String[] args) throws SeisException {
        float val;
        double t;
        int i;
        int j;
        int numsamp = 1024;
        int ntrc = 60;
        float[][] frm = new float[ntrc][numsamp];
        double pi = 3.141592654;
        double omega1 = pi / (double)(numsamp - 1);
        double omega2 = 0.0 * omega1;
        for (j = 0; j < ntrc; ++j) {
            omega2 = (double)(j + 10) * omega1;
            for (i = 0; i < numsamp; ++i) {
                t = i;
                frm[j][i] = (float)(Math.cos(omega1 * t) * Math.sin(omega2 * t));
            }
        }
        int reclen = SeisCompress.recordLength(SCALAR16, numsamp);
        ByteBuffer buf = ByteBuffer.allocateDirect(reclen * ntrc);
        SeisCompress sc = new SeisCompress(SCALAR16, numsamp, buf);
        sc.packFrame(ntrc, frm);
        for (j = 0; j < ntrc; ++j) {
            for (i = 0; i < numsamp; ++i) {
                frm[j][i] = 0.0f;
            }
        }
        sc.unpackFrame(ntrc, frm);
        for (j = 0; j < ntrc; ++j) {
            omega2 = (double)(j + 10) * omega1;
            for (i = 0; i < numsamp; ++i) {
                t = i;
                val = (float)(Math.cos(omega1 * t) * Math.sin(omega2 * t));
                if (!((double)Math.abs(frm[j][i] - val) > 0.001)) continue;
                throw new SeisException("\nError validating compression for trace " + j + " sample " + i + " value " + val + " frame[trace][sample] = " + frm[j][i]);
            }
        }
        System.out.println("SeisCompress SCALAR16 validation completed");
        buf = null;
        sc = null;
        System.gc();
        reclen = SeisCompress.recordLength(NATIVE, numsamp);
        buf = ByteBuffer.allocateDirect(reclen * ntrc);
        sc = new SeisCompress(NATIVE, numsamp, buf);
        sc.packFrame(ntrc, frm);
        for (j = 0; j < ntrc; ++j) {
            for (i = 0; i < numsamp; ++i) {
                frm[j][i] = 0.0f;
            }
        }
        sc.unpackFrame(ntrc, frm);
        for (j = 0; j < ntrc; ++j) {
            omega2 = (double)(j + 10) * omega1;
            for (i = 0; i < numsamp; ++i) {
                t = i;
                val = (float)(Math.cos(omega1 * t) * Math.sin(omega2 * t));
                if (!((double)Math.abs(frm[j][i] - val) > 0.001)) continue;
                throw new SeisException("\nError validating compression for trace " + j + " sample " + i + " value " + val + " frame[trace][sample] = " + frm[j][i]);
            }
        }
        System.out.println("SeisCompress NATIVE validation completed");
    }
}

