/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class VmwHostnameId
extends HostId
implements FlexlmConstants {
    private String hostname;

    public VmwHostnameId() throws FlexlmException {
        this("VMW_HOSTNAME=host.foo.com");
    }

    public VmwHostnameId(String string) throws FlexlmException {
        if (!string.startsWith(this.getKeyword() + "=")) {
            throw new FlexlmException(-504, 2086);
        }
        String string2 = string.substring(string.indexOf("=") + 1);
        if (string2.length() < 1) {
            throw new FlexlmException(-503, 2087);
        }
        this.hostname = string2.toLowerCase();
    }

    @Override
    public HostId createNew(String string) throws FlexlmException {
        return new VmwHostnameId(string);
    }

    @Override
    public boolean isCurrentHost() {
        boolean bl = false;
        String string = this.getCurrent();
        if (this.hostname.equals(string)) {
            bl = true;
        } else {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.hostname);
                InetAddress inetAddress2 = InetAddress.getByName(string);
                bl = inetAddress.equals(inetAddress2);
            }
            catch (UnknownHostException unknownHostException) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public HostId[] getCurrentHostIds() {
        HostId[] hostIdArray = new HostId[1];
        try {
            hostIdArray[0] = new VmwHostnameId(this.getKeyword() + "=" + this.getCurrent());
        }
        catch (FlexlmException flexlmException) {
            throw new RuntimeException(flexlmException.getMessage());
        }
        return hostIdArray;
    }

    @Override
    public String getKeyword() {
        return "VMW_HOSTNAME";
    }

    @Override
    public int getType() {
        return 122;
    }

    @Override
    public Object getValue() {
        return this.hostname;
    }

    protected String getCurrent() {
        return super.currentConnectionData().getHostname();
    }
}

