/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm;

import com.macrovision.flexlm.ConnectionData;
import com.macrovision.flexlm.ConnectionDataAdapter;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.License;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.hostid.AmznAmi;
import com.macrovision.flexlm.hostid.AmznEip;
import com.macrovision.flexlm.hostid.AmznIid;
import com.macrovision.flexlm.hostid.AnyId;
import com.macrovision.flexlm.hostid.CompositeId;
import com.macrovision.flexlm.hostid.DemoId;
import com.macrovision.flexlm.hostid.DiskSerialId;
import com.macrovision.flexlm.hostid.DisplayId;
import com.macrovision.flexlm.hostid.DockerId;
import com.macrovision.flexlm.hostid.DomainId;
import com.macrovision.flexlm.hostid.EthernetId;
import com.macrovision.flexlm.hostid.FlexId3;
import com.macrovision.flexlm.hostid.FlexId4;
import com.macrovision.flexlm.hostid.FlexId5;
import com.macrovision.flexlm.hostid.FlexId7;
import com.macrovision.flexlm.hostid.FlexId8;
import com.macrovision.flexlm.hostid.FlexlockId;
import com.macrovision.flexlm.hostid.HostIdList;
import com.macrovision.flexlm.hostid.HostnameId;
import com.macrovision.flexlm.hostid.HpvDiskSerialId;
import com.macrovision.flexlm.hostid.HpvEtherId;
import com.macrovision.flexlm.hostid.HpvHostnameId;
import com.macrovision.flexlm.hostid.HpvInternetId;
import com.macrovision.flexlm.hostid.HpvUuId;
import com.macrovision.flexlm.hostid.Intel32Id;
import com.macrovision.flexlm.hostid.Intel64Id;
import com.macrovision.flexlm.hostid.Intel96Id;
import com.macrovision.flexlm.hostid.InternetId;
import com.macrovision.flexlm.hostid.LmbEtherId;
import com.macrovision.flexlm.hostid.LmbFlexId10;
import com.macrovision.flexlm.hostid.LmbFlexId9;
import com.macrovision.flexlm.hostid.LmbHostnameId;
import com.macrovision.flexlm.hostid.LmbInternetId;
import com.macrovision.flexlm.hostid.LongId;
import com.macrovision.flexlm.hostid.PhyDiskSerialId;
import com.macrovision.flexlm.hostid.PhyDisplayId;
import com.macrovision.flexlm.hostid.PhyEtherId;
import com.macrovision.flexlm.hostid.PhyFlexId10;
import com.macrovision.flexlm.hostid.PhyFlexId11;
import com.macrovision.flexlm.hostid.PhyFlexId9;
import com.macrovision.flexlm.hostid.PhyHostnameId;
import com.macrovision.flexlm.hostid.PhyInternetId;
import com.macrovision.flexlm.hostid.PhyUserId;
import com.macrovision.flexlm.hostid.SernumId;
import com.macrovision.flexlm.hostid.StringId;
import com.macrovision.flexlm.hostid.TpmHostId;
import com.macrovision.flexlm.hostid.UserId;
import com.macrovision.flexlm.hostid.VmUuId;
import com.macrovision.flexlm.hostid.VmwEtherId;
import com.macrovision.flexlm.hostid.VmwHostnameId;
import com.macrovision.flexlm.hostid.VmwInternetId;
import com.macrovision.flexlm.hostid.VmwUuId;
import java.util.Vector;

public abstract class HostId
implements Comparable,
FlexlmConstants {
    protected ConnectionData connData;

    protected HostId() {
    }

    private static native String lGetNativeHostId(int var0, int[] var1, int var2);

    public static boolean isADocker() {
        boolean bl = false;
        try {
            HostId.getNativeHostId("CONTAINER_ID");
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static String getNativeHostId(String string) {
        int n = 0;
        switch (string) {
            case "CONTAINER_ID": {
                n = 351;
                break;
            }
            case "TPM_ID1": {
                n = 301;
                break;
            }
            case "AMZN_AMI": {
                n = 502;
                break;
            }
            case "AMZN_EIP": {
                n = 501;
                break;
            }
            case "AMZN_IID": {
                n = 503;
                break;
            }
            case "ANY": {
                n = 3;
                break;
            }
            case "COMPOSITE": {
                n = 31;
                break;
            }
            case "DEMO": {
                n = 13;
                break;
            }
            case "DISK_SERIAL_NUM": {
                n = 11;
                break;
            }
            case "DISPLAY": {
                n = 5;
                break;
            }
            case "DOMAIN": {
                n = 19;
                break;
            }
            case "ETHERNET_ID": {
                n = 2;
                break;
            }
            case "FLEXID9": {
                n = 15;
                break;
            }
            case "FLEXIDA": {
                n = 16;
                break;
            }
            case "SENTINEL_KEY": {
                n = 17;
                break;
            }
            case "FLEXID10": {
                n = 51;
                break;
            }
            case "FLEXID": {
                n = 52;
                break;
            }
            case "FLEXLOCK": {
                n = 22;
                break;
            }
            case "HOSTNAME": {
                n = 6;
                break;
            }
            case "HPV_DISK_SERIAL_NUM": {
                n = 145;
                break;
            }
            case "HPV_ETHER": {
                n = 141;
                break;
            }
            case "HPV_HOSTNAME": {
                n = 142;
                break;
            }
            case "HPV_INTERNET": {
                n = 143;
                break;
            }
            case "HPV_UUID": {
                n = 144;
                break;
            }
            case "Intel32Id": {
                n = 24;
                break;
            }
            case "Intel64Id": {
                n = 25;
                break;
            }
            case "Intel96Id": {
                n = 26;
                break;
            }
            case "INTERNET": {
                n = 12;
                break;
            }
            case "LMB_ETHER": {
                n = 201;
                break;
            }
            case "LMB_FLEXID9": {
                n = 204;
                break;
            }
            case "LMB_FLEXID10": {
                n = 205;
                break;
            }
            case "LMB_HOSTNAME": {
                n = 203;
                break;
            }
            case "LMB_INTERNET": {
                n = 202;
                break;
            }
            case "LongId": {
                n = 1;
                break;
            }
            case "PHY_DISK_SERIAL_NUM": {
                n = 101;
                break;
            }
            case "PHY_DISPLAY": {
                n = 102;
                break;
            }
            case "PHY_ETHER": {
                n = 103;
                break;
            }
            case "PHY_FLEXID9": {
                n = 84;
                break;
            }
            case "PHY_FLEXID10": {
                n = 85;
                break;
            }
            case "PHY_FLEXID11": {
                n = 86;
                break;
            }
            case "PHY_HOSTNAME": {
                n = 104;
                break;
            }
            case "PHY_INTERNET": {
                n = 105;
                break;
            }
            case "PHY_USER": {
                n = 106;
                break;
            }
            case "ID": {
                n = 18;
                break;
            }
            case "ID_STRING": {
                n = 9;
                break;
            }
            case "USER": {
                n = 4;
                break;
            }
            case "VM_UUID": {
                n = 181;
                break;
            }
            case "VMW_ETHER": {
                n = 121;
                break;
            }
            case "VMW_HOSTNAME": {
                n = 122;
                break;
            }
            case "VMW_INTERNET": {
                n = 123;
                break;
            }
            case "VMW_UUID": {
                n = 124;
                break;
            }
            default: {
                n = 0;
            }
        }
        return HostId.lGetNativeHostId(n, null, 0);
    }

    public abstract boolean isCurrentHost();

    public abstract HostId createNew(String var1) throws FlexlmException;

    protected boolean matches(HostId hostId) {
        return this.equals(hostId);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public abstract int getType();

    public String toString() {
        String string = this.getKeyword();
        if (string != null) {
            return string + "=" + this.getValue();
        }
        return "" + this.getValue();
    }

    public abstract String getKeyword();

    public abstract HostId[] getCurrentHostIds();

    public abstract Object getValue();

    static void registerVendorHostId(HostId hostId, Vector vector) throws FlexlmException {
        if (hostId.getType() < 1000) {
            throw new FlexlmException(-504, 7001);
        }
        HostId.registerHostId(hostId, vector);
    }

    private static void registerHostId(HostId hostId, Vector vector) throws FlexlmException {
        String string = hostId.getKeyword();
        int n = hostId.getType();
        for (int i = 0; i < vector.size(); ++i) {
            HostId hostId2 = (HostId)vector.elementAt(i);
            String string2 = hostId2.getKeyword();
            if (string2 != null && string != null && string2.equals(string)) {
                throw new FlexlmException(-504, 7002);
            }
            if (hostId2.getType() != n) continue;
            throw new FlexlmException(-504, 7009);
        }
        vector.add(hostId);
    }

    public boolean isThisHost(VendorInfo vendorInfo, License license) {
        boolean bl = false;
        if (vendorInfo.getUseNativeHostIds()) {
            int n;
            int n2 = this.getType();
            int[] nArray = vendorInfo.getCompositeHostIdTypes();
            int n3 = n = nArray == null ? 0 : nArray.length;
            if (n2 < 0) {
                HostId[] hostIdArray = (HostId[])this.getValue();
                block0: for (int i = 0; i < hostIdArray.length; ++i) {
                    HostId hostId;
                    String string = HostId.lGetNativeHostId(hostIdArray[i].getType(), nArray, n);
                    if (string == null || string.length() <= 0) continue;
                    String string2 = null;
                    if (license != null) {
                        string2 = license.getipaddress();
                    }
                    if (string2 != null) {
                        string = "INTERNET=" + string2;
                    }
                    if ((hostId = HostId.parseHostId(string, vendorInfo)).getType() < 0) {
                        HostId[] hostIdArray2 = (HostId[])hostId.getValue();
                        for (int j = 0; j < hostIdArray2.length; ++j) {
                            if (!hostIdArray[i].matches(hostIdArray2[j])) continue;
                            bl = true;
                            continue block0;
                        }
                        continue;
                    }
                    if (!hostIdArray[i].matches(hostId)) continue;
                    bl = true;
                    break;
                }
            } else {
                String string = HostId.lGetNativeHostId(n2, nArray, n);
                if (string != null && string.length() > 0) {
                    HostId hostId;
                    String string3 = null;
                    if (license != null) {
                        string3 = license.getipaddress();
                    }
                    if (string3 != null) {
                        string = "INTERNET=" + string3;
                    }
                    if ((hostId = HostId.parseHostId(string, vendorInfo)).getType() < 0) {
                        HostId[] hostIdArray = (HostId[])hostId.getValue();
                        for (int i = 0; i < hostIdArray.length; ++i) {
                            if (!this.matches(hostIdArray[i])) continue;
                            bl = true;
                            break;
                        }
                    } else {
                        bl = this.matches(hostId);
                    }
                }
            }
        } else {
            bl = this.isCurrentHost();
        }
        return bl;
    }

    static Vector initializeHostIdList() throws FlexlmException {
        Vector vector = new Vector();
        try {
            HostId.registerHostId(new AmznAmi(), vector);
            HostId.registerHostId(new AmznEip(), vector);
            HostId.registerHostId(new AmznIid(), vector);
            HostId.registerHostId(new AnyId(), vector);
            HostId.registerHostId(new CompositeId(), vector);
            HostId.registerHostId(new DemoId(), vector);
            HostId.registerHostId(new DiskSerialId(), vector);
            HostId.registerHostId(new DisplayId(), vector);
            HostId.registerHostId(new DockerId(), vector);
            HostId.registerHostId(new DomainId(), vector);
            HostId.registerHostId(new EthernetId(), vector);
            HostId.registerHostId(new FlexId3(), vector);
            HostId.registerHostId(new FlexId4(), vector);
            HostId.registerHostId(new FlexId5(), vector);
            HostId.registerHostId(new FlexId7(), vector);
            HostId.registerHostId(new FlexId8(), vector);
            HostId.registerHostId(new FlexlockId(), vector);
            HostId.registerHostId(new HostnameId(), vector);
            HostId.registerHostId(new HpvDiskSerialId(), vector);
            HostId.registerHostId(new HpvEtherId(), vector);
            HostId.registerHostId(new HpvHostnameId(), vector);
            HostId.registerHostId(new HpvInternetId(), vector);
            HostId.registerHostId(new HpvUuId(), vector);
            HostId.registerHostId(new InternetId(), vector);
            HostId.registerHostId(new Intel32Id(), vector);
            HostId.registerHostId(new Intel64Id(), vector);
            HostId.registerHostId(new Intel96Id(), vector);
            HostId.registerHostId(new LmbEtherId(), vector);
            HostId.registerHostId(new LmbFlexId9(), vector);
            HostId.registerHostId(new LmbFlexId10(), vector);
            HostId.registerHostId(new LmbHostnameId(), vector);
            HostId.registerHostId(new LmbInternetId(), vector);
            HostId.registerHostId(new LongId(), vector);
            HostId.registerHostId(new PhyDiskSerialId(), vector);
            HostId.registerHostId(new PhyDisplayId(), vector);
            HostId.registerHostId(new PhyEtherId(), vector);
            HostId.registerHostId(new PhyFlexId9(), vector);
            HostId.registerHostId(new PhyFlexId10(), vector);
            HostId.registerHostId(new PhyFlexId11(), vector);
            HostId.registerHostId(new PhyHostnameId(), vector);
            HostId.registerHostId(new PhyInternetId(), vector);
            HostId.registerHostId(new PhyUserId(), vector);
            HostId.registerHostId(new SernumId(), vector);
            HostId.registerHostId(new StringId(), vector);
            HostId.registerHostId(new TpmHostId(), vector);
            HostId.registerHostId(new UserId(), vector);
            HostId.registerHostId(new VmUuId(), vector);
            HostId.registerHostId(new VmwEtherId(), vector);
            HostId.registerHostId(new VmwHostnameId(), vector);
            HostId.registerHostId(new VmwInternetId(), vector);
            HostId.registerHostId(new VmwUuId(), vector);
        }
        catch (FlexlmException flexlmException) {
            throw new FlexlmException(-506, 7008);
        }
        return vector;
    }

    public static HostId parseHostId(String string, VendorInfo vendorInfo) {
        int n;
        if (string == null || string.length() == 0 || vendorInfo == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.startsWith("\"")) {
            try {
                string2 = string2.substring(1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new RuntimeException(indexOutOfBoundsException.getMessage());
            }
        }
        if (string2.endsWith("\"")) {
            try {
                string2 = string2.substring(0, string2.length() - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new RuntimeException(indexOutOfBoundsException.getMessage());
            }
        }
        if (string2.length() == 0) {
            return null;
        }
        Vector vector = vendorInfo.getHostIdList();
        HostId hostId = null;
        try {
            n = string2.indexOf(" ");
            if (n > 0) {
                hostId = new HostIdList(string2, vendorInfo);
                return hostId;
            }
        }
        catch (FlexlmException flexlmException) {
            // empty catch block
        }
        n = vector.size();
        for (int i = 0; i < n; ++i) {
            HostId hostId2 = (HostId)vector.elementAt(i);
            try {
                hostId = hostId2.createNew(string2);
                break;
            }
            catch (FlexlmException flexlmException) {
                continue;
            }
        }
        return hostId;
    }

    public int getCryptCode() {
        return 19917114;
    }

    public static HostId[] getCurrentTypeHostIds(int n, VendorInfo vendorInfo, ConnectionData connectionData) {
        Vector vector = vendorInfo.getHostIdList();
        int[] nArray = vendorInfo.getCompositeHostIdTypes();
        int n2 = nArray == null ? 0 : nArray.length;
        for (int i = 0; i < vector.size(); ++i) {
            HostId hostId = (HostId)vector.elementAt(i);
            hostId.setConnectionData(connectionData);
            if (hostId.getType() != n) continue;
            if (vendorInfo.getUseNativeHostIds()) {
                String string = HostId.lGetNativeHostId(n, nArray, n2);
                if (string == null || string.equals("")) continue;
                HostId hostId2 = HostId.parseHostId(string, vendorInfo);
                if (hostId2 instanceof HostIdList) {
                    return (HostId[])hostId2.getValue();
                }
                HostId[] hostIdArray = new HostId[]{hostId2};
                return hostIdArray;
            }
            return hostId.getCurrentHostIds();
        }
        return null;
    }

    public void setConnectionData(ConnectionData connectionData) {
        this.connData = connectionData;
    }

    public ConnectionData getConnectionData() {
        return this.connData;
    }

    protected ConnectionData currentConnectionData() {
        return this.connData == null ? new ConnectionDataAdapter() : this.connData;
    }

    protected boolean isHex(String string) {
        boolean bl = true;
        try {
            Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    protected int compareValueTo(Object object) {
        Object object2 = this.getValue();
        if (object2 == null) {
            if (object == null) {
                return 0;
            }
            return -1;
        }
        object2 = object2.toString().toLowerCase();
        object = object.toString().toLowerCase();
        return object2.toString().compareTo(object.toString());
    }

    public int compareTo(Object object) {
        int n;
        if (object == null) {
            return 1;
        }
        if (!(object instanceof HostId)) {
            return 1;
        }
        HostId hostId = (HostId)object;
        int n2 = this.getType();
        if (n2 != (n = hostId.getType())) {
            return n2 - n;
        }
        return this.compareValueTo(hostId.getValue());
    }
}

