/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.util;

import com.certicom.ecc.ECCurve;
import com.certicom.ecc.ECException;
import com.certicom.ecc.FFFactory;
import com.certicom.ecc.NoSuchECTypeException;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.FpParams;
import com.certicom.ecc.provider.FpPoint;
import com.certicom.ecc.scheme.CurveList;
import com.certicom.ecc.system.SystemConfig;
import com.certicom.ecc.util.HashOperationRandom;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;

public class DualECRandom
extends HashOperationRandom
implements Serializable {
    private static final long serialVersionUID = 3915257747655265534L;
    private static boolean p = false;
    private byte[] q;
    private int r;
    private FpPoint s;
    private FpPoint t;
    private int u;
    private static final byte[] v = new byte[]{107, 23, -47, -14, -31, 44, 66, 71, -8, -68, -26, -27, 99, -92, 64, -14, 119, 3, 125, -127, 45, -21, 51, -96, -12, -95, 57, 69, -40, -104, -62, -106};
    private static final byte[] w = new byte[]{79, -29, 66, -30, -2, 26, 127, -101, -114, -25, -21, 74, 124, 15, -98, 22, 43, -50, 51, 87, 107, 49, 94, -50, -53, -74, 64, 104, 55, -65, 81, -11};
    private static final byte[] x = new byte[]{-55, 116, 69, -12, 92, -34, -7, -16, -45, -32, 94, 30, 88, 95, -62, -105, 35, 91, -126, -75, -66, -113, -13, -17, -54, 103, -59, -104, 82, 1, -127, -110};
    private static final byte[] y = new byte[]{-78, -114, -11, 87, -70, 49, -33, -53, -35, 33, -84, 70, -30, -87, 30, 60, 48, 79, 68, -53, -121, 5, -118, -38, 44, -72, 21, 21, 30, 97, 0, 70};
    private static final byte[] z = new byte[]{-86, -121, -54, 34, -66, -117, 5, 55, -114, -79, -57, 30, -13, 32, -83, 116, 110, 29, 59, 98, -117, -89, -101, -104, 89, -9, 65, -32, -126, 84, 42, 56, 85, 2, -14, 93, -65, 85, 41, 108, 58, 84, 94, 56, 114, 118, 10, -73};
    private static final byte[] A = new byte[]{54, 23, -34, 74, -106, 38, 44, 111, 93, -98, -104, -65, -110, -110, -36, 41, -8, -12, 29, -67, 40, -102, 20, 124, -23, -38, 49, 19, -75, -16, -72, -64, 10, 96, -79, -50, 29, 126, -127, -99, 122, 67, 29, 124, -112, -22, 14, 95};
    private static final byte[] B = new byte[]{-114, 114, 45, -29, 18, 91, -35, -80, 85, -128, 22, 75, -2, 32, -72, -76, 50, 33, 106, 98, -110, 108, 87, 80, 44, -18, -34, 49, -60, 120, 22, -19, -47, -24, -105, 105, 18, 65, 121, -48, -74, -107, 16, 100, 40, -127, 80, 101};
    private static final byte[] C = new byte[]{2, 59, 22, 96, -35, 112, 29, 8, 57, -3, 69, -18, -61, 111, -98, -25, -77, 46, 19, -77, 21, -36, 2, 97, 10, -95, -74, 54, -29, 70, -33, 103, 31, 121, 15, -124, -59, -32, -101, 5, 103, 77, -69, 126, 69, -56, 3, -35};
    private static final byte[] D = new byte[]{-58, -123, -114, 6, -73, 4, 4, -23, -51, -98, 62, -53, 102, 35, -107, -76, 66, -100, 100, -127, 57, 5, 63, -75, 33, -8, 40, -81, 96, 107, 77, 61, -70, -95, 75, 94, 119, -17, -25, 89, 40, -2, 29, -63, 39, -94, -1, -88, -34, 51, 72, -77, -63, -123, 106, 66, -101, -7, 126, 126, 49, -62, -27, -67, 102};
    private static final byte[] E = new byte[]{1, 24, 57, 41, 106, 120, -102, 59, -64, 4, 92, -118, 95, -76, 44, 125, 27, -39, -104, -11, 68, 73, 87, -101, 68, 104, 23, -81, -67, 23, 39, 62, 102, 44, -105, -18, 114, -103, 94, -12, 38, 64, -59, 80, -71, 1, 63, -83, 7, 97, 53, 60, 112, -122, -94, 114, -62, 64, -120, -66, -108, 118, -97, -47, 102, 80};
    private static final byte[] F = new byte[]{1, -71, -6, 62, 81, -115, 104, 60, 107, 101, 118, 54, -108, -84, -114, -5, -82, -58, -6, -76, 79, 34, 118, 23, 26, 66, 114, 101, 7, -35, 8, -83, -44, -61, -77, -12, -63, -21, -59, -79, 34, 45, -37, -96, 119, -9, 34, -108, 59, 36, -61, -19, -6, 15, -123, -2, 36, -48, -56, -64, 21, -111, -16, -66, 111, 99};
    private static final byte[] G = new byte[]{1, -13, -67, -70, 88, 82, -107, -39, -95, 17, 13, 29, -15, -7, 67, 14, -8, 68, 44, 80, 24, -105, 111, -13, 67, 126, -7, 27, -127, -36, 11, -127, 50, -56, -43, -61, -100, 50, -48, -32, 4, -93, 9, 43, 125, 50, 124, 14, 122, 77, 38, -46, -57, -74, -101, 88, -7, 6, 102, 82, -111, 30, 69, 119, 121, -34};
    private static final byte[] H = v;
    private static final byte[] I = w;
    private static final byte[] J = new byte[]{-16, -8, 98, 25, 35, -70, 125, 114, -28, 62, -100, -42, -10, -98, 23, -82, -11, 33, 27, 55, 78, 46, 81, 80, 42, 99, -66, -49, 42, 102, 52, -70};
    private static final byte[] K = new byte[]{50, 114, -22, -51, 123, -52, 108, 22, 62, 37, -107, -61, 11, -76, 21, 3, -111, 14, 26, -102, 21, 16, 34, 57, -29, 90, 43, -24, -76, -125, -107, -20};
    private static final byte[] L = z;
    private static final byte[] M = A;
    private static final byte[] N = new byte[]{103, 17, 66, 77, 26, -117, -121, -92, 0, -96, 92, -58, -110, 31, 84, 44, 122, -118, 56, -46, -9, -8, -109, -10, -45, -65, -47, -35, 8, -42, 28, -2, -119, 23, -125, -43, 70, -9, -15, -77, 48, 99, -123, -40, 59, 54, 21, -110};
    private static final byte[] O = new byte[]{-113, 65, -72, -69, 88, 66, -111, -68, -128, -71, -103, -127, 127, 19, -46, -64, -8, -116, 86, 40, -69, -107, -35, 5, 40, 4, -72, -4, -118, 105, 22, 95, -85, 13, 20, 9, 40, 114, 13, 58, 45, -50, -60, 7, 38, -52, 99, 122};
    private static final byte[] P = D;
    private static final byte[] Q = E;
    private static final byte[] R = new byte[]{1, -13, -113, -2, -109, -30, -85, -102, -7, -64, 93, -93, 4, -73, -9, -116, -98, 110, 66, -94, -64, 61, 0, 32, 103, -127, 52, 103, -89, 18, -92, 103, 124, 71, 30, 28, -76, 105, -119, -122, -3, 57, 33, 65, 52, 27, 104, 84, -64, -6, 95, -56, -30, 94, -45, 45, -21, 9, 9, 87, -52, 70, 90, -8, -76, -109};
    private static final byte[] S = new byte[]{0, -116, 91, -58, -10, 72, 45, 109, -20, 63, -50, -79, -75, -68, -107, 25, -17, -124, -52, 42, 54, 4, -29, -64, -82, -3, -4, -113, -32, 122, 44, 120, 90, 94, -12, -88, -65, 70, -49, -28, -8, -89, -49, -51, -121, 44, -94, -14, -82, 75, 95, 53, 1, -11, -111, 102, -86, 80, 14, 118, -82, -3, -22, 77, -100, -61};

    public DualECRandom() {
        this(DualECRandom.c(), "Certicom");
    }

    private static String c() {
        int n2 = SystemConfig.getConfig().getSecurityStrength();
        if (n2 <= 80) {
            return "SHA1";
        }
        if (n2 <= 112) {
            return "SHA224";
        }
        if (n2 <= 128) {
            return "SHA256";
        }
        if (n2 <= 192) {
            return "SHA384";
        }
        if (n2 <= 256) {
            return "SHA512";
        }
        throw new IllegalStateException("Invalid security strength: " + n2);
    }

    public DualECRandom(String string, String string2) {
        super(string, 0, 8192L, p);
        this.a(string2);
    }

    protected void a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = this.d(byArray, byArray2);
        byArray3 = this.d(byArray3, this.g);
        this.q = this.a(byArray3, this.r);
        this.u = 0;
    }

    protected void b(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = this.d(this.d(this.q, this.r), byArray);
        byArray3 = this.d(byArray3, byArray2);
        this.q = this.a(byArray3, this.r);
        this.u = 0;
    }

    protected void c(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        if (byArray == null) {
            throw new IllegalStateException("buffer is null");
        }
        int n2 = this.a >> 3;
        int n3 = byArray.length / n2;
        if (this.u + n3 > 0x20000000) {
            this.l = true;
            return;
        }
        if (byArray2 != null) {
            byArray2 = this.a(byArray2, this.r);
        }
        byte[] byArray4 = null;
        int n4 = 0;
        while (n4 < byArray.length) {
            byte[] byArray5;
            if (byArray2 == null) {
                byArray5 = this.q;
            } else {
                byArray5 = this.e(this.q, byArray2);
                byArray2 = null;
            }
            this.q = this.s.a(new BigInteger(1, byArray5)).e().f();
            byArray3 = this.t.a(new BigInteger(1, this.q)).e().f();
            this.a(byArray3);
            byArray4 = this.a(byArray4, 0, n4, byArray3, byArray3.length - n2, n2);
            ++this.u;
            n4 = byArray4.length;
        }
        byArray3 = this.e(byArray4, byArray.length);
        System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
        this.q = this.s.a(new BigInteger(1, this.q)).e().f();
    }

    private byte[] d(byte[] byArray, int n2) {
        if (n2 % 8 == 0) {
            return byArray;
        }
        byte[] byArray2 = this.b(byArray, 8 - n2 % 8);
        return byArray2;
    }

    private byte[] e(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new IllegalStateException("can't trunc null byte stream");
        }
        if (byArray.length == n2) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        if (byArray.length > n2) {
            System.arraycopy(byArray, 0, byArray2, 0, n2);
        } else {
            Arrays.fill(byArray2, (byte)0);
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }

    private void a(String string) {
        FFFactory fFFactory;
        String string2;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (this.e <= 128) {
            string2 = "secp256r1";
            if ("Certicom".equals(string)) {
                byArray = H;
                byArray2 = I;
                byArray3 = J;
                byArray4 = K;
            } else {
                byArray = v;
                byArray2 = w;
                byArray3 = x;
                byArray4 = y;
            }
            this.r = 256;
            this.a = 240;
        } else if (this.e <= 192) {
            string2 = "secp384r1";
            if ("Certicom".equals(string)) {
                byArray = L;
                byArray2 = M;
                byArray3 = N;
                byArray4 = O;
            } else {
                byArray = z;
                byArray2 = A;
                byArray3 = B;
                byArray4 = C;
            }
            this.r = 384;
            this.a = 368;
        } else if (this.e <= 256) {
            string2 = "secp521r1";
            if ("Certicom".equals(string)) {
                byArray = P;
                byArray2 = Q;
                byArray3 = R;
                byArray4 = S;
            } else {
                byArray = D;
                byArray2 = E;
                byArray3 = F;
                byArray4 = G;
            }
            this.r = 521;
            this.a = 504;
        } else {
            throw new IllegalArgumentException("Invalid security strength value");
        }
        ECParams eCParams = CurveList.byName(string2);
        try {
            fFFactory = FFFactory.a("FP");
        }
        catch (NoSuchECTypeException noSuchECTypeException) {
            throw new IllegalStateException("wrong EC element type: " + noSuchECTypeException.getMessage());
        }
        try {
            fFFactory.a(((FpParams)eCParams).getPrime(), null);
        }
        catch (ECException eCException) {
            throw new IllegalStateException("failed to intialize factory: " + eCException.getMessage());
        }
        ECCurve eCCurve = new ECCurve(fFFactory.a(eCParams.getA()), fFFactory.a(eCParams.getB()), new BigInteger(1, eCParams.getPointOrder()));
        this.s = new FpPoint(fFFactory.a(byArray), fFFactory.a(byArray2), eCCurve);
        this.t = new FpPoint(fFFactory.a(byArray3), fFFactory.a(byArray4), eCCurve);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.q);
        objectOutputStream.writeInt(this.r);
        objectOutputStream.writeObject(this.s);
        objectOutputStream.writeObject(this.t);
        objectOutputStream.writeInt(this.u);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.q = (byte[])objectInputStream.readObject();
        this.r = objectInputStream.readInt();
        this.s = (FpPoint)objectInputStream.readObject();
        this.t = (FpPoint)objectInputStream.readObject();
        this.u = objectInputStream.readInt();
    }

    public static final class DualECRandomSHA512Certicom
    extends DualECRandom
    implements Serializable {
        private static final long serialVersionUID = -4729537110700728028L;

        public DualECRandomSHA512Certicom() {
            super("SHA512", "Certicom");
        }
    }

    public static final class DualECRandomSHA384Certicom
    extends DualECRandom
    implements Serializable {
        private static final long serialVersionUID = -2983019356419433799L;

        public DualECRandomSHA384Certicom() {
            super("SHA384", "Certicom");
        }
    }

    public static final class DualECRandomSHA256Certicom
    extends DualECRandom
    implements Serializable {
        private static final long serialVersionUID = 9124401668783384017L;

        public DualECRandomSHA256Certicom() {
            super("SHA256", "Certicom");
        }
    }

    public static final class DualECRandomSHA224Certicom
    extends DualECRandom
    implements Serializable {
        private static final long serialVersionUID = -1563241636611987231L;

        public DualECRandomSHA224Certicom() {
            super("SHA224", "Certicom");
        }
    }

    public static final class DualECRandomSHA1Certicom
    extends DualECRandom
    implements Serializable {
        private static final long serialVersionUID = 4222724085872992188L;

        public DualECRandomSHA1Certicom() {
            super("SHA1", "Certicom");
        }
    }

    public static final class DualECRandomSHA512NIST
    extends DualECRandom
    implements Serializable {
        private static final long serialVersionUID = -4729537110700728028L;

        public DualECRandomSHA512NIST() {
            super("SHA512", "NIST");
        }
    }

    public static final class DualECRandomSHA384NIST
    extends DualECRandom
    implements Serializable {
        private static final long serialVersionUID = -2983019356419433799L;

        public DualECRandomSHA384NIST() {
            super("SHA384", "NIST");
        }
    }

    public static final class DualECRandomSHA256NIST
    extends DualECRandom
    implements Serializable {
        private static final long serialVersionUID = 9124401668783384017L;

        public DualECRandomSHA256NIST() {
            super("SHA256", "NIST");
        }
    }

    public static final class DualECRandomSHA224NIST
    extends DualECRandom
    implements Serializable {
        private static final long serialVersionUID = -1563241636611987231L;

        public DualECRandomSHA224NIST() {
            super("SHA224", "NIST");
        }
    }

    public static final class DualECRandomSHA1NIST
    extends DualECRandom
    implements Serializable {
        private static final long serialVersionUID = 4222724085872992188L;

        public DualECRandomSHA1NIST() {
            super("SHA1", "NIST");
        }
    }
}

