/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import org.javaseis.array.ArrayStorage;
import org.javaseis.array.IBackingArray;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.util.ArrayUtil;

public abstract class MessageContext
implements IParallelContext {
    protected int _size = -1;
    protected int _rank = -1;
    protected int _pmax = 0;
    protected static final int MASTER = 0;
    protected static final int SHIFT_TAG = 101010;
    protected static final int TRANS_TAG = 202020;
    protected static final int TREE_TAG = 303030;
    protected static final int SUM_TAG = 404040;
    protected static final int BARRIER_TAG = 505050;

    @Override
    public boolean isMaster() {
        return this.rank() == 0;
    }

    @Override
    public boolean failure(boolean test) {
        Boolean[] buf = new Boolean[]{test};
        if (this.rank() == 0) {
            buf[0] = test;
        }
        this.bcast(99, buf, 0, 1, 0);
        return buf[0];
    }

    @Override
    public void masterPrint(String s) {
        if (this.rank() == 0) {
            System.out.println(s);
        }
        System.out.flush();
        this.barrier();
    }

    @Override
    public void serialPrint(String s) {
        System.out.flush();
        this.barrier();
        for (int i = 0; i < this._size; ++i) {
            if (i == this.rank()) {
                System.out.println(s);
            }
            System.out.flush();
            this.barrier();
        }
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public int rank() {
        return this._rank;
    }

    @Override
    public void barrier() {
        int target;
        int[] buf = new int[]{0};
        if (this._size <= 1) {
            return;
        }
        int j2 = this._pmax;
        for (int i = 0; i < this._pmax; ++i) {
            int source;
            int k2 = j2 / 2;
            if (this.rank() % j2 == 0) {
                target = this.rank() + k2;
                if (target < this._size) {
                    this.sendObject(DataType.INT, 505050, buf, 0, 1, target);
                }
            } else if (this.rank() % k2 == 0 && (source = this.rank() - k2) >= 0) {
                this.recvObject(DataType.INT, 505050, buf, 0, 1);
            }
            j2 = k2;
        }
        if (this._size % 2 != 0) {
            target = this._size - 1;
            if (this.rank() == 0) {
                this.sendObject(DataType.INT, 505050, buf, 0, 1, target);
            } else if (this.rank() == target) {
                this.recvObject(DataType.INT, 505050, buf, 0, 1);
            }
        }
    }

    protected abstract void sendObject(DataType var1, int var2, Object var3, int var4, int var5, int var6);

    @Override
    public <T> void send(int tag, T buf, int offset, int count, int dest) {
        this.sendObject(DataType.OBJECT, tag, buf, offset, count, dest);
    }

    @Override
    public void sendByte(int tag, byte[] buf, int offset, int count, int dest) {
        this.sendObject(DataType.BYTE, tag, buf, offset, count, dest);
    }

    @Override
    public void sendShort(int tag, short[] buf, int offset, int count, int dest) {
        this.sendObject(DataType.SHORT, tag, buf, offset, count, dest);
    }

    @Override
    public void sendInt(int tag, int[] buf, int offset, int count, int dest) {
        this.sendObject(DataType.INT, tag, buf, offset, count, dest);
    }

    @Override
    public void sendLong(int tag, long[] buf, int offset, int count, int dest) {
        this.sendObject(DataType.LONG, tag, buf, offset, count, dest);
    }

    @Override
    public void sendFloat(int tag, float[] buf, int offset, int count, int dest) {
        this.sendObject(DataType.FLOAT, tag, buf, offset, count, dest);
    }

    @Override
    public void sendDouble(int tag, double[] buf, int offset, int count, int dest) {
        this.sendObject(DataType.DOUBLE, tag, buf, offset, count, dest);
    }

    protected abstract void recvObject(DataType var1, int var2, Object var3, int var4, int var5);

    @Override
    public <T> void recv(int tag, T buf, int offset, int count) {
        this.recvObject(DataType.OBJECT, tag, buf, offset, count);
    }

    @Override
    public void recvByte(int tag, byte[] buf, int offset, int count) {
        this.recvObject(DataType.BYTE, tag, buf, offset, count);
    }

    @Override
    public void recvShort(int tag, short[] buf, int offset, int count) {
        this.recvObject(DataType.SHORT, tag, buf, offset, count);
    }

    @Override
    public void recvInt(int tag, int[] buf, int offset, int count) {
        this.recvObject(DataType.INT, tag, buf, offset, count);
    }

    @Override
    public void recvLong(int tag, long[] buf, int offset, int count) {
        this.recvObject(DataType.LONG, tag, buf, offset, count);
    }

    @Override
    public void recvFloat(int tag, float[] buf, int offset, int count) {
        this.recvObject(DataType.FLOAT, tag, buf, offset, count);
    }

    @Override
    public void recvDouble(int tag, double[] buf, int offset, int count) {
        this.recvObject(DataType.DOUBLE, tag, buf, offset, count);
    }

    protected void bcastObject(DataType type, int tag, Object buf, int offset, int count, int sender) {
        int target;
        if (this._size <= 1) {
            return;
        }
        if (sender != 0) {
            if (this.rank() == sender) {
                this.sendObject(type, tag, buf, offset, count, 0);
            } else if (this.rank() == 0) {
                this.recvObject(type, tag, buf, offset, count);
            }
        }
        int j2 = this._pmax;
        for (int i = 0; i < this._pmax; ++i) {
            int source;
            int k2 = j2 / 2;
            if (this.rank() % j2 == 0) {
                target = this.rank() + k2;
                if (target < this._size) {
                    this.sendObject(type, tag, buf, offset, count, target);
                }
            } else if (this.rank() % k2 == 0 && (source = this.rank() - k2) >= 0) {
                this.recvObject(type, tag, buf, offset, count);
            }
            j2 = k2;
        }
        if (this._size % 2 != 0) {
            target = this._size - 1;
            if (this.rank() == 0) {
                this.sendObject(type, tag, buf, offset, count, target);
            } else if (this.rank() == target) {
                this.recvObject(type, tag, buf, offset, count);
            }
        }
    }

    @Override
    public <T> void bcast(int tag, T buf, int offset, int count, int sender) {
        this.bcastObject(DataType.OBJECT, tag, buf, offset, count, sender);
    }

    @Override
    public void bcastByte(int tag, byte[] buf, int offset, int count, int sender) {
        this.bcastObject(DataType.BYTE, tag, buf, offset, count, sender);
    }

    @Override
    public void bcastShort(int tag, short[] buf, int offset, int count, int sender) {
        this.bcastObject(DataType.SHORT, tag, buf, offset, count, sender);
    }

    @Override
    public void bcastInt(int tag, int[] buf, int offset, int count, int sender) {
        this.bcastObject(DataType.INT, tag, buf, offset, count, sender);
    }

    @Override
    public void bcastLong(int tag, long[] buf, int offset, int count, int sender) {
        this.bcastObject(DataType.LONG, tag, buf, offset, count, sender);
    }

    @Override
    public void bcastFloat(int tag, float[] buf, int offset, int count, int sender) {
        this.bcastObject(DataType.FLOAT, tag, buf, offset, count, sender);
    }

    @Override
    public void bcastDouble(int tag, double[] buf, int offset, int count, int sender) {
        this.bcastObject(DataType.DOUBLE, tag, buf, offset, count, sender);
    }

    protected void shiftObject(DataType type, int nshift, Object a, int offset, int count, Object b) {
        int myswap = (this.rank() + nshift) % this._size;
        if (myswap == this.rank()) {
            return;
        }
        try {
            if (myswap > this.rank()) {
                this.sendObject(type, 101010 + myswap, a, offset, count, myswap);
                this.recvObject(type, 101010 + this.rank(), b, offset, count);
            } else {
                this.recvObject(type, 101010 + this.rank(), b, offset, count);
                this.sendObject(type, 101010 + myswap, a, offset, count, myswap);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Message Passing Exception: " + ex.getMessage());
        }
        ArrayUtil.arraycopy(b, 0, a, offset, count);
    }

    @Override
    public <T> void shift(int nshift, T a, int offset, int count, T buf) {
        this.shiftObject(DataType.OBJECT, nshift, a, offset, count, buf);
    }

    @Override
    public void shiftByte(int nshift, byte[] a, int offset, int count, byte[] buf) {
        this.shiftObject(DataType.BYTE, nshift, a, offset, count, buf);
    }

    @Override
    public void shiftShort(int nshift, short[] a, int offset, int count, short[] buf) {
        this.shiftObject(DataType.SHORT, nshift, a, offset, count, buf);
    }

    @Override
    public void shiftInt(int nshift, int[] a, int offset, int count, int[] buf) {
        this.shiftObject(DataType.INT, nshift, a, offset, count, buf);
    }

    @Override
    public void shiftLong(int nshift, long[] a, int offset, int count, long[] buf) {
        this.shiftObject(DataType.LONG, nshift, a, offset, count, buf);
    }

    @Override
    public void shiftFloat(int nshift, float[] a, int offset, int count, float[] buf) {
        this.shiftObject(DataType.FLOAT, nshift, a, offset, count, buf);
    }

    @Override
    public void shiftDouble(int nshift, double[] a, int offset, int count, double[] buf) {
        this.shiftObject(DataType.DOUBLE, nshift, a, offset, count, buf);
    }

    @Override
    public <T> void globalSum(T a, int aoffset, T b, int boffset, int count) {
    }

    @Override
    public void globalSumByte(byte[] a, int aoffset, byte[] b, int boffset, int count) {
        byte[] c = new byte[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.BYTE, OpType.SUM);
    }

    @Override
    public void globalSumShort(short[] a, int aoffset, short[] b, int boffset, int count) {
        short[] c = new short[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.SHORT, OpType.SUM);
    }

    @Override
    public void globalSumInt(int[] a, int aoffset, int[] b, int boffset, int count) {
        int[] c = new int[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.INT, OpType.SUM);
    }

    @Override
    public void globalSumLong(long[] a, int aoffset, long[] b, int boffset, int count) {
        long[] c = new long[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.LONG, OpType.SUM);
    }

    @Override
    public void globalSumFloat(float[] a, int aoffset, float[] b, int boffset, int count) {
        float[] c = new float[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.FLOAT, OpType.SUM);
    }

    @Override
    public void globalSumDouble(double[] a, int aoffset, double[] b, int boffset, int count) {
        double[] c = new double[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.DOUBLE, OpType.SUM);
    }

    @Override
    public <T> void globalMin(T a, int aoffset, T b, int boffset, int count) {
    }

    @Override
    public void globalMinByte(byte[] a, int aoffset, byte[] b, int boffset, int count) {
        byte[] c = new byte[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.BYTE, OpType.MIN);
    }

    @Override
    public void globalMinShort(short[] a, int aoffset, short[] b, int boffset, int count) {
        short[] c = new short[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.SHORT, OpType.MIN);
    }

    @Override
    public void globalMinInt(int[] a, int aoffset, int[] b, int boffset, int count) {
        int[] c = new int[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.INT, OpType.MIN);
    }

    @Override
    public void globalMinLong(long[] a, int aoffset, long[] b, int boffset, int count) {
        long[] c = new long[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.LONG, OpType.MIN);
    }

    @Override
    public void globalMinFloat(float[] a, int aoffset, float[] b, int boffset, int count) {
        float[] c = new float[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.FLOAT, OpType.MIN);
    }

    @Override
    public void globalMinDouble(double[] a, int aoffset, double[] b, int boffset, int count) {
        double[] c = new double[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.DOUBLE, OpType.MIN);
    }

    @Override
    public <T> void globalMax(T a, int aoffset, T b, int boffset, int count) {
    }

    @Override
    public void globalMaxByte(byte[] a, int aoffset, byte[] b, int boffset, int count) {
        byte[] c = new byte[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.BYTE, OpType.MAX);
    }

    @Override
    public void globalMaxShort(short[] a, int aoffset, short[] b, int boffset, int count) {
        short[] c = new short[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.SHORT, OpType.MAX);
    }

    @Override
    public void globalMaxInt(int[] a, int aoffset, int[] b, int boffset, int count) {
        int[] c = new int[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.INT, OpType.MAX);
    }

    @Override
    public void globalMaxLong(long[] a, int aoffset, long[] b, int boffset, int count) {
        long[] c = new long[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.LONG, OpType.MAX);
    }

    @Override
    public void globalMaxFloat(float[] a, int aoffset, float[] b, int boffset, int count) {
        float[] c = new float[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.FLOAT, OpType.MAX);
    }

    @Override
    public void globalMaxDouble(double[] a, int aoffset, double[] b, int boffset, int count) {
        double[] c = new double[count];
        this.reduceObject(a, aoffset, b, boffset, count, c, DataType.DOUBLE, OpType.MAX);
    }

    protected void reduceObject(Object a, int aoffset, Object b, int boffset, int count, Object c, DataType type, OpType op) {
        try {
            if (this.isMaster()) {
                ArrayUtil.arraycopy(a, aoffset, b, boffset, count);
                for (int i = 1; i < this._size; ++i) {
                    this.recvObject(type, 404040 + i, c, 0, count);
                    this.reduceOperation(b, boffset, c, 0, count, type, op);
                }
            } else {
                this.sendObject(type, 404040 + this.rank(), a, aoffset, count, 0);
            }
            this.bcastObject(type, 404040, b, boffset, count, 0);
        }
        catch (Exception ex) {
            throw new RuntimeException("Message Passing Exception: " + ex.getMessage());
        }
    }

    private void reduceOperation(Object b, int boffset, Object c, int coffset, int count, DataType type, OpType op) {
        if (type == DataType.BYTE) {
            this.reduceBytes((byte[])b, boffset, (byte[])c, coffset, count, op);
        } else if (type == DataType.SHORT) {
            this.reduceShorts((short[])b, boffset, (short[])c, coffset, count, op);
        } else if (type == DataType.INT) {
            this.reduceInts((int[])b, boffset, (int[])c, coffset, count, op);
        } else if (type == DataType.LONG) {
            this.reduceLongs((long[])b, boffset, (long[])c, coffset, count, op);
        } else if (type == DataType.DOUBLE) {
            this.reduceDoubles((double[])b, boffset, (double[])c, coffset, count, op);
        } else {
            this.reduceFloats((float[])b, boffset, (float[])c, coffset, count, op);
        }
    }

    private void reduceBytes(byte[] b, int boffset, byte[] c, int coffset, int count, OpType op) {
        for (int i = 0; i < count; ++i) {
            if (op != OpType.MIN) continue;
            if (c[i] < b[i]) {
                b[i] = c[i];
                continue;
            }
            if (op != OpType.MAX) continue;
            b[i] = c[i] > b[i] ? c[i] : (byte)(b[i] + c[i]);
        }
    }

    private void reduceShorts(short[] b, int boffset, short[] c, int coffset, int count, OpType op) {
        for (int i = 0; i < count; ++i) {
            if (op != OpType.MIN) continue;
            if (c[i] < b[i]) {
                b[i] = c[i];
                continue;
            }
            if (op != OpType.MAX) continue;
            b[i] = c[i] > b[i] ? c[i] : (short)(b[i] + c[i]);
        }
    }

    private void reduceInts(int[] b, int boffset, int[] c, int coffset, int count, OpType op) {
        for (int i = 0; i < count; ++i) {
            if (op != OpType.MIN) continue;
            if (c[i] < b[i]) {
                b[i] = c[i];
                continue;
            }
            if (op != OpType.MAX) continue;
            b[i] = c[i] > b[i] ? c[i] : b[i] + c[i];
        }
    }

    private void reduceLongs(long[] b, int boffset, long[] c, int coffset, int count, OpType op) {
        for (int i = 0; i < count; ++i) {
            if (op != OpType.MIN) continue;
            if (c[i] < b[i]) {
                b[i] = c[i];
                continue;
            }
            if (op != OpType.MAX) continue;
            b[i] = c[i] > b[i] ? c[i] : b[i] + c[i];
        }
    }

    private void reduceFloats(float[] b, int boffset, float[] c, int coffset, int count, OpType op) {
        for (int i = 0; i < count; ++i) {
            if (op != OpType.MIN) continue;
            if (c[i] < b[i]) {
                b[i] = c[i];
                continue;
            }
            if (op != OpType.MAX) continue;
            b[i] = c[i] > b[i] ? c[i] : b[i] + c[i];
        }
    }

    private void reduceDoubles(double[] b, int boffset, double[] c, int coffset, int count, OpType op) {
        for (int i = 0; i < count; ++i) {
            if (op != OpType.MIN) continue;
            if (c[i] < b[i]) {
                b[i] = c[i];
                continue;
            }
            if (op != OpType.MAX) continue;
            b[i] = c[i] > b[i] ? c[i] : b[i] + c[i];
        }
    }

    @Override
    public <T> void collect(T a, int aoffset, T b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, DataType.OBJECT);
    }

    @Override
    public void collectByte(byte[] a, int aoffset, byte[] b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, DataType.BYTE);
    }

    @Override
    public void collectShort(short[] a, int aoffset, short[] b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, DataType.SHORT);
    }

    @Override
    public void collectInt(int[] a, int aoffset, int[] b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, DataType.INT);
    }

    @Override
    public void collectLong(long[] a, int aoffset, long[] b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, DataType.LONG);
    }

    @Override
    public void collectFloat(float[] a, int aoffset, float[] b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, DataType.FLOAT);
    }

    @Override
    public void collectDouble(double[] a, int aoffset, double[] b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, DataType.DOUBLE);
    }

    @Override
    public byte[] collectByte(byte ai) {
        byte[] a = new byte[]{ai};
        byte[] b = new byte[this._size];
        this.gatherPrimitive(a, 0, b, 0, 1, DataType.BYTE);
        return b;
    }

    @Override
    public short[] collectShort(short ai) {
        short[] a = new short[]{ai};
        short[] b = new short[this._size];
        this.gatherPrimitive(a, 0, b, 0, 1, DataType.SHORT);
        return b;
    }

    @Override
    public int[] collectInt(int ai) {
        int[] a = new int[]{ai};
        int[] b = new int[this._size];
        this.gatherPrimitive(a, 0, b, 0, 1, DataType.INT);
        return b;
    }

    @Override
    public long[] collectLong(long ai) {
        long[] a = new long[]{ai};
        long[] b = new long[this._size];
        this.gatherPrimitive(a, 0, b, 0, 1, DataType.LONG);
        return b;
    }

    @Override
    public float[] collectFloat(float ai) {
        float[] a = new float[]{ai};
        float[] b = new float[this._size];
        this.gatherPrimitive(a, 0, b, 0, 1, DataType.FLOAT);
        return b;
    }

    @Override
    public double[] collectDouble(double ai) {
        double[] a = new double[]{ai};
        double[] b = new double[this._size];
        this.gatherPrimitive(a, 0, b, 0, 1, DataType.DOUBLE);
        return b;
    }

    protected void gatherPrimitive(Object a, int aoffset, Object b, int boffset, int count, DataType type) {
        try {
            if (this.isMaster()) {
                ArrayUtil.arraycopy(a, aoffset, b, boffset, count);
                int offset = boffset;
                for (int i = 1; i < this._size; ++i) {
                    this.recvObject(type, 404040 + i, b, offset += count, count);
                }
            } else {
                this.sendObject(type, 404040 + this.rank(), a, aoffset, count, 0);
            }
            this.bcastObject(type, 404040, b, boffset, this._size * count, 0);
        }
        catch (Exception ex) {
            throw new RuntimeException("Message Passing Exception: " + ex.getMessage());
        }
    }

    protected void ttranObject(DataType type, int tileSize, Object a, int startOffset, Object buf) {
        if (this._size <= 1) {
            return;
        }
        int offset = startOffset;
        for (int i = 1; i < this._pmax; ++i) {
            int myswap = this.rank() ^ i;
            if (myswap >= this._size) continue;
            offset = tileSize * myswap;
            try {
                if (myswap > this.rank()) {
                    this.sendObject(type, 202020 + i, a, offset, tileSize, myswap);
                    this.recvObject(type, 202020 + i, buf, 0, tileSize);
                } else {
                    this.recvObject(type, 202020 + i, buf, 0, tileSize);
                    this.sendObject(type, 202020 + i, a, offset, tileSize, myswap);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Message Passing Exception: " + ex.getMessage());
            }
            ArrayUtil.arraycopy(buf, 0, a, offset, tileSize);
        }
    }

    @Override
    public <T> void ttran(int tileSize, T a, int offset, T buf) {
        this.ttranObject(DataType.OBJECT, tileSize, a, offset, buf);
    }

    @Override
    public void ttranByte(int tileSize, byte[] a, int offset, byte[] buf) {
        this.ttranObject(DataType.BYTE, tileSize, a, offset, buf);
    }

    @Override
    public void ttranShort(int tileSize, short[] a, int offset, short[] buf) {
        this.ttranObject(DataType.SHORT, tileSize, a, offset, buf);
    }

    @Override
    public void ttranInt(int tileSize, int[] a, int offset, int[] buf) {
        this.ttranObject(DataType.INT, tileSize, a, offset, buf);
    }

    @Override
    public void ttranLong(int tileSize, long[] a, int offset, long[] buf) {
        this.ttranObject(DataType.LONG, tileSize, a, offset, buf);
    }

    @Override
    public void ttranFloat(int tileSize, float[] a, int offset, float[] buf) {
        this.ttranObject(DataType.FLOAT, tileSize, a, offset, buf);
    }

    @Override
    public void ttranDouble(int tileSize, double[] a, int offset, double[] buf) {
        this.ttranObject(DataType.DOUBLE, tileSize, a, offset, buf);
    }

    @Override
    public void ttran(int tileSize, IBackingArray b) {
        int offset = (int)b.getOffset();
        Object a = ((ArrayStorage)b).getArray();
        Class<?> componentType = a.getClass().getComponentType();
        if (componentType.equals(Byte.TYPE)) {
            byte[] buf = new byte[tileSize];
            this.ttranObject(DataType.BYTE, tileSize, a, offset, buf);
        } else if (componentType.equals(Short.TYPE)) {
            short[] buf = new short[tileSize];
            this.ttranObject(DataType.SHORT, tileSize, a, offset, buf);
        } else if (componentType.equals(Integer.TYPE)) {
            int[] buf = new int[tileSize];
            this.ttranObject(DataType.INT, tileSize, a, offset, buf);
        } else if (componentType.equals(Long.TYPE)) {
            long[] buf = new long[tileSize];
            this.ttranObject(DataType.LONG, tileSize, a, offset, buf);
        } else if (componentType.equals(Float.TYPE)) {
            float[] buf = new float[tileSize];
            this.ttranObject(DataType.FLOAT, tileSize, a, offset, buf);
        } else if (componentType.equals(Double.TYPE)) {
            double[] buf = new double[tileSize];
            this.ttranObject(DataType.DOUBLE, tileSize, a, offset, buf);
        } else {
            byte[] buf = new byte[tileSize];
            this.ttranObject(DataType.OBJECT, tileSize, a, offset, buf);
        }
    }

    @Override
    public <T> void ttranv(int[] lena, int[] aoffset, T[] a, int[] lenb, int[] boffset, T[] b) {
        if (this._size <= 1) {
            return;
        }
        ArrayUtil.arraycopy(a, aoffset[this.rank()], b, boffset[this.rank()], lena[this.rank()]);
        for (int i = 1; i < this._pmax; ++i) {
            int j = this.rank() ^ i;
            if (j >= this._size) continue;
            try {
                if (j > this.rank()) {
                    if (lena[j] > 0) {
                        this.sendObject(DataType.OBJECT, 202020 + i, a, aoffset[j], lena[j], j);
                    }
                    if (lenb[j] <= 0) continue;
                    this.recvObject(DataType.OBJECT, 202020 + i, b, boffset[j], lenb[j]);
                    continue;
                }
                if (lenb[j] > 0) {
                    this.recvObject(DataType.OBJECT, 202020 + i, b, boffset[j], lenb[j]);
                }
                if (lena[j] <= 0) continue;
                this.sendObject(DataType.OBJECT, 202020 + i, a, aoffset[j], lena[j], j);
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException("Message Passing Exception: " + ex.getMessage());
            }
        }
    }

    @Override
    public void ttranvInit(int[] lena, int[] aoffset, int[] lenb, int[] boffset) {
        int[] buf = new int[1];
        ArrayUtil.arraycopy(lena, 0, lenb, 0, this._size);
        this.ttranInt(1, lenb, 0, buf);
        boffset[0] = 0;
        for (int i = 1; i < this._size; ++i) {
            boffset[i] = boffset[i - 1] + lenb[i - 1];
        }
    }

    public <T> void binaryTree(int len, T buf, int startOffset) {
        if (this._size <= 1) {
            return;
        }
        if (this._size % 2 != 0) {
            return;
        }
        int j2 = this._pmax;
        for (int i = 0; i < this._pmax; ++i) {
            int k2 = j2 / 2;
            if (this.rank() % j2 == 0) {
                int target = this.rank() + k2;
                if (target < this._size) {
                    this.send(303030, buf, startOffset, len, target);
                }
            } else if (this.rank() % k2 == 0) {
                int source = this.rank() - k2;
                this.recv(303030, buf, startOffset, len);
            }
            j2 = k2;
        }
    }

    @Override
    public void finish() {
        throw new RuntimeException("finish is not implemented");
    }

    protected static enum OpType {
        MIN,
        MAX,
        SUM,
        DIFF,
        MULT;

    }

    protected static enum DataType {
        OBJECT,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

