/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import java.io.File;

public class VirtualFolder {
    private String _path;
    private Attribute _attrib;

    public VirtualFolder(String path) {
        if (path == null || path.length() < 1) {
            throw new IllegalArgumentException("A valid path must be specified");
        }
        String[] parts = path.split(",");
        this._path = parts[0];
        this._attrib = parts.length == 2 ? Attribute.valueOf(parts[1]) : Attribute.READ_WRITE;
        if (this._path.charAt(this._path.length() - 1) == File.separatorChar) {
            this._path = this._path.substring(0, this._path.length() - 1);
        }
    }

    public void addElement(String item) {
        this._path = this._path + File.separatorChar + item;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String getPath() {
        return this._path;
    }

    public Attribute getAttribute() {
        return this._attrib;
    }

    public String toString() {
        return this._path + "," + this._attrib.toString();
    }

    public boolean isReadOnly() {
        return this._attrib == Attribute.READ_ONLY;
    }

    public boolean isOverFlowOnly() {
        return this._attrib == Attribute.OVERFLOW_ONLY;
    }

    public boolean isRetired() {
        return this._attrib == Attribute.RETIRED;
    }

    public boolean isWriteable() {
        return this._attrib == Attribute.READ_WRITE;
    }

    public void setAttribute(Attribute attrib) {
        this._attrib = attrib;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VirtualFolder)) {
            return false;
        }
        return this._path.compareToIgnoreCase(((VirtualFolder)obj).getPath()) == 0;
    }

    public int count() {
        File f = new File(this._path);
        if (!f.exists()) {
            return 0;
        }
        String[] stuff = f.list();
        if (stuff != null && stuff.length > 0) {
            return stuff.length;
        }
        return 0;
    }

    public static enum Attribute {
        READ_ONLY,
        READ_WRITE,
        OVERFLOW_ONLY,
        RETIRED;

    }
}

