/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.fft;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import org.javaseis.array.JPerfTestShapes;
import org.javaseis.fft.FftNd;
import org.javaseis.fft.IFFT;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayPositionIterator;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.parallel.MPIContext;
import org.javaseis.util.MemoryReporter;

public class JPerfTestFftNd {
    private int _logLevel;
    private boolean _doChecks;

    public JPerfTestFftNd() {
        this(Level.INFO, false);
    }

    public JPerfTestFftNd(Level level, boolean doChecks) {
        this.setLevel(level);
        this._doChecks = doChecks;
    }

    private void fftHarness(int fftDimensions, int[] shape, float[] pad, IParallelContext pc) {
        FftNd fnd = new FftNd(fftDimensions, shape, pad, IFFT.Type.REAL);
        int[] maxshape = fnd.getForwardShape();
        int ndim = maxshape.length;
        for (int i = 0; i < ndim; ++i) {
            maxshape[i] = DistributedArray.makeLegalForTranspose(maxshape[i], pc.size());
        }
        DistributedArray da = new DistributedArray(pc, 2, maxshape);
        da.setShape(1, shape);
        int nt = shape[0] * da.getElementCount();
        float[] trc = new float[nt];
        int[] pos = new int[shape.length];
        DistributedArrayPositionIterator dati = new DistributedArrayPositionIterator(da, pos);
        Random r = new Random(12345L);
        while (dati.hasNext()) {
            dati.next();
            for (int i = 0; i < nt; ++i) {
                trc[i] = r.nextFloat();
            }
            da.putTrace(trc, pos);
        }
        double arraySize = 3.814697265625E-6;
        for (int i = 0; i < shape.length; ++i) {
            arraySize *= (double)shape[i];
        }
        double startTime = JPerfTestFftNd.getTime();
        fnd.forward(da);
        fnd.inverse(da);
        da.reshape(shape);
        double elapsedTime = JPerfTestFftNd.getTime() - startTime;
        if (pc.rank() == 0) {
            this.logInfo(fftDimensions + "D FFT Forward/Inverse : size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(shape));
        }
        if (pc.rank() == 0) {
            this.logFine("\nAfter FFT round trip");
        }
        if (this._doChecks) {
            dati.reset();
            r.setSeed(12345L);
            while (dati.hasNext()) {
                dati.next();
                da.getTrace(trc, pos);
                for (int i = 0; i < nt; ++i) {
                    float f1 = trc[i];
                    float f2 = r.nextFloat();
                    if (!(Math.abs(f1 - f2) > 1.0E-6f)) continue;
                    throw new IllegalStateException(Arrays.toString(pos) + " " + f1 + " " + f2 + " " + 1.0E-6f);
                }
            }
        }
    }

    private static double getTime() {
        return 1.0E-9 * (double)System.nanoTime();
    }

    private void logInfo(String message) {
        if (!this.isLoggable(Level.INFO)) {
            return;
        }
        System.out.println(message);
    }

    private void logFine(String message) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        System.out.println(message);
    }

    private void setLevel(Level level) {
        this._logLevel = level.intValue();
    }

    private boolean isLoggable(Level level) {
        return level.intValue() >= this._logLevel && this._logLevel != Level.OFF.intValue();
    }

    public static void main(String[] args) {
        Boolean memoryPrint = true;
        JPerfTestShapes.Size s = JPerfTestShapes.parseArgs(args, memoryPrint);
        List<int[]> shapes = JPerfTestShapes.getShapes(s, JPerfTestShapes.Dimensions.THREE);
        MemoryReporter memrp = null;
        if (memoryPrint.booleanValue()) {
            memrp = new MemoryReporter();
        }
        JPerfTestFftNd tester = new JPerfTestFftNd(Level.INFO, false);
        MPIContext pc = new MPIContext();
        pc.init(args);
        if (pc.rank() == 0) {
            tester.logInfo("Org with JTK FFT ");
        }
        if (pc.rank() == 0) {
            tester.logInfo("parallel size : " + pc.size());
        }
        float[] pad = new float[]{0.0f, 0.0f, 0.0f};
        double startTime = JPerfTestFftNd.getTime();
        for (int i = 0; i < shapes.size(); ++i) {
            if (memoryPrint.booleanValue() && pc.rank() == 0) {
                tester.logInfo("Start memory for 3D: " + memrp.getMemoryUsage());
            }
            tester.fftHarness(3, shapes.get(i), pad, pc);
            if (memoryPrint.booleanValue() && pc.rank() == 0) {
                tester.logInfo("Memory report for 3D: " + memrp.getMemoryUsage());
            }
            if (!memoryPrint.booleanValue() || pc.rank() != 0) continue;
            memrp.reset();
        }
        if (pc.rank() == 0) {
            tester.logInfo("Total time for 3D : " + (JPerfTestFftNd.getTime() - startTime) + " sec");
        }
    }
}

