/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta.test;

import edu.mines.jtk.util.CleanHandler;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.javaseis.array.TransposeType;
import org.javaseis.array.beta.FlexArray;
import org.javaseis.array.beta.test.JTestFlexArray2D;
import org.junit.Test;

public class JTestFlexArrayObjects {
    private static final Logger LOG = Logger.getLogger(JTestFlexArrayObjects.class.getName());

    @Test
    public void testGetTraceIO() {
        int[] shape = new int[]{11, 5};
        FlexArray aa = new FlexArray(Integer[].class, 1, shape);
        JTestFlexArray2D.modifyTraceValue(aa);
        JTestFlexArray2D.validateData(aa);
    }

    @Test
    public void testReshape0() {
        int[] shape = new int[]{11, 5};
        int[] shape2 = new int[]{3, 5};
        FlexArray aa = new FlexArray(Integer[].class, 1, shape);
        JTestFlexArray2D.modifyTraceValue(aa);
        JTestFlexArray2D.validateData(aa);
        aa.reshape(shape2);
        Assert.assertEquals((int)shape2[0], (int)aa.getShape()[0]);
        Assert.assertEquals((int)shape2[1], (int)aa.getShape()[1]);
        JTestFlexArray2D.validateData(aa);
    }

    @Test
    public void testT21() {
        int[] shape = new int[]{11, 5};
        FlexArray aa = new FlexArray(Integer[].class, 1, shape);
        JTestFlexArray2D.modifyTraceValue(aa);
        JTestFlexArray2D.validateData(aa);
        aa.transpose(TransposeType.T21);
        JTestFlexArray2D.validateData(aa);
    }

    @Test
    public void testTCopyConstructor() {
        int[] shape = new int[]{11, 5};
        int[] shape2 = new int[]{1, 5};
        FlexArray aa = new FlexArray(Integer[].class, 1, shape);
        JTestFlexArray2D.modifyTraceValue(aa);
        JTestFlexArray2D.validateData(aa);
        FlexArray bb = new FlexArray(aa);
        JTestFlexArray2D.modifyTraceValue(bb);
        bb.reshape(shape2);
        JTestFlexArray2D.validateData(bb);
        Assert.assertEquals((int)shape[0], (int)aa.getShape()[0]);
        Assert.assertEquals((int)shape[1], (int)aa.getShape()[1]);
        Assert.assertEquals((int)shape2[0], (int)bb.getShape()[0]);
        Assert.assertEquals((int)shape2[1], (int)bb.getShape()[1]);
    }

    static {
        CleanHandler.setDefaultHandler();
    }
}

