/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.logging.Logger;
import org.javaseis.array.BackingArray;
import org.javaseis.array.IBackingArray;
import org.javaseis.util.ArrayUtil;

public final class LongArrayStorage
implements IBackingArray,
Externalizable {
    private static final Logger LOG = Logger.getLogger(LongArrayStorage.class.getName());
    public static boolean TEST_MODE = false;
    private int _n1;
    private int _n2;
    private int _nLast;
    private long _length = 1L;
    private long _bufLength = 1L;
    private long _offset = 0L;
    private Class<?> _classType = Float.TYPE;
    private Object[][] _objects = null;
    private byte[][] _bytes = null;
    private short[][] _shorts = null;
    private int[][] _ints = null;
    private long[][] _longs = null;
    private float[][] _floats = null;
    private double[][] _doubles = null;

    public LongArrayStorage() {
        this._classType = null;
        this._length = 0L;
        this._bufLength = 0L;
        this._offset = 0L;
    }

    public LongArrayStorage(Class<?> classType, long length) {
        this.init(classType, length);
    }

    private void init(Class<?> classType, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        this._classType = classType;
        this._length = length;
        this._bufLength = length;
        this._offset = 0L;
        LOG.fine("classType=" + classType + " length = " + length + " buflength = " + length + " offset=" + this._offset);
        long maxElementCount = Integer.MAX_VALUE;
        if (TEST_MODE) {
            while (maxElementCount >= Integer.MAX_VALUE) {
                maxElementCount = (int)(length / 16L);
            }
            if (maxElementCount < 1L) {
                maxElementCount = 1L;
            }
            LOG.fine("LongArrayStorage is using allocation method intended for testing");
            LOG.fine("Maximum individual arary length = " + maxElementCount);
        }
        if (this._bufLength <= maxElementCount) {
            this._n1 = (int)this._bufLength;
            this._n2 = 1;
            this._nLast = this._n1;
        } else {
            this._n1 = (int)maxElementCount;
            this._n2 = (int)(this._bufLength / (long)this._n1);
            this._nLast = (int)(this._bufLength - (long)(this._n1 * this._n2));
            if ((long)(this._n1 * this._n2) == this._bufLength) {
                this._nLast = this._n1;
            } else {
                ++this._n2;
            }
        }
        LOG.fine("n1 = " + this._n1 + " n2 = " + this._n2 + " nLast=" + this._nLast);
        this.allocate();
    }

    public LongArrayStorage(Class<?> classType, int n1, int n2) {
        this._classType = classType;
        this._n1 = n1;
        this._n2 = n2;
        this._nLast = this._n1;
        this._bufLength = this._length = (long)this._n1 * (long)this._n2;
        this._offset = 0L;
        this.allocate();
    }

    @Override
    public IBackingArray view(long length, long offset) {
        return LongArrayStorage.view(this, length, offset);
    }

    public static IBackingArray view(LongArrayStorage a, long length, long offset) {
        LOG.fine("LongArrayStorage.view length = " + length + " offset = " + offset);
        if (length > a.getLength() - offset) {
            throw new IndexOutOfBoundsException("Requested offset and length exceed Backing Storage length");
        }
        LongArrayStorage b = new LongArrayStorage();
        b.setBackingArray(a.getBackingArray(), a.getClassType());
        b._n1 = a._n1;
        b._n2 = a._n2;
        b._nLast = a._nLast;
        b.setBufferView(offset, length);
        return b;
    }

    @Override
    public Class<?> getClassType() {
        return this._classType;
    }

    @Override
    public void setClassType(Class classType) {
        this._classType = classType;
    }

    @Override
    public long getLength() {
        return this._length;
    }

    @Override
    public void setLength(long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (length > this._bufLength - this._offset) {
            throw new IndexOutOfBoundsException("Requested length exceeds Backing Storage length");
        }
        this._length = (int)length;
    }

    @Override
    public long getOffset() {
        return this._offset;
    }

    @Override
    public void setOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (this._length + offset > this._bufLength) {
            throw new IndexOutOfBoundsException("Requested offset exceeds Backing Storage length");
        }
        this._offset = (int)offset;
    }

    @Override
    public void setBufferView(long offset, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (offset + length > this._bufLength) {
            throw new IndexOutOfBoundsException("Requested offset and length exceeds Backing Storage length");
        }
        this._offset = (int)offset;
        this._length = (int)length;
    }

    public void setBackingArray(Object buf, Class<?> type) {
        if (type.equals(Byte.TYPE)) {
            this.setBackingArray((byte[][])buf);
        } else if (type.equals(Short.TYPE)) {
            this.setBackingArray((short[][])buf);
        } else if (type.equals(Integer.TYPE)) {
            this.setBackingArray((int[][])buf);
        } else if (type.equals(Float.TYPE)) {
            this.setBackingArray((float[][])buf);
        } else if (type.equals(Long.TYPE)) {
            this.setBackingArray((long[][])buf);
        } else if (type.equals(Double.TYPE)) {
            this.setBackingArray((double[][])buf);
        } else {
            this.setBackingArray((Object[][])buf);
        }
    }

    private void setBackingArray(byte[][] buf) {
        this._classType = Byte.TYPE;
        this._bytes = buf;
        this._bufLength = 0L;
        for (byte[] element : buf) {
            this._bufLength += (long)element.length;
        }
    }

    private void setBackingArray(short[][] buf) {
        this._classType = Short.TYPE;
        this._shorts = buf;
        this._bufLength = 0L;
        for (short[] element : buf) {
            this._bufLength += (long)element.length;
        }
    }

    private void setBackingArray(int[][] buf) {
        this._classType = Integer.TYPE;
        this._ints = buf;
        this._bufLength = 0L;
        for (int[] element : buf) {
            this._bufLength += (long)element.length;
        }
    }

    private void setBackingArray(long[][] buf) {
        this._longs = buf;
        this._bufLength = 0L;
        for (long[] element : buf) {
            this._bufLength += (long)element.length;
        }
    }

    private void setBackingArray(float[][] buf) {
        this._classType = Float.TYPE;
        this._floats = buf;
        this._bufLength = 0L;
        for (float[] element : buf) {
            this._bufLength += (long)element.length;
        }
    }

    private void setBackingArray(double[][] buf) {
        this._classType = Double.TYPE;
        this._doubles = buf;
        this._bufLength = 0L;
        for (double[] element : buf) {
            this._bufLength += (long)element.length;
        }
    }

    private void setBackingArray(Object[][] buf) {
        this._classType = buf.getClass();
        this._objects = buf;
        this._bufLength = 0L;
        for (Object[] element : buf) {
            this._bufLength += (long)element.length;
        }
    }

    public Object getBackingArray() {
        Object result = this.getClassType().equals(Byte.TYPE) ? this._bytes : (this.getClassType().equals(Short.TYPE) ? (Object)this._shorts : (this.getClassType().equals(Integer.TYPE) ? (Object)this._ints : (this.getClassType().equals(Float.TYPE) ? (Object)this._floats : (this.getClassType().equals(Long.TYPE) ? (Object)this._longs : (this.getClassType().equals(Double.TYPE) ? (Object)this._doubles : (Object)this._objects)))));
        return result;
    }

    @Override
    public long getBackingArrayLength() {
        long result = 0L;
        if (this.getClassType().equals(Byte.TYPE)) {
            for (byte[] element : this._bytes) {
                result += (long)element.length;
            }
        } else if (this.getClassType().equals(Short.TYPE)) {
            for (short[] element : this._shorts) {
                result += (long)element.length;
            }
        } else if (this.getClassType().equals(Integer.TYPE)) {
            for (int[] element : this._ints) {
                result += (long)element.length;
            }
        } else if (this.getClassType().equals(Float.TYPE)) {
            for (float[] element : this._floats) {
                result += (long)element.length;
            }
        } else if (this.getClassType().equals(Long.TYPE)) {
            for (long[] element : this._longs) {
                result += (long)element.length;
            }
        } else if (this.getClassType().equals(Double.TYPE)) {
            for (double[] element : this._doubles) {
                result += (long)element.length;
            }
        } else {
            for (int i = 0; i < this._bytes.length; ++i) {
                result += (long)this._objects[i].length;
            }
        }
        return result;
    }

    @Override
    public void arraycopy(IBackingArray src, long srcOffset, IBackingArray dest, long destOffset, long count) {
        if (srcOffset < 0L) {
            throw new IllegalArgumentException("srcOffset is not valid " + srcOffset);
        }
        if (destOffset < 0L) {
            throw new IllegalArgumentException("destOffset is not valid " + destOffset);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count is not valid " + count);
        }
        int blockSize = 8192;
        long blocks = count / (long)blockSize;
        long remainder = count - blocks * (long)blockSize;
        Class classType = src.getClassType();
        if (classType != dest.getClassType()) {
            throw new RuntimeException("Class Type Mismatch");
        }
        if (classType == Byte.TYPE) {
            byte[] tmpStorage = new byte[blockSize];
            for (long i = 0L; i < blocks; ++i) {
                long index = i * (long)blockSize;
                src.getArray(tmpStorage, 0, blockSize, srcOffset + index);
                dest.putArray(tmpStorage, 0, blockSize, destOffset + index);
            }
            src.getArray(tmpStorage, 0, (int)remainder, count - remainder + srcOffset);
            dest.putArray(tmpStorage, 0, (int)remainder, count - remainder + destOffset);
        } else if (classType == Integer.TYPE) {
            for (long index = 0L; index < count; ++index) {
                int v = src.getInt(srcOffset + index);
                dest.putInt(v, destOffset + index);
            }
        } else if (classType == Long.TYPE) {
            for (long index = 0L; index < count; ++index) {
                long v = src.getLong(srcOffset + index);
                dest.putLong(v, destOffset + index);
            }
        } else if (classType == Short.TYPE) {
            for (long index = 0L; index < count; ++index) {
                short v = src.getShort(srcOffset + index);
                dest.putShort(v, destOffset + index);
            }
        } else if (classType == Float.TYPE) {
            for (long index = 0L; index < count; ++index) {
                float v = src.getFloat(srcOffset + index);
                dest.putFloat(v, destOffset + index);
            }
        } else if (classType == Double.TYPE) {
            for (long index = 0L; index < count; ++index) {
                double v = src.getDouble(srcOffset + index);
                dest.putDouble(v, destOffset + index);
            }
        } else {
            for (long index = 0L; index < count; ++index) {
                Object v = src.getObject(srcOffset + index);
                dest.putObject(v, destOffset + index);
            }
        }
    }

    @Override
    public void allocate() {
        if (this._classType == Byte.TYPE) {
            this._bytes = new byte[this._n2][];
            for (int j = 0; j < this._n2 - 1; ++j) {
                this._bytes[j] = new byte[this._n1];
            }
            this._bytes[this._n2 - 1] = new byte[this._nLast];
        } else if (this._classType == Short.TYPE) {
            this._shorts = new short[this._n2][];
            for (int j = 0; j < this._n2 - 1; ++j) {
                this._shorts[j] = new short[this._n1];
            }
            this._shorts[this._n2 - 1] = new short[this._nLast];
        } else if (this._classType == Integer.TYPE) {
            this._ints = new int[this._n2][];
            for (int j = 0; j < this._n2 - 1; ++j) {
                this._ints[j] = new int[this._n1];
            }
            this._ints[this._n2 - 1] = new int[this._nLast];
        } else if (this._classType == Long.TYPE) {
            this._longs = new long[this._n2][];
            for (int j = 0; j < this._n2 - 1; ++j) {
                this._longs[j] = new long[this._n1];
            }
            this._longs[this._n2 - 1] = new long[this._nLast];
        } else if (this._classType == Float.TYPE) {
            this._floats = new float[this._n2][];
            for (int j = 0; j < this._n2 - 1; ++j) {
                this._floats[j] = new float[this._n1];
            }
            this._floats[this._n2 - 1] = new float[this._nLast];
        } else if (this._classType == Double.TYPE) {
            this._doubles = new double[this._n2][];
            for (int j = 0; j < this._n2 - 1; ++j) {
                this._doubles[j] = new double[this._n1];
            }
            this._doubles[this._n2 - 1] = new double[this._nLast];
        } else {
            throw new RuntimeException("Object array allocation is not supported");
        }
    }

    @Override
    public <T> void getArray(T[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(this._objects[jRow], iCol, buf, offset, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void getArray(byte[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(this._bytes[jRow], iCol, buf, offset, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void getArray(short[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(this._shorts[jRow], iCol, buf, offset, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void getArray(int[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(this._ints[jRow], iCol, buf, offset, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void getArray(long[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(this._longs[jRow], iCol, buf, offset, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void getArray(float[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(this._floats[jRow], iCol, buf, offset, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void getArray(double[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(this._doubles[jRow], iCol, buf, offset, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public byte getByte(long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        return this._bytes[j][i];
    }

    @Override
    public double getDouble(long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        return this._doubles[j][i];
    }

    @Override
    public float getFloat(long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        return this._floats[j][i];
    }

    @Override
    public int getInt(long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        return this._ints[j][i];
    }

    @Override
    public long getLong(long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        return this._longs[j][i];
    }

    @Override
    public <T> T getObject(long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        return (T)this._objects[j][i];
    }

    @Override
    public short getShort(long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        return this._shorts[j][i];
    }

    @Override
    public <T> void putArray(T[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(buf, offset, this._objects[jRow], iCol, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void putArray(byte[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(buf, offset, this._bytes[jRow], iCol, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void putArray(short[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(buf, offset, this._shorts[jRow], iCol, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void putArray(int[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(buf, offset, this._ints[jRow], iCol, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void putArray(long[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(buf, offset, this._longs[jRow], iCol, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void putArray(float[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(buf, offset, this._floats[jRow], iCol, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void putArray(double[] buf, int offset, int length, long index) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset is invalid " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is invalid " + length);
        }
        if (index < 0L) {
            throw new IllegalArgumentException("index is invalid " + index);
        }
        int endOffset = offset + length;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < endOffset) {
            nCopy = this._n1 - iCol;
            if (nCopy > length - nTotal) {
                nCopy = length - nTotal;
            }
            ArrayUtil.arraycopy(buf, offset, this._doubles[jRow], iCol, nCopy);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void putByte(byte buf, long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        this._bytes[j][i] = buf;
    }

    @Override
    public void putDouble(double buf, long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        this._doubles[j][i] = buf;
    }

    @Override
    public void putFloat(float buf, long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        this._floats[j][i] = buf;
    }

    @Override
    public void putInt(int buf, long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        this._ints[j][i] = buf;
    }

    @Override
    public void putLong(long buf, long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        this._longs[j][i] = buf;
    }

    @Override
    public <T> void putObject(T buf, long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        this._objects[j][i] = buf;
    }

    @Override
    public void putShort(short buf, long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        long li = index + this._offset;
        int j = (int)(li / (long)this._n1);
        int i = (int)(li % (long)this._n1);
        this._shorts[j][i] = buf;
    }

    @Override
    public <T> void fill(T value, long index, long stride, long count) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        if (stride < 0L) {
            throw new IllegalArgumentException("stride is not valid " + stride);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count is not valid " + count);
        }
        long offset = 0L;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < count) {
            nCopy = this._n1 - iCol;
            if ((long)nCopy > count - (long)nTotal) {
                nCopy = (int)(count - (long)nTotal);
            }
            Arrays.fill(this._objects[jRow], iCol, iCol + nCopy, value);
            nTotal += nCopy;
            offset += (long)nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void fill(byte value, long index, long stride, long count) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        if (stride < 0L) {
            throw new IllegalArgumentException("stride is not valid " + stride);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count is not valid " + count);
        }
        if (this._classType != Byte.TYPE) {
            throw new IllegalArgumentException("IBackingArray class type is not byte.class");
        }
        long offset = 0L;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        long nCopy = 0L;
        long nTotal = 0L;
        while (offset < count) {
            nCopy = this._n1 - iCol;
            if (nCopy > count - nTotal) {
                nCopy = count - nTotal;
            }
            Arrays.fill(this._bytes[jRow], iCol, iCol + (int)nCopy, value);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void fill(short value, long index, long stride, long count) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        if (stride < 0L) {
            throw new IllegalArgumentException("stride is not valid " + stride);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count is not valid " + count);
        }
        if (this._classType != Short.TYPE) {
            throw new IllegalArgumentException("IBackingArray class type is not short.class");
        }
        long offset = 0L;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        long nCopy = 0L;
        long nTotal = 0L;
        while (offset < count) {
            nCopy = this._n1 - iCol;
            if (nCopy > count - nTotal) {
                nCopy = count - nTotal;
            }
            Arrays.fill(this._shorts[jRow], iCol, iCol + (int)nCopy, value);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void fill(int value, long index, long stride, long count) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        if (stride < 0L) {
            throw new IllegalArgumentException("stride is not valid " + stride);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count is not valid " + count);
        }
        if (this._classType != Integer.TYPE) {
            throw new IllegalArgumentException("IBackingArray class type is not int.class");
        }
        long offset = 0L;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        long nCopy = 0L;
        long nTotal = 0L;
        while (offset < count) {
            nCopy = this._n1 - iCol;
            if (nCopy > count - nTotal) {
                nCopy = count - nTotal;
            }
            Arrays.fill(this._ints[jRow], iCol, iCol + (int)nCopy, value);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void fill(long value, long index, long stride, long count) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        if (stride < 0L) {
            throw new IllegalArgumentException("stride is not valid " + stride);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count is not valid " + count);
        }
        if (this._classType != Long.TYPE) {
            throw new IllegalArgumentException("IBackingArray class type is not long.class");
        }
        long offset = 0L;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < count) {
            nCopy = this._n1 - iCol;
            if ((long)nCopy > count - (long)nTotal) {
                nCopy = (int)(count - (long)nTotal);
            }
            Arrays.fill(this._longs[jRow], iCol, iCol + nCopy, value);
            nTotal += nCopy;
            offset += (long)nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void fill(float value, long index, long stride, long count) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        if (stride < 0L) {
            throw new IllegalArgumentException("stride is not valid " + stride);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count is not valid " + count);
        }
        if (this._classType != Float.TYPE) {
            throw new IllegalArgumentException("IBackingArray class type is not float.class");
        }
        long offset = 0L;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        long nCopy = 0L;
        long nTotal = 0L;
        while (offset < count) {
            nCopy = this._n1 - iCol;
            if (nCopy > count - nTotal) {
                nCopy = count - nTotal;
            }
            Arrays.fill(this._floats[jRow], iCol, iCol + (int)nCopy, value);
            nTotal += nCopy;
            offset += nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public void fill(double value, long index, long stride, long count) {
        if (index < 0L) {
            throw new IllegalArgumentException("index is not valid " + index);
        }
        if (stride < 0L) {
            throw new IllegalArgumentException("stride is not valid " + stride);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count is not valid " + count);
        }
        if (this._classType != Double.TYPE) {
            throw new IllegalArgumentException("IBackingArray class type is not double.class");
        }
        long offset = 0L;
        int jRow = (int)(index / (long)this._n1);
        int iCol = (int)(index % (long)this._n1);
        int nCopy = 0;
        int nTotal = 0;
        while (offset < count) {
            nCopy = this._n1 - iCol;
            if ((long)nCopy > count - (long)nTotal) {
                nCopy = (int)(count - (long)nTotal);
            }
            Arrays.fill(this._doubles[jRow], iCol, iCol + nCopy, value);
            nTotal += nCopy;
            offset += (long)nCopy;
            ++jRow;
            iCol = 0;
        }
    }

    @Override
    public BackingArray.Type getBackingArrayType() {
        return BackingArray.Type.JAVA_LONG_ARRAY;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this._classType.getCanonicalName());
        out.writeLong(this._length);
        if (this._classType.equals(Byte.TYPE)) {
            for (long i = 0L; i < this._length; ++i) {
                out.writeByte(this.getByte(i));
            }
        } else if (this._classType.equals(Short.TYPE)) {
            for (long i = 0L; i < this._length; ++i) {
                out.writeShort(this.getShort(i));
            }
        } else if (this._classType.equals(Integer.TYPE)) {
            for (long i = 0L; i < this._length; ++i) {
                out.writeInt(this.getInt(i));
            }
        } else if (this._classType.equals(Float.TYPE)) {
            for (long i = 0L; i < this._length; ++i) {
                out.writeFloat(this.getFloat(i));
            }
        } else if (this._classType.equals(Long.TYPE)) {
            for (long i = 0L; i < this._length; ++i) {
                out.writeLong(this.getLong(i));
            }
        } else if (this._classType.equals(Double.TYPE)) {
            for (long i = 0L; i < this._length; ++i) {
                out.writeDouble(this.getDouble(i));
            }
        } else {
            throw new UnsupportedOperationException("class type " + this._classType + " is not supported");
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String className = in.readUTF();
        long length = in.readLong();
        if (className.equals("byte")) {
            this.init(Byte.TYPE, length);
            for (long i = 0L; i < length; ++i) {
                this.putByte(in.readByte(), i);
            }
        } else if (className.equals("short")) {
            this.init(Short.TYPE, length);
            for (long i = 0L; i < length; ++i) {
                this.putShort(in.readShort(), i);
            }
        } else if (className.equals("int")) {
            this.init(Integer.TYPE, length);
            for (long i = 0L; i < length; ++i) {
                this.putInt(in.readInt(), i);
            }
        } else if (className.equals("float")) {
            this.init(Float.TYPE, length);
            for (long i = 0L; i < length; ++i) {
                this.putFloat(in.readFloat(), i);
            }
        } else if (className.equals("long")) {
            this.init(Long.TYPE, length);
            for (long i = 0L; i < length; ++i) {
                this.putLong(in.readLong(), i);
            }
        } else if (className.equals("double")) {
            this.init(Double.TYPE, length);
            for (long i = 0L; i < length; ++i) {
                this.putDouble(in.readDouble(), i);
            }
        } else {
            throw new UnsupportedOperationException("class type " + className + " is not supported");
        }
    }
}

