/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.FlexlmLicenseElementException;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.lictext.LicenseCertificate;
import com.macrovision.flexlm.lictext.LicenseElement;
import com.macrovision.flexlm.lictext.TokenizedLicenseLine;
import java.util.Hashtable;
import java.util.Vector;

public class VendorLine
extends LicenseElement
implements FlexlmConstants {
    private static final String[] vendorKeywords = new String[]{"options", "opt", "port"};
    private String name;
    private String vendorName;
    private String path;
    private String optionsFile;
    private int port;
    private int lmgrdPort;

    public VendorLine(TokenizedLicenseLine tokenizedLicenseLine, LicenseCertificate licenseCertificate, VendorInfo vendorInfo) throws FlexlmLicenseElementException {
        this.lineText = tokenizedLicenseLine.getLineText();
        this.rawLineText = tokenizedLicenseLine.getRawLineText();
        tokenizedLicenseLine.findPositionalsAndKeywordValues(vendorKeywords);
        Vector vector = tokenizedLicenseLine.getPositionalParameters();
        Hashtable hashtable = tokenizedLicenseLine.getKeywordParameters();
        this.name = (String)vector.elementAt(0);
        if (vector.size() > 1) {
            this.vendorName = (String)vector.elementAt(1);
        }
        if (vector.size() > 2) {
            this.path = (String)vector.elementAt(2);
        }
        if (vector.size() > 3) {
            this.optionsFile = (String)vector.elementAt(3);
        }
        if (vector.size() > 4) {
            this.port = VendorLine.getPort(tokenizedLicenseLine, (String)vector.elementAt(4));
        }
        if (hashtable != null) {
            String string = VendorLine.getWithCaseInsensitiveKey(hashtable, "options");
            if (string != null) {
                this.optionsFile = string;
            }
            if ((string = VendorLine.getWithCaseInsensitiveKey(hashtable, "opt")) != null) {
                this.optionsFile = string;
            }
            if ((string = VendorLine.getWithCaseInsensitiveKey(hashtable, "port")) != null) {
                this.port = VendorLine.getPort(tokenizedLicenseLine, string);
            }
        }
        this.isDirty = false;
    }

    @Override
    public void authenticate() throws FlexlmException {
    }

    @Override
    public boolean isAuthentic() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVendorName() {
        return this.vendorName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.isDirty = true;
        this.path = string;
    }

    public String getOptionsFile() {
        return this.optionsFile;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.isDirty = true;
        this.port = n;
    }

    private static int getPort(TokenizedLicenseLine tokenizedLicenseLine, String string) throws FlexlmLicenseElementException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FlexlmLicenseElementException(-500, 4020, tokenizedLicenseLine.getFilename(), tokenizedLicenseLine.getLineNumber(), tokenizedLicenseLine.getLineText(), null);
        }
        return n;
    }

    public void setLmgrdPort(int n) {
        this.lmgrdPort = n;
    }

    public int getLmgrdPort() {
        return this.lmgrdPort;
    }

    public String toString() {
        return this.getName() + " " + this.getVendorName() + " " + (this.getPath() == null ? "" : this.getPath() + " ") + (this.getOptionsFile() == null ? "" : "options=" + this.getOptionsFile() + " ") + (this.getPort() == 0 ? "" : "port=" + this.getPort() + " ");
    }
}

