/*
 * Decompiled with CFR 0.152.
 */
package javax.security.spec;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.util.Conversion;
import java.security.InvalidKeyException;
import java.security.spec.KeySpec;
import java.util.Arrays;

public class DESXKeySpec
implements Zeroizeable,
KeySpec {
    private byte[] a;
    private boolean b = false;

    public DESXKeySpec(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    public DESXKeySpec(byte[] byArray, int n2) throws InvalidKeyException {
        if (byArray == null) {
            throw new InvalidKeyException("Need key data");
        }
        if (byArray.length - n2 < 24) {
            throw new InvalidKeyException("DESX key too short");
        }
        this.a = new byte[24];
        System.arraycopy(byArray, n2, this.a, 0, 24);
    }

    public byte[] getKey() {
        byte[] byArray = new byte[24];
        System.arraycopy(this.a, 0, byArray, 0, 24);
        return byArray;
    }

    public boolean isZeroized() {
        return this.b;
    }

    public boolean testZeroizationState() {
        return this.b;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        Arrays.fill(this.a, (byte)0);
        this.b = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    public String toString() {
        return Conversion.OS2Hex(this.a, 2);
    }
}

