/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.datavolume;

import org.javaseis.grid.GridDefinition;

public class GridEvaluator {
    GridDefinition _grid_def = null;
    int _xindex = -1;
    int _yindex = -1;
    long _total;
    long[] _lengths = null;
    int[] _positions = null;
    long[] _log_positions = null;
    double[] _phys_positions = null;

    public void init(GridDefinition grid_def, int xindex, int yindex) {
        if (grid_def.equals(this._grid_def)) {
            return;
        }
        this._grid_def = grid_def;
        this._xindex = xindex;
        this._yindex = yindex;
        long[] lengths = this._grid_def.getAxisLengths();
        this._lengths = new long[this._grid_def.getNumDimensions() - 1];
        this._total = 1L;
        for (int k2 = 0; k2 < this._grid_def.getNumDimensions() - 1; ++k2) {
            this._lengths[k2] = lengths[k2 + 1];
            this._total *= lengths[k2 + 1];
        }
        this._positions = new int[this._grid_def.getNumDimensions() - 1];
        this._log_positions = new long[this._grid_def.getNumDimensions() - 1];
        this._phys_positions = new double[this._grid_def.getNumDimensions() - 1];
    }

    public int[] getPosition(long index) {
        int N = this._lengths.length;
        int k2 = 0;
        int k3 = N - 1;
        long Den = this._total;
        while (k2 < N) {
            this._positions[k3] = (int)(index / (Den /= this._lengths[k2]));
            index -= (long)this._positions[k3] * Den;
            ++k2;
            --k3;
        }
        return this._positions;
    }

    public long[] getLogicalPosition(long index) {
        this.getPosition(index);
        for (int k2 = 0; k2 < this._lengths.length; ++k2) {
            this._log_positions[k2] = this._grid_def.getAxisLogicalOrigin(k2 + 1) + (long)this._positions[k2] * this._grid_def.getAxisLogicalDelta(k2 + 1);
        }
        return this._log_positions;
    }

    public double[] getPhysicalPosition(long index) {
        this.getPosition(index);
        for (int k2 = 0; k2 < this._lengths.length; ++k2) {
            this._phys_positions[k2] = this._grid_def.getAxisPhysicalOrigin(k2 + 1) + (double)this._positions[k2] * this._grid_def.getAxisPhysicalDelta(k2 + 1);
        }
        return this._phys_positions;
    }

    public long getIndex(int[] positions) {
        int N = this._lengths.length;
        int k2 = 0;
        int k3 = N - 1;
        long Num = this._total;
        long index = 0L;
        while (k2 < N) {
            index += (Num /= this._lengths[k3]) * (long)positions[k2];
            ++k2;
            --k3;
        }
        return index;
    }

    public long getIndexFromLogicalPosition(long[] log_positions) {
        for (int k2 = 0; k2 < this._lengths.length; ++k2) {
            this._positions[k2] = (int)((log_positions[k2] - this._grid_def.getAxisLogicalOrigin(k2 + 1)) / this._grid_def.getAxisLogicalDelta(k2 + 1));
        }
        return this.getIndex(this._positions);
    }

    public long getIndexFromPhysicalPosition(double[] phys_positions) {
        for (int k2 = 0; k2 < this._lengths.length; ++k2) {
            this._positions[k2] = (int)((phys_positions[k2] - this._grid_def.getAxisPhysicalOrigin(k2 + 1)) / this._grid_def.getAxisPhysicalDelta(k2 + 1));
        }
        return this.getIndex(this._positions);
    }

    public int getXIndex() {
        return this._xindex;
    }

    public int getYIndex() {
        return this._yindex;
    }

    public long getXLength() {
        return this._lengths[this._xindex];
    }

    public long getYLength() {
        return this._lengths[this._yindex];
    }
}

