/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import java.io.File;
import junit.framework.TestCase;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.ExtentPolicyRandom;
import org.javaseis.io.Seisio;
import org.javaseis.io.VirtualFoldersSimple;
import org.javaseis.properties.DataDefinition;
import org.javaseis.properties.TraceProperties;
import org.javaseis.tests.TestUtil;
import org.javaseis.util.SeisException;

public class TestRenameVirtualDataset
extends TestCase {
    public void testRename() throws Exception {
        Seisio fileStruct = null;
        String path = System.getProperty("user.home") + File.separator + "jsTestDataset";
        boolean isJavaSeis = Seisio.isJavaSeis(path);
        System.out.println("isJavaSeis: " + isJavaSeis);
        if (isJavaSeis) {
            Seisio.delete(path);
            System.gc();
        }
        System.out.println("Seisio: Test of \"Non-virtual\" dataset...");
        fileStruct = TestUtil.getReferenceDataset(TestUtil.DSType.CMP);
        System.out.println("Seisio: Non-virtual dataset created");
        GridDefinition gd = fileStruct.getGridDefinition();
        DataDefinition dd = fileStruct.getDataDefinition();
        TraceProperties tp = fileStruct.getTraceProperties();
        fileStruct.close();
        fileStruct = null;
        System.gc();
        TestRenameVirtualDataset.assertTrue((boolean)Seisio.delete(path));
        int vfioExtentSize = 100;
        String[] vfioDirs = new String[4];
        String scratch = new String(System.getProperty("user.home") + File.separator + "scratch");
        File dir = new File(scratch);
        if (!dir.isDirectory() && !dir.mkdir()) {
            throw new SeisException("Could not create directory '" + scratch + "'");
        }
        for (int i = 0; i < vfioDirs.length; ++i) {
            vfioDirs[i] = new String(scratch + File.separator + i);
            dir = new File(vfioDirs[i]);
            if (dir.isDirectory() || dir.mkdir()) continue;
            throw new SeisException("Could not create directory '" + vfioDirs[i] + "'");
        }
        System.out.println("Seisio: Scratch space allocated.");
        String vpath = System.getProperty("user.home") + File.separator + "jsTestDatasetV";
        boolean v_isJavaSeis = Seisio.isJavaSeis(vpath);
        if (v_isJavaSeis) {
            Seisio.delete(vpath);
            System.gc();
        }
        Seisio vio = new Seisio(vpath, gd, dd, tp);
        vio.setMapped();
        vio.create(new VirtualFoldersSimple(vpath, vfioDirs, new ExtentPolicyRandom()), vfioExtentSize);
        vio.close();
        System.out.println("Seisio: Virtual dataset " + vpath + " created.");
        System.out.println("  Extent size: " + vfioExtentSize);
        for (String vDir : vfioDirs) {
            System.out.println("  secondary directories: " + vDir);
        }
        System.out.println("Seisio.isJavaSies(): " + Seisio.isJavaSeis(vpath));
        System.out.println("Seisio: open virtual dataset");
        vio = new Seisio(vpath);
        vio.open("rw");
        vio.close();
        System.gc();
        System.out.println("Seisio: rename the virtual dataset");
        String vpath2 = System.getProperty("user.home") + File.separator + "jsTestDatasetV-renamed";
        File f = new File(vpath);
        TestRenameVirtualDataset.assertTrue((boolean)f.renameTo(new File(vpath2)));
        System.out.println("Seisio: rename the secondary storage folders");
        for (int i = 0; i < vfioDirs.length; ++i) {
            File folder = new File(vfioDirs[i]);
            File new_folder = new File(vfioDirs[i] + "-renamed");
            TestRenameVirtualDataset.assertTrue((boolean)folder.renameTo(new_folder));
            vfioDirs[i] = vfioDirs[i] + "-renamed";
            dir = new File(vfioDirs[i]);
            if (dir.isDirectory()) continue;
            throw new SeisException("Directory doesn't exist '" + vfioDirs[i] + "'");
        }
        System.out.println("Seisio: open virtual dataset after it has been renamed but don't provide alt directories");
        try {
            vio = new Seisio(vpath2);
            vio.open("rw");
            System.out.println("Something went wrong because we were able to find all the part to a virtual DS after renaming???");
            TestRenameVirtualDataset.assertTrue((boolean)false);
        }
        catch (Exception e) {
            System.out.println("Seisio: Can't find all the parts of a virtual dataset without using the alternate directories");
        }
        System.out.println("Seisio: Attemping to open virtual dataset after it has been renamed AND using alt directories");
        vio = new Seisio(vpath2);
        vio.open("rw");
        vio.close();
        System.out.println("Seisio: Able to find all the parts to the virtual DS again");
        System.gc();
        v_isJavaSeis = Seisio.isJavaSeis(vpath2);
        if (v_isJavaSeis) {
            TestRenameVirtualDataset.assertTrue((boolean)Seisio.delete(vpath2));
            System.gc();
        }
        System.out.println("***   SUCCESS   ***");
    }
}

