/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.logging.Logger;
import org.javaseis.io.SortMapIO;

public class SortMapInfo {
    private static final Logger LOG = Logger.getLogger(SortMapInfo.class.getName());

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            throw new IllegalArgumentException("Provide path to dataset and sortmap name and operation.\nValid operations are --VolumeInfo, --FrameInfo, --traceInfo");
        }
        String path = args[0];
        String sortMapName = args[1];
        String op = args[2];
        SortMapIO smio = new SortMapIO(path, sortMapName);
        smio.open("r");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        LOG.info("Input volume,frame for details or hit enter to exit");
        while (null != (line = br.readLine())) {
            String vf = line.trim();
            String[] parts = vf.split(",");
            if (parts.length != 2) {
                LOG.warning("Provide a comma delimited volume,frame");
                continue;
            }
            String volume = parts[0].trim();
            String frame = parts[1].trim();
            int lvol = Integer.parseInt(volume);
            int lfrm = Integer.parseInt(frame);
            LOG.info("Finding volume index based on logical volume");
            int ivol = smio.findLogicalVolume(lvol);
            LOG.info("volume index = " + ivol + " for logical volume = " + lvol);
            int nframes = smio.setVolume(ivol);
            LOG.info("number of frames = " + nframes + " for volume = " + lvol);
            for (int i = 0; i < nframes; ++i) {
                int[] buf = new int[2];
                smio.getFrameDetails(i, buf);
                if (op.compareToIgnoreCase("--FrameInfo") != 0) continue;
                LOG.info("i=" + i + " Logical Frame, Traces in Frame = " + Arrays.toString(buf));
            }
            LOG.info("Looking up frame index for logical frame = " + lfrm);
            int ifrm = smio.findLogicalFrame(lfrm);
            LOG.info("frame index = " + ifrm + " for logical frame = " + lfrm);
            int trcCount = smio.setFrame(ifrm);
            if (op.compareToIgnoreCase("--traceInfo") == 0) {
                LOG.info("Trace count = " + trcCount + " for frame = " + lfrm);
            }
            long[] traceList = smio.getCurrentTraceList();
            LOG.info("Tracelist" + Arrays.toString(traceList));
            LOG.info("----------------------------------------------");
        }
        br.close();
    }
}

