/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta;

import edu.mines.jtk.util.ArrayMath;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.logging.Logger;
import org.javaseis.array.TransposeType;

public final class ArraysUtil {
    private static final Logger LOG = Logger.getLogger(ArraysUtil.class.getName());

    private ArraysUtil() {
    }

    public static int[][] tran21(int[][] in) {
        int samples = in[0].length;
        int traces = in.length;
        if (samples == traces) {
            ArraysUtil.trans21Square(in);
            return in;
        }
        if (traces > samples) {
            int cnt = traces / samples;
            if (cnt * samples != traces) {
                ++cnt;
            }
            int[][] a = ArraysUtil.setLength1(in, cnt * samples);
            ArraysUtil.tran21d(a);
            int[][] out = ArraysUtil.assembleArrays(a, traces);
            return out;
        }
        int cnt = samples / traces;
        if (cnt * traces != samples) {
            ++cnt;
        }
        int[][] a = ArraysUtil.splitArrays(in);
        ArraysUtil.tran21d(a);
        int[][] out = ArraysUtil.setLength1(a, samples);
        return out;
    }

    public static float[][] tran21(float[][] in) {
        int samples = in[0].length;
        int traces = in.length;
        if (samples == traces) {
            ArraysUtil.trans21Square(in);
            return in;
        }
        if (traces > samples) {
            int cnt = traces / samples;
            if (cnt * samples != traces) {
                ++cnt;
            }
            float[][] a = ArraysUtil.setLength1(in, cnt * samples);
            ArraysUtil.tran21d(a);
            float[][] out = ArraysUtil.assembleArrays(a, traces);
            return out;
        }
        int cnt = samples / traces;
        if (cnt * traces != samples) {
            ++cnt;
        }
        float[][] a = ArraysUtil.splitArrays(in);
        ArraysUtil.tran21d(a);
        float[][] out = ArraysUtil.setLength1(a, samples);
        return out;
    }

    public static void tran21d(int[][] in) {
        int m = in.length;
        int n = in[0].length;
        if (m < n) {
            throw new IllegalArgumentException("Width must be longer then length of array");
        }
        if (m % n != 0) {
            throw new IllegalArgumentException("Width must be a multiple of the length");
        }
        int iterations = m / n;
        for (int i = 0; i < iterations; ++i) {
            int[][] tmp = new int[n][];
            int offset = i * n;
            for (int j = 0; j < n; ++j) {
                tmp[j] = in[offset + j];
            }
            ArraysUtil.trans21Square(tmp);
        }
    }

    public static void tran21d(float[][] in) {
        int m = in.length;
        int n = in[0].length;
        if (m < n) {
            throw new IllegalArgumentException("Width must be longer then length of array");
        }
        if (m % n != 0) {
            throw new IllegalArgumentException("Width must be a multiple of the length");
        }
        int iterations = m / n;
        for (int i = 0; i < iterations; ++i) {
            float[][] tmp = new float[n][];
            int offset = i * n;
            for (int j = 0; j < n; ++j) {
                tmp[j] = in[offset + j];
            }
            ArraysUtil.trans21Square(tmp);
        }
    }

    public static void trans21Square(int[][] in) {
        int n = in.length;
        int m = in[0].length;
        if (n != m) {
            throw new IllegalArgumentException("Input array is not square");
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int temp = in[i][j];
                in[i][j] = in[j][i];
                in[j][i] = temp;
            }
        }
    }

    public static void trans21Square(float[][] in) {
        int n = in.length;
        int m = in[0].length;
        if (n != m) {
            throw new IllegalArgumentException("Input array is not square");
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                float temp = in[i][j];
                in[i][j] = in[j][i];
                in[j][i] = temp;
            }
        }
    }

    private static int[][] splitArrays(int[][] in) {
        int m = in.length;
        int n = in[0].length;
        if (m >= n) {
            throw new IllegalArgumentException("Array length must be greater than width");
        }
        int segments = n / m;
        if (m * segments != n) {
            ++segments;
        }
        int[][] out = new int[segments * m][];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < segments; ++j) {
                int[] trace = new int[m];
                int offsetW = i + j * m;
                int offsetL = j * m;
                int lenOut = Math.min(n - offsetL, m);
                System.arraycopy(in[i], offsetL, trace, 0, lenOut);
                out[offsetW] = trace;
            }
            in[i] = null;
        }
        return out;
    }

    private static float[][] splitArrays(float[][] in) {
        int m = in.length;
        int n = in[0].length;
        if (m >= n) {
            throw new IllegalArgumentException("Array length must be greater than width");
        }
        int segments = n / m;
        if (m * segments != n) {
            ++segments;
        }
        float[][] out = new float[segments * m][];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < segments; ++j) {
                float[] trace = new float[m];
                int offsetW = i + j * m;
                int offsetL = j * m;
                int lenOut = Math.min(n - offsetL, m);
                System.arraycopy(in[i], offsetL, trace, 0, lenOut);
                out[offsetW] = trace;
            }
            in[i] = null;
        }
        return out;
    }

    private static int[][] assembleArrays(int[][] in, int len0) {
        int m = in.length;
        int n = in[0].length;
        int[][] out = new int[n][];
        int segments = m / n;
        for (int i = 0; i < n; ++i) {
            int[] trace = new int[len0];
            for (int j = 0; j < segments; ++j) {
                int offsetW = i + j * n;
                int offsetL = j * n;
                int lenOut = Math.min(len0 - offsetL, n);
                System.arraycopy(in[offsetW], 0, trace, offsetL, lenOut);
                in[offsetW] = null;
            }
            out[i] = trace;
        }
        return out;
    }

    private static float[][] assembleArrays(float[][] in, int len0) {
        int m = in.length;
        int n = in[0].length;
        float[][] out = new float[n][];
        int segments = m / n;
        for (int i = 0; i < n; ++i) {
            float[] trace = new float[len0];
            for (int j = 0; j < segments; ++j) {
                int offsetW = i + j * n;
                int offsetL = j * n;
                int lenOut = Math.min(len0 - offsetL, n);
                System.arraycopy(in[offsetW], 0, trace, offsetL, lenOut);
                in[offsetW] = null;
            }
            out[i] = trace;
        }
        return out;
    }

    public static int[][] setLength1(int[][] in, int len1) {
        int i;
        int count = in.length;
        int samples = in[0].length;
        if (count == len1) {
            return in;
        }
        int[][] out = new int[len1][];
        int minLen = Math.min(count, len1);
        for (i = 0; i < minLen; ++i) {
            out[i] = in[i];
        }
        if (i < len1) {
            int[][] tmp = new int[len1 - i][samples];
            for (int j = i; j < len1; ++j) {
                out[j] = tmp[j - i];
            }
        }
        return out;
    }

    public static float[][] setLength1(float[][] in, int len1) {
        int i;
        int count = in.length;
        int samples = in[0].length;
        if (count == len1) {
            return in;
        }
        float[][] out = new float[len1][];
        int minLen = Math.min(count, len1);
        for (i = 0; i < minLen; ++i) {
            out[i] = in[i];
        }
        if (i < len1) {
            float[][] tmp = new float[len1 - i][samples];
            for (int j = i; j < len1; ++j) {
                out[j] = tmp[j - i];
            }
        }
        return out;
    }

    public static int[][][] setLength1(int[][][] in, int len1) {
        int[][][] out = new int[in.length][][];
        for (int i = 0; i < in.length; ++i) {
            out[i] = ArraysUtil.setLength1(in[i], len1);
        }
        return out;
    }

    public static float[][][] setLength1(float[][][] in, int len1) {
        float[][][] out = new float[in.length][][];
        for (int i = 0; i < in.length; ++i) {
            out[i] = ArraysUtil.setLength1(in[i], len1);
        }
        return out;
    }

    public static Object setLength1(Object in, int len1) {
        if (in instanceof int[][]) {
            int[][] out = ArraysUtil.setLength1((int[][])in, len1);
            return out;
        }
        if (in instanceof int[][][]) {
            int[][][] out = ArraysUtil.setLength1((int[][][])in, len1);
            return out;
        }
        if (in instanceof float[][]) {
            float[][] out = ArraysUtil.setLength1((float[][])in, len1);
            return out;
        }
        if (in instanceof float[][][]) {
            float[][][] out = ArraysUtil.setLength1((float[][][])in, len1);
            return out;
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static int getDiminsions(Object a) {
        int dim = 0;
        if (!a.getClass().isArray()) {
            return 0;
        }
        char[] name = a.getClass().getName().toCharArray();
        int i = 0;
        while (name[i++] == '[') {
            ++dim;
        }
        return dim;
    }

    public static int getDimensions(Object a) {
        int dim = 0;
        if (!a.getClass().isArray()) {
            return 0;
        }
        char[] name = a.getClass().getName().toCharArray();
        int i = 0;
        while (name[i++] == '[') {
            ++dim;
        }
        return dim;
    }

    public static int[] getShape(Object a) {
        int dim = ArraysUtil.getDimensions(a);
        if (dim == 0) {
            return new int[0];
        }
        int[] shape = new int[dim];
        Object axis = a;
        for (int j = 0; j < shape.length; ++j) {
            shape[j] = Array.getLength(axis);
            if (shape[j] == 0) break;
            axis = Array.get(axis, 0);
        }
        return ArrayMath.reverse((int[])shape);
    }

    public static Object getTrace(Object a, int[] pos) {
        Object ret = a;
        for (int i = pos.length - 1; i > 0; --i) {
            ret = Array.get(ret, pos[i]);
        }
        return ret;
    }

    public static Class<?> getElementClass(Object a) {
        Class<?> cls = a.getClass();
        Class<?> elementClass = cls.getComponentType();
        while (elementClass != null) {
            cls = elementClass;
            elementClass = cls.getComponentType();
        }
        return cls;
    }

    public static void fill(Object in, Number value) {
        if (in instanceof int[]) {
            ArrayMath.fill((int)value.intValue(), (int[])((int[])in));
        } else if (in instanceof int[][]) {
            ArrayMath.fill((int)value.intValue(), (int[][])((int[][])in));
        } else if (in instanceof int[][][]) {
            ArrayMath.fill((int)value.intValue(), (int[][][])((int[][][])in));
        } else if (in instanceof float[]) {
            ArrayMath.fill((float)value.floatValue(), (float[])((float[])in));
        } else if (in instanceof float[][]) {
            ArrayMath.fill((float)value.floatValue(), (float[][])((float[][])in));
        } else if (in instanceof float[][][]) {
            ArrayMath.fill((float)value.floatValue(), (float[][][])((float[][][])in));
        } else if (in instanceof short[]) {
            ArrayMath.fill((short)value.shortValue(), (short[])((short[])in));
        } else if (in instanceof short[][]) {
            ArrayMath.fill((short)value.shortValue(), (short[][])((short[][])in));
        } else if (in instanceof short[][][]) {
            ArrayMath.fill((short)value.shortValue(), (short[][][])((short[][][])in));
        } else if (in instanceof long[]) {
            ArrayMath.fill((long)value.longValue(), (long[])((long[])in));
        } else if (in instanceof long[][]) {
            ArrayMath.fill((long)value.longValue(), (long[][])((long[][])in));
        } else if (in instanceof long[][][]) {
            ArrayMath.fill((long)value.longValue(), (long[][][])((long[][][])in));
        } else if (in instanceof double[]) {
            ArrayMath.fill((double)value.doubleValue(), (double[])((double[])in));
        } else if (in instanceof double[][]) {
            ArrayMath.fill((double)value.doubleValue(), (double[][])((double[][])in));
        } else if (in instanceof double[][][]) {
            ArrayMath.fill((double)value.doubleValue(), (double[][][])((double[][][])in));
        } else if (in instanceof byte[]) {
            ArrayMath.fill((byte)value.byteValue(), (byte[])((byte[])in));
        } else if (in instanceof byte[][]) {
            ArrayMath.fill((byte)value.byteValue(), (byte[][])((byte[][])in));
        } else if (in instanceof byte[][][]) {
            ArrayMath.fill((byte)value.byteValue(), (byte[][][])((byte[][][])in));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static int[][] combineTraces(int elementCount, int[][] in) {
        if (elementCount == 1) {
            return in;
        }
        if (in.length % elementCount != 0) {
            throw new IllegalArgumentException("Length of traces (" + in.length + ") must be evenly divisible by elementCount (" + elementCount + ")!");
        }
        int[] newLengths = new int[]{in[0].length * elementCount, in.length / elementCount};
        int[][] out = new int[newLengths[1]][newLengths[0]];
        for (int i = 0; i < out.length; ++i) {
            int iIn = i * elementCount;
            for (int jIn = 0; jIn < in[0].length; ++jIn) {
                int j = jIn * elementCount;
                for (int k = 0; k < elementCount; ++k) {
                    out[i][j + k] = in[iIn + k][jIn];
                }
            }
        }
        return out;
    }

    public static float[][] combineTraces(int elementCount, float[][] in) {
        if (elementCount == 1) {
            return in;
        }
        if (in.length % elementCount != 0) {
            throw new IllegalArgumentException("Length of traces (" + in.length + ") must be evenly divisible by elementCount (" + elementCount + ")!");
        }
        int[] newLengths = new int[]{in[0].length * elementCount, in.length / elementCount};
        float[][] out = new float[newLengths[1]][newLengths[0]];
        for (int i = 0; i < out.length; ++i) {
            int iIn = i * elementCount;
            for (int jIn = 0; jIn < in[0].length; ++jIn) {
                int j = jIn * elementCount;
                for (int k = 0; k < elementCount; ++k) {
                    out[i][j + k] = in[iIn + k][jIn];
                }
            }
        }
        return out;
    }

    public static double[][] combineTraces(int elementCount, double[][] in) {
        if (elementCount == 1) {
            return in;
        }
        if (in.length % elementCount != 0) {
            throw new IllegalArgumentException("Length of traces (" + in.length + ") must be evenly divisible by elementCount (" + elementCount + ")!");
        }
        int[] newLengths = new int[]{in[0].length * elementCount, in.length / elementCount};
        double[][] out = new double[newLengths[1]][newLengths[0]];
        for (int i = 0; i < out.length; ++i) {
            int iIn = i * elementCount;
            for (int jIn = 0; jIn < in[0].length; ++jIn) {
                int j = jIn * elementCount;
                for (int k = 0; k < elementCount; ++k) {
                    out[i][j + k] = in[iIn + k][jIn];
                }
            }
        }
        return out;
    }

    public static short[][] combineTraces(int elementCount, short[][] in) {
        if (elementCount == 1) {
            return in;
        }
        if (in.length % elementCount != 0) {
            throw new IllegalArgumentException("Length of traces (" + in.length + ") must be evenly divisible by elementCount (" + elementCount + ")!");
        }
        int[] newLengths = new int[]{in[0].length * elementCount, in.length / elementCount};
        short[][] out = new short[newLengths[1]][newLengths[0]];
        for (int i = 0; i < out.length; ++i) {
            int iIn = i * elementCount;
            for (int jIn = 0; jIn < in[0].length; ++jIn) {
                int j = jIn * elementCount;
                for (int k = 0; k < elementCount; ++k) {
                    out[i][j + k] = in[iIn + k][jIn];
                }
            }
        }
        return out;
    }

    public static long[][] combineTraces(int elementCount, long[][] in) {
        if (elementCount == 1) {
            return in;
        }
        if (in.length % elementCount != 0) {
            throw new IllegalArgumentException("Length of traces (" + in.length + ") must be evenly divisible by elementCount (" + elementCount + ")!");
        }
        int[] newLengths = new int[]{in[0].length * elementCount, in.length / elementCount};
        long[][] out = new long[newLengths[1]][newLengths[0]];
        for (int i = 0; i < out.length; ++i) {
            int iIn = i * elementCount;
            for (int jIn = 0; jIn < in[0].length; ++jIn) {
                int j = jIn * elementCount;
                for (int k = 0; k < elementCount; ++k) {
                    out[i][j + k] = in[iIn + k][jIn];
                }
            }
        }
        return out;
    }

    public static byte[][] combineTraces(int elementCount, byte[][] in) {
        if (elementCount == 1) {
            return in;
        }
        if (in.length % elementCount != 0) {
            throw new IllegalArgumentException("Length of traces (" + in.length + ") must be evenly divisible by elementCount (" + elementCount + ")!");
        }
        int[] newLengths = new int[]{in[0].length * elementCount, in.length / elementCount};
        byte[][] out = new byte[newLengths[1]][newLengths[0]];
        for (int i = 0; i < out.length; ++i) {
            int iIn = i * elementCount;
            for (int jIn = 0; jIn < in[0].length; ++jIn) {
                int j = jIn * elementCount;
                for (int k = 0; k < elementCount; ++k) {
                    out[i][j + k] = in[iIn + k][jIn];
                }
            }
        }
        return out;
    }

    public static Object[][] combineTraces(int elementCount, Object[][] in) {
        if (elementCount == 1) {
            return in;
        }
        if (in.length % elementCount != 0) {
            throw new IllegalArgumentException("Length of traces (" + in.length + ") must be evenly divisible by elementCount (" + elementCount + ")!");
        }
        int[] newLengths = new int[]{in[0].length * elementCount, in.length / elementCount};
        Object[][] out = new Object[newLengths[1]][newLengths[0]];
        for (int i = 0; i < out.length; ++i) {
            int iIn = i * elementCount;
            for (int jIn = 0; jIn < in[0].length; ++jIn) {
                int j = jIn * elementCount;
                for (int k = 0; k < elementCount; ++k) {
                    out[i][j + k] = in[iIn + k][jIn];
                }
            }
        }
        return out;
    }

    public static String toString(Object in) {
        if (in instanceof int[]) {
            return Arrays.toString((int[])in);
        }
        if (in instanceof float[]) {
            return Arrays.toString((float[])in);
        }
        if (in instanceof short[]) {
            return Arrays.toString((short[])in);
        }
        if (in instanceof long[]) {
            return Arrays.toString((long[])in);
        }
        if (in instanceof double[]) {
            return Arrays.toString((double[])in);
        }
        if (in instanceof byte[]) {
            return Arrays.toString((byte[])in);
        }
        throw new UnsupportedOperationException();
    }

    public static Object[][] transpose(Object[][] rx) {
        int n2 = rx.length;
        int n1 = rx[0].length;
        Object[][] ry = new Object[n1][n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                ry[i1][i2] = rx[i2][i1];
            }
        }
        return ry;
    }

    public static int[] transpose(TransposeType type, int[] in) {
        int[] out = new int[in.length];
        int[] permutation = type.permutation();
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[permutation[i]];
        }
        return out;
    }

    public static long[] transpose(TransposeType type, long[] in) {
        long[] out = new long[in.length];
        int[] permutation = type.permutation();
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[permutation[i]];
        }
        return out;
    }

    public static float[] transpose(TransposeType type, float[] in) {
        float[] out = new float[in.length];
        int[] permutation = type.permutation();
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[permutation[i]];
        }
        return out;
    }

    public static double[] transpose(TransposeType type, double[] in) {
        double[] out = new double[in.length];
        int[] permutation = type.permutation();
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[permutation[i]];
        }
        return out;
    }

    public static Object[] transpose(TransposeType type, Object[] in) {
        Class<?> componentType = in.getClass().getComponentType();
        Object out = Array.newInstance(componentType, in.length);
        int[] permutation = type.permutation();
        for (int i = 0; i < in.length; ++i) {
            Object b = Array.get(in, permutation[i]);
            Array.set(out, i, b);
        }
        return (Object[])out;
    }
}

