#ifndef _JSWRAPPER_H_
#define _JSWRAPPER_H_

#include "jmwrapper.h"

#include <jni.h>

#ifdef __cplusplus
extern "C" {
#endif

enum {
  JSW_ERROR = -1,
  JSW_NORMAL
};

struct _JSWrapper
{
  JMWrapper *_jmw;
};

typedef struct _JSWrapper JSWrapper;

JSWrapper *jswrapper_create            /* create a JSWrapper instance     */
  (const char *filename);              /*   given JavaSeisFile name       */

JSWrapper *jswrapper_createrw          /* create a JSWrapper instance     */
  (const char *filename,               /*   given JavaSeisFile name       */
   const char *rw);                    /*   given I/O flag ("r" or "rw")  */

int jswrapper_isajavaseispath          /* return 0 if not a JavaSeisFile  */
  (JSWrapper *jsw);                    /*   given JSWrapper object        */

int jswrapper_status                   /* return 0 if NORMAL status       */
  (JSWrapper *jsw);                    /*   given JSWrapper object        */

char *jswrapper_message                /* return JavaSeisWrapper message  */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   char *mess,                         /*   preallocated array to be popul*/
   size_t max_size);                   /*   maximum size of given array   */

long jswrapper_gettracecount           /* return trace count              */
  (JSWrapper *jsw);                    /*   given JSWrapper object        */

int jswrapper_getnumdimensions         /* return number of dimensions     */
  (JSWrapper *jsw);                    /*   given JSWrapper object        */

int jswrapper_getsamplecount           /* return sample count             */
  (JSWrapper *jsw);                    /*   given JSWrapper object        */

int jswrapper_gettrace                 /* return no of trc values read    */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   float *trace,                       /*   preallocated array to be popul*/
   size_t max_size);                   /*   maximum size of given array   */

int jswrapper_puttrace                 /* return no of trc values written */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   float *trace,                       /*   array to contain trace values */
   size_t size);                       /*   size of given array           */

int jswrapper_settracenumber           /* return 1 if trace number was set*/
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   long trace_num);                    /*   1-relative trace number       */

int jswrapper_open                     /* return 1 if open successful     */
  (JSWrapper *jsw);                    /*   given JSWrapper object        */

int jswrapper_setaxis                  /* rtn 1 if set axis parameters OK */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   int idim,                           /*   which axis dimension to set   */
   int length,                         /*   length of axis                */
   const char *domain,                 /*   axis data domain              */
   const char *units,                  /*   axis data units               */
   long logical_org,                   /*   axis logical origin           */
   long logical_del,                   /*   axis logical delta            */
   double physical_org,                /*   axis physical origin          */
   double physical_del);               /*   axis physical delta           */

int jswrapper_getaxis                  /* rtn 1 if rtnd axis parameters OK*/
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   int idim,                           /*   which axis dimension to get   */
   int *length,                        /*   rtnd length of axis           */
   char *domain,                       /*   rtnd axis data domain         */
   char *units,                        /*   rtnd axis data units          */
   long *logical_org,                  /*   rtnd axis logical origin      */
   long *logical_del,                  /*   rtnd axis logical delta       */
   double *physical_org,               /*   rtnd axis physical origin     */
   double *physical_del);              /*   rtnd axis physical delta      */

int jswrapper_addintproperty           /* rtn 1 if property added         */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *name,                   /*   property name                 */
   const char *description);           /*   property description          */

int jswrapper_addfloatproperty         /* rtn 1 if property added         */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *name,                   /*   property name                 */
   const char *description);           /*   property description          */

int jswrapper_adddoubleproperty        /* rtn 1 if property added         */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *name,                   /*   property name                 */
   const char *description);           /*   property description          */

int jswrapper_addlongproperty          /* rtn 1 if property added         */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *name,                   /*   property name                 */
   const char *description);           /*   property description          */

int jswrapper_putintproperty           /* rtn 1 if property value put     */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *name,                   /*   property name                 */
   int value);                         /*   property value                */

int jswrapper_putfloatproperty         /* rtn 1 if property value put     */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *name,                   /*   property name                 */
   float value);                       /*   property value                */

int jswrapper_putdoubleproperty        /* rtn 1 if property value put     */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *name,                   /*   property name                 */
   double value);                      /*   property value                */

int jswrapper_putlongproperty          /* rtn 1 if property value put     */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *name,                   /*   property name                 */
   long value);                        /*   property value                */

int jswrapper_getintproperty           /* property value                  */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *name);                  /*   property name                 */

float jswrapper_getfloatproperty       /* property value                  */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *name);                  /*   property name                 */

double jswrapper_getdoubleproperty     /* property value                  */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *name);                  /*   property name                 */

long jswrapper_getlongproperty         /* property value                  */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *name);                  /*   property name                 */

int jswrapper_setdatatype              /* rtn length of data type set     */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *type);                  /*   data type (e.g."STACK","CMP") */

char *jswrapper_getdatatype            /* return data type or NULL        */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   char *type,                         /*   data type (e.g."STACK","CMP") */
   size_t max_size);                   /*   maximum size of given array   */

int jswrapper_settraceformat           /* rtn length of trace format set  */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   const char *format);                /*   format (e.g."FLOAT","INT16")  */

char *jswrapper_gettraceformat         /* return trace format or NULL     */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   char *format,                       /*   format (e.g."FLOAT","INT16")  */
   size_t max_size);                   /*   maximum size of given array   */

int jswrapper_setbin                   /* return 1 if bin grid set        */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   double *world,                      /*   given world coordinates (6)   */
   double *grid,                       /*   given grid coordinates (4)    */
   long *logical);                     /*   given logical coordinates (8) */

int jswrapper_getbin                   /* return 1 if bin grid received   */
  (JSWrapper *jsw,                     /*   given JSWrapper object        */
   double *world,                      /*   returned world coordinates (6)*/
   double *grid,                       /*   returned grid coordinates (4) */
   long *logical);                     /*   rtnd logical coordinates (8)  */

void jswrapper_close                   /* close file                      */
  (JSWrapper *jsw);                    /*   given JSWrapper object        */

int jswrapper_remove                   /* return 1 if delete successful   */
  (JSWrapper *jsw);                    /*   given JSWrapper object        */

void jswrapper_delete                  /* destructor for                  */
  (JSWrapper *jsw);                    /*   given JSWrapper object        */

#ifdef __cplusplus
}
#endif

#endif
