/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.util;

import com.certicom.ecc.util.ConversionException;
import java.math.BigInteger;

public final class Conversion {
    private static char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Conversion() {
    }

    public static byte[] I2OSP(BigInteger bigInteger, int n2) throws ConversionException {
        int n3;
        int n4 = (bigInteger.bitLength() + 7) / 8;
        if (n2 == -1) {
            n2 = n4;
        }
        if (n4 > n2 || bigInteger.signum() == -1) {
            throw new ConversionException("Illegal value of X");
        }
        byte[] byArray = bigInteger.toByteArray();
        int n5 = byArray.length;
        for (n3 = 0; n3 < n5 && byArray[n3] == 0; ++n3) {
        }
        byte[] byArray2 = new byte[n2];
        if (n3 == n5) {
            return byArray2;
        }
        n4 = n5 - n3;
        System.arraycopy(byArray, n3, byArray2, n2 - n4, n4);
        return byArray2;
    }

    public static BigInteger OS2IP(byte[] byArray) {
        return new BigInteger(1, byArray);
    }

    public static String OS2Hex(byte[] byArray, int n2) {
        if (byArray == null) {
            return "null";
        }
        if (byArray.length == 0 || byArray.length == 1 && byArray[0] == 0) {
            return "00";
        }
        int n3 = byArray.length * 2;
        if (n2 > 0) {
            n3 += n3 / n2;
            if (byArray.length * 2 % n2 == 0) {
                --n3;
            }
        } else {
            n2 = n3;
        }
        char[] cArray = new char[n3];
        int n4 = byArray.length - 1;
        int n5 = n3 - 1;
        int n6 = 0;
        while (n5 >= 0) {
            if (n6 % n2 == 0 && n6 > 0) {
                cArray[n5--] = 32;
            }
            cArray[n5--] = a[byArray[n4] & 0xF];
            cArray[n5--] = a[byArray[n4--] >> 4 & 0xF];
            n6 += 2;
        }
        return "" + cArray;
    }

    public static byte[] HexString2OS(String string) {
        if ((string.length() & 1) != 0) {
            string = "0" + string;
        }
        byte[] byArray = new byte[string.length() >>> 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[n3++] = (byte)((Character.digit(string.charAt(n2++), 16) << 4) + Character.digit(string.charAt(n2++), 16));
        }
        return byArray;
    }

    public static void dumpHex(byte[] byArray, int n2, int n3) {
        System.out.println("----------------------");
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = byArray[i2 + n2] & 0xFF;
            if (i2 > 1 && i2 % 16 == 0) {
                System.out.println();
            }
            if (n4 < 16) {
                System.out.print("0");
            }
            System.out.print(Integer.toString(n4, 16) + " ");
        }
        System.out.println();
        System.out.println("----------------------");
    }

    public static void dumpHex(byte[] byArray) {
        Conversion.dumpHex(byArray, 0, byArray.length);
    }

    public static byte[] extendArray(byte[] byArray, int n2) {
        byte[] byArray2;
        int n3 = byArray.length;
        if (n3 > n2) {
            byArray2 = new byte[n2];
            int n4 = n3 - n2;
            for (int i2 = 0; i2 < n4; ++i2) {
                if (byArray[i2] == 0) continue;
                throw new IllegalArgumentException("Array too long for given length");
            }
            System.arraycopy(byArray, n4, byArray2, 0, n2);
        } else if (n3 == n2) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, n2 - n3, n3);
        }
        return byArray2;
    }
}

