/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.util.Conversion;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public class FFCParamsValidate
extends CryptoTransform
implements Serializable {
    private static final long serialVersionUID = -664529786179614752L;
    private Integer a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    public static final Integer INVALID = new Integer(0);
    public static final Integer INVALID_SIZE = new Integer(1);
    public static final Integer PARTIALLY_VALID = new Integer(2);
    public static final Integer VALIDITY_OF_G = new Integer(0);
    private static final BigInteger e = new BigInteger(new byte[]{2});

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(this.c);
        objectOutputStream.writeObject(this.d);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (Integer)objectInputStream.readObject();
        this.b = (BigInteger)objectInputStream.readObject();
        this.c = (BigInteger)objectInputStream.readObject();
        this.d = (BigInteger)objectInputStream.readObject();
    }

    public FFCParamsValidate() {
        super("DHParamValidate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        boolean bl = false;
        try {
            if (n2 != 2) {
                throw new IllegalArgumentException("mode!=VERIFY");
            }
            if (objectArray == null || objectArray.length < 1) {
                throw new IllegalArgumentException("empty params");
            }
            if (!(objectArray[0] instanceof Integer)) {
                throw new IllegalArgumentException("params[0] is not Integer");
            }
            this.a = (Integer)objectArray[0];
            if (VALIDITY_OF_G.equals(this.a)) {
                if (objectArray.length != 4) {
                    throw new IllegalArgumentException("params wrong length");
                }
            } else {
                throw new IllegalArgumentException("Invalid type: " + this.a);
            }
            this.b = this.a(objectArray[1]);
            this.c = this.a(objectArray[2]);
            this.d = this.a(objectArray[3]);
            bl = true;
        }
        finally {
            if (bl) {
                super.init(n2, objectArray, random);
            } else {
                this.reset();
            }
        }
    }

    private BigInteger a(Object object) {
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (object instanceof String) {
            object = Conversion.HexString2OS(String.valueOf(object));
        }
        if (object instanceof byte[]) {
            return new BigInteger(1, (byte[])object);
        }
        if (object instanceof Number) {
            return new BigInteger(((Number)object).toString());
        }
        throw new IllegalArgumentException("Could not convert " + object + " to BigInteger");
    }

    public int outputSize(int n2, boolean bl) {
        return 0;
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        return 0;
    }

    public Object transformToObject(byte[] byArray, int n2, int n3, boolean bl) throws IllegalStateException {
        try {
            if (VALIDITY_OF_G.equals(this.a)) {
                int n4 = this.b.bitLength();
                int n5 = this.c.bitLength();
                if (!(n4 == 1024 && n5 == 160 || n4 == 2048 && n5 == 224 || n4 == 2048 && n5 == 256 || n4 == 3072 && n5 == 256)) {
                    Integer n6 = INVALID_SIZE;
                    return n6;
                }
                BigInteger bigInteger = this.b.subtract(BigInteger.ONE);
                if (e.compareTo(this.d) > 0 || this.d.compareTo(bigInteger) > 0) {
                    Integer n7 = INVALID;
                    return n7;
                }
                BigInteger bigInteger2 = this.d.modPow(this.c, this.b);
                if (bigInteger2.equals(BigInteger.ONE)) {
                    Integer n8 = PARTIALLY_VALID;
                    return n8;
                }
                Integer n9 = INVALID;
                return n9;
            }
            throw new IllegalStateException("Not correctly initialized");
        }
        finally {
            this.reset();
        }
    }

    public void reset() {
        super.reset();
        this.a = null;
        this.d = null;
        this.c = null;
        this.b = null;
    }
}

