/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.ECCurve;
import com.certicom.ecc.ECException;
import com.certicom.ecc.ECFactory;
import com.certicom.ecc.FF;
import com.certicom.ecc.FFFactory;
import com.certicom.ecc.NoSuchECTypeException;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.interfaces.F2mParams;
import com.certicom.ecc.interfaces.FpParams;
import com.certicom.ecc.interfaces.PointParams;
import com.certicom.ecc.provider.EccPoint;
import com.certicom.ecc.provider.F2mPoint;
import com.certicom.ecc.provider.FpPoint;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.CurveList;
import com.certicom.ecc.scheme.ECDSA;
import com.certicom.ecc.spec.ECPrivateKeySpec;
import com.certicom.ecc.spec.ECPublicKeySpec;
import com.certicom.ecc.spec.PointSpec;
import com.certicom.ecc.system.CryptoManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public class ECQV
extends CryptoTransform
implements Serializable {
    private static final long serialVersionUID = -4850479018493394256L;
    private CryptoTransform d;
    private ECParams e;
    private FFFactory f;
    private FFFactory k;
    private CryptoTransform l;
    private ECPrivateKey m;
    private ECPublicKey n;
    private ECPrivateKey o;
    private ECPublicKey p;
    private ECPrivateKey q;
    private ECPublicKey r;
    private ECPrivateKey s;
    private ECPublicKey t;
    private byte[] u;
    private boolean v;
    private int w;
    private ECPrivateKey x;
    private final int y = 0;
    private final int z = 1;
    private final int A = 2;
    static Class a;
    static Class b;
    static Class c;

    public ECQV() {
        super("ECQV");
    }

    public int outputSize(int n2, boolean bl) throws IllegalStateException {
        return 0;
    }

    public void reset() {
        super.reset();
        this.d = null;
        this.e = null;
        this.f = null;
        this.k = null;
        this.l = null;
        this.m = null;
        this.n = null;
        this.o = null;
        this.p = null;
        this.q = null;
        this.r = null;
        this.s = null;
        this.t = null;
        this.u = null;
        this.x = null;
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) {
        return 0;
    }

    public Object transformToObject(byte[] byArray, int n2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        try {
            Object object;
            block1 : switch (this.h) {
                case 9: {
                    if (this.v) {
                        object = this.a();
                        break;
                    }
                    object = this.b();
                    break;
                }
                case 8: {
                    switch (this.w) {
                        case 0: {
                            object = this.c();
                            break block1;
                        }
                        case 1: {
                            object = new Boolean(this.d());
                            break block1;
                        }
                        case 2: {
                            object = this.e();
                            break block1;
                        }
                    }
                    throw new IllegalStateException("wrong server mode");
                }
                case 10: {
                    object = this.f();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("wrong mode");
                }
            }
            return object;
        }
        catch (NoSuchECTypeException noSuchECTypeException) {
            noSuchECTypeException.printStackTrace();
            throw new IllegalArgumentException(noSuchECTypeException.getMessage());
        }
        catch (ECException eCException) {
            eCException.printStackTrace();
            throw new IllegalArgumentException(eCException.getMessage());
        }
    }

    public boolean verify(byte[] byArray, int n2, int n3) {
        return this.d();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(int n2, Object[] objectArray, Random random) {
        String string;
        super.init(n2, objectArray, random);
        if (objectArray[0] instanceof String) {
            string = (String)objectArray[0];
            this.e = CurveList.byName(string);
        } else {
            if (!(objectArray[0] instanceof ECParams)) throw new IllegalArgumentException("params[0] is wrong, should be a String (represents a curve name)  or ECParams represents an EC parameters");
            this.e = (ECParams)objectArray[0];
        }
        this.a(this.e);
        string = (String)objectArray[1];
        this.d = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, string);
        this.l = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "KEYGEN");
        this.l.init(5, new Object[]{this.e}, random);
        if (n2 == 9) {
            if (objectArray == null || objectArray.length != 6 && objectArray.length != 5) {
                throw new IllegalArgumentException("wrong params");
            }
            if (objectArray[2].equals(a == null ? (a = ECQV.a("com.certicom.ecc.interfaces.ECPrivateKey")) : a)) {
                this.s = (ECPrivateKey)objectArray[3];
                this.m = (ECPrivateKey)objectArray[4];
                this.u = (byte[])objectArray[5];
                this.v = false;
                return;
            } else {
                if (!objectArray[2].equals(b == null ? (b = ECQV.a("com.certicom.ecc.interfaces.ECPublicKey")) : b)) throw new IllegalArgumentException("wrong params");
                this.p = (ECPublicKey)objectArray[3];
                this.n = (ECPublicKey)objectArray[4];
                this.v = true;
            }
            return;
        } else if (n2 == 8) {
            if (objectArray == null || objectArray.length != 6 && objectArray.length != 8 && objectArray.length != 4) {
                throw new IllegalArgumentException("wrong params");
            }
            if (objectArray[2].equals(a == null ? (a = ECQV.a("com.certicom.ecc.interfaces.ECPrivateKey")) : a)) {
                this.q = (ECPrivateKey)objectArray[3];
                this.u = (byte[])objectArray[4];
                this.o = (ECPrivateKey)objectArray[5];
                this.w = 0;
                return;
            } else if (objectArray[2].equals(c == null ? (c = ECQV.a("java.lang.Boolean")) : c)) {
                this.q = (ECPrivateKey)objectArray[3];
                this.u = (byte[])objectArray[4];
                this.p = (ECPublicKey)objectArray[5];
                this.r = (ECPublicKey)objectArray[6];
                this.t = (ECPublicKey)objectArray[7];
                this.w = 1;
                return;
            } else {
                if (!objectArray[2].equals(b == null ? (b = ECQV.a("com.certicom.ecc.interfaces.ECPublicKey")) : b)) throw new IllegalArgumentException("wrong params");
                this.x = (ECPrivateKey)objectArray[3];
                this.w = 2;
            }
            return;
        } else {
            if (n2 != 10) throw new IllegalArgumentException("wrong mode");
            if (objectArray == null || objectArray.length != 5) {
                throw new IllegalArgumentException("wrong params");
            }
            this.t = (ECPublicKey)objectArray[2];
            this.u = (byte[])objectArray[3];
            this.r = (ECPublicKey)objectArray[4];
        }
    }

    private ECPublicKey a() {
        if (this.n == null) {
            throw new IllegalStateException("ephemeral public key is null");
        }
        EccPoint eccPoint = this.a(this.e, this.p);
        EccPoint eccPoint2 = this.a(this.e, this.n);
        EccPoint eccPoint3 = (EccPoint)eccPoint.a(eccPoint2);
        return this.a(this.e, eccPoint3);
    }

    private ECPrivateKey b() {
        FF fF;
        byte[] byArray = this.a(this.u);
        FF fF2 = this.k.a(this.m.getExp());
        FF fF3 = this.k.a(byArray);
        byte[] byArray2 = this.s.getExp();
        FF fF4 = this.k.a(byArray2);
        FF fF5 = fF3.c(fF2);
        FF fF6 = fF = fF5.a(fF4);
        ECPrivateKey eCPrivateKey = this.a(this.e, fF6);
        return eCPrivateKey;
    }

    private ECPrivateKey c() throws NoSuchECTypeException {
        byte[] byArray = this.a(this.u);
        FF fF = this.k.a(this.o.getExp());
        FF fF2 = this.k.a(this.q.getExp());
        FF fF3 = this.k.a(byArray);
        FF fF4 = fF3.c(fF).a(fF2);
        ECPrivateKey eCPrivateKey = this.a(this.e, fF4);
        return eCPrivateKey;
    }

    private boolean d() {
        EccPoint eccPoint = this.a(this.e, this.t);
        EccPoint eccPoint2 = this.a(this.e, this.r);
        byte[] byArray = this.a(this.u);
        BigInteger bigInteger = new BigInteger(1, byArray);
        EccPoint eccPoint3 = this.a(this.e, this.e.getPoint());
        EccPoint eccPoint4 = (EccPoint)eccPoint3.a(new BigInteger(1, this.q.getExp()));
        EccPoint eccPoint5 = this.a(this.e, this.p);
        EccPoint eccPoint6 = (EccPoint)eccPoint5.b(eccPoint2).a(bigInteger).a(eccPoint4);
        return eccPoint.equals(eccPoint6);
    }

    private ECPublicKey e() throws ECException {
        BigInteger bigInteger = new BigInteger(1, this.x.getExp());
        EccPoint eccPoint = (EccPoint)ECFactory.a(this.e).c().a(bigInteger);
        return this.a(this.e, eccPoint);
    }

    private ECPublicKey f() throws NoSuchECTypeException {
        EccPoint eccPoint = this.a(this.e, this.t);
        EccPoint eccPoint2 = this.a(this.e, this.r);
        byte[] byArray = this.a(this.u);
        BigInteger bigInteger = new BigInteger(1, byArray);
        EccPoint eccPoint3 = (EccPoint)eccPoint2.a(bigInteger).a(eccPoint);
        return this.a(this.e, eccPoint3);
    }

    private EccPoint a(ECParams eCParams, ECPublicKey eCPublicKey) {
        return this.a(eCParams, eCPublicKey.getPoint());
    }

    private EccPoint a(ECParams eCParams, PointParams pointParams) {
        BigInteger bigInteger = new BigInteger(1, eCParams.getPointOrder());
        FF fF = this.f.a(pointParams.getX());
        FF fF2 = this.f.a(pointParams.getY());
        FF fF3 = this.f.a(eCParams.getA());
        FF fF4 = this.f.a(eCParams.getB());
        ECCurve eCCurve = new ECCurve(fF3, fF4, bigInteger);
        EccPoint eccPoint = eCParams instanceof F2mParams ? new F2mPoint(fF, fF2, eCCurve) : new FpPoint(fF, fF2, eCCurve);
        return eccPoint;
    }

    private ECPublicKey a(ECParams eCParams, EccPoint eccPoint) {
        byte[] byArray = new PointSpec(eccPoint.e().f(), eccPoint.f().f(), eCParams).getEncoded(2);
        return new ECPublicKeySpec(10, 2, eCParams, byArray, 0, byArray.length);
    }

    private ECPrivateKey a(ECParams eCParams, FF fF) {
        byte[] byArray = fF.f();
        return new ECPrivateKeySpec(10, eCParams, byArray, 0, byArray.length);
    }

    private byte[] a(byte[] byArray) {
        Object[] objectArray = null;
        if (this.d.getAlgorithm().equals("MMO")) {
            objectArray = new Object[]{"AES"};
        }
        this.d.init(5, objectArray, this.g);
        byte[] byArray2 = this.d.transform(byArray, 0, byArray.length, true);
        byArray2 = ECDSA.a(byArray2, this.e.getPointOrderSize() - 1);
        return byArray2;
    }

    private void a(ECParams eCParams) {
        byte[] byArray = null;
        Object object = null;
        try {
            if (eCParams instanceof FpParams) {
                this.f = FFFactory.a("FP");
                byArray = ((FpParams)eCParams).getPrime();
            } else if (eCParams instanceof F2mParams) {
                this.f = FFFactory.a("F2M");
                int n2 = eCParams.getSize();
                byArray = new byte[]{(byte)(n2 >>> 24), (byte)(n2 >>> 16), (byte)(n2 >>> 8), (byte)n2};
                int[] nArray = ((F2mParams)eCParams).getBasis();
                if (nArray != null) {
                    object = new byte[nArray.length][];
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        n2 = nArray[i2];
                        object[i2] = new byte[]{(byte)(n2 >>> 24), (byte)(n2 >>> 16), (byte)(n2 >>> 8), (byte)n2};
                    }
                }
            } else {
                throw new NoSuchECTypeException("unknown ec type.");
            }
            this.f.a(byArray, (byte[][])object);
            this.k = FFFactory.a("FP");
            this.k.a(eCParams.getPointOrder(), null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("no math classes.");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.d);
        objectOutputStream.writeObject(this.e);
        objectOutputStream.writeObject(this.f);
        objectOutputStream.writeObject(this.k);
        objectOutputStream.writeObject(this.l);
        objectOutputStream.writeObject(this.m);
        objectOutputStream.writeObject(this.n);
        objectOutputStream.writeObject(this.o);
        objectOutputStream.writeObject(this.p);
        objectOutputStream.writeObject(this.q);
        objectOutputStream.writeObject(this.r);
        objectOutputStream.writeObject(this.s);
        objectOutputStream.writeObject(this.t);
        objectOutputStream.writeObject(this.u);
        objectOutputStream.writeObject(new Boolean(this.v));
        objectOutputStream.writeObject(new Integer(this.w));
        objectOutputStream.writeObject(this.x);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.d = (CryptoTransform)objectInputStream.readObject();
        this.e = (ECParams)objectInputStream.readObject();
        this.f = (FFFactory)objectInputStream.readObject();
        this.k = (FFFactory)objectInputStream.readObject();
        this.l = (CryptoTransform)objectInputStream.readObject();
        this.m = (ECPrivateKey)objectInputStream.readObject();
        this.n = (ECPublicKey)objectInputStream.readObject();
        this.o = (ECPrivateKey)objectInputStream.readObject();
        this.p = (ECPublicKey)objectInputStream.readObject();
        this.q = (ECPrivateKey)objectInputStream.readObject();
        this.r = (ECPublicKey)objectInputStream.readObject();
        this.s = (ECPrivateKey)objectInputStream.readObject();
        this.t = (ECPublicKey)objectInputStream.readObject();
        this.u = (byte[])objectInputStream.readObject();
        this.v = (Boolean)objectInputStream.readObject();
        this.w = (Integer)objectInputStream.readObject();
        this.x = (ECPrivateKey)objectInputStream.readObject();
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

