/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.PBES2CipherSpi;
import com.certicom.ecc.jcae.PBESecretKeyFactorySpi;
import com.certicom.ecc.spec.PBES2ParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.MacSpi;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class PBMacSpi
extends MacSpi {
    private String a = null;
    private Mac b = null;
    private boolean c = false;

    PBMacSpi(String string) {
        try {
            this.a = string;
            this.b = Mac.getInstance(this.a, "Certicom");
        }
        catch (Throwable throwable) {
            throw new InvalidParameterException(throwable.getMessage());
        }
    }

    protected byte[] engineDoFinal() {
        this.a();
        return this.b.doFinal();
    }

    protected void a() {
        if (!this.c) {
            throw new IllegalStateException("Not initialized");
        }
    }

    protected int engineGetMacLength() {
        return this.b.getMacLength();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int n2;
        char[] cArray;
        int n3;
        this.c = false;
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("Not a PBEKey");
        }
        PBEKey pBEKey = (PBEKey)key;
        int n4 = this.b.getMacLength();
        if (key instanceof PBESecretKeyFactorySpi.PBEKeyImpl && (n3 = ((PBESecretKeyFactorySpi.PBEKeyImpl)key).getKeyLength()) > 0) {
            n4 = n3;
        }
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Not a PBEParameterSpec");
        }
        PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
        String string = key.getAlgorithm();
        if (string == null || string.length() == 0) {
            throw new InvalidKeyException("Key missing algorithm");
        }
        int n5 = (string = string.toLowerCase()).indexOf("hmacsha");
        if (n5 == -1) {
            throw new InvalidKeyException("Unsupported algorithm: " + key.getAlgorithm());
        }
        int n6 = 0;
        int n7 = string.length();
        for (int i2 = n5 + 7; i2 < n7; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '-') continue;
            if (c2 < '0' || c2 > '9') break;
            n6 *= 10;
            n6 += c2 - 48;
        }
        if ((cArray = pBEKey.getPassword()) == null || cArray.length == 0) {
            throw new InvalidKeyException("Password not set in key");
        }
        byte[] byArray = pBEKey.getSalt();
        if (byArray == null || byArray.length == 0) {
            if (pBEParameterSpec != null) {
                byArray = pBEParameterSpec.getSalt();
            }
            if (byArray == null || byArray.length == 0) {
                throw new InvalidAlgorithmParameterException("Salt is required");
            }
        }
        if ((n2 = pBEKey.getIterationCount()) <= 0) {
            if (pBEParameterSpec != null) {
                n2 = pBEParameterSpec.getIterationCount();
            }
            if (n2 <= 0) {
                throw new InvalidAlgorithmParameterException("Iteration count is required");
            }
        }
        boolean bl = Boolean.getBoolean("com.certicom.ecc.spec.pbes2.zeroBasedBugEnabled");
        if (pBEParameterSpec instanceof PBES2ParameterSpec) {
            bl = ((PBES2ParameterSpec)pBEParameterSpec).isZeroBasedBugEnabled();
        }
        byte[] byArray2 = new byte[cArray.length];
        for (int i3 = 0; i3 < cArray.length; ++i3) {
            byArray2[i3] = (byte)cArray[i3];
        }
        Mac mac = null;
        try {
            mac = Mac.getInstance("HMacSHA" + n6, "Certicom");
        }
        catch (Throwable throwable) {
            throw new InvalidParameterException(throwable.getMessage());
        }
        byte[] byArray3 = PBES2CipherSpi.a(byArray2, byArray, n2, n4, mac, bl);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, "HMac");
        this.b.init(secretKeySpec);
        this.c = true;
    }

    protected void engineReset() {
        this.b.reset();
    }

    protected void engineUpdate(byte by) {
        this.a();
        this.b.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.a();
        this.b.update(byArray, n2, n3);
    }

    public static class PBMacWithHmacSHA512
    extends PBMacSpi {
        public PBMacWithHmacSHA512() {
            super("HmacSHA512");
        }
    }

    public static class PBMacWithHmacSHA384
    extends PBMacSpi {
        public PBMacWithHmacSHA384() {
            super("HmacSHA384");
        }
    }

    public static class PBMacWithHmacSHA256
    extends PBMacSpi {
        public PBMacWithHmacSHA256() {
            super("HmacSHA256");
        }
    }

    public static class PBMacWithHmacSHA224
    extends PBMacSpi {
        public PBMacWithHmacSHA224() {
            super("HmacSHA224");
        }
    }

    public static class PBMacWithHmacSHA1
    extends PBMacSpi {
        public PBMacWithHmacSHA1() {
            super("HmacSHA1");
        }
    }
}

