/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.jcae.CurveList;
import com.certicom.ecc.jcae.ECPrivateKey;
import com.certicom.ecc.jcae.ECPublicKey;
import com.certicom.ecc.jcae.RNGSpi;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import com.certicom.ecc.util.JDKVersion;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class ECKPGenSpi
extends KeyPairGeneratorSpi {
    private SecureRandom b;
    private AlgorithmParameterSpec c;
    private CryptoTransform d;
    private int e;
    private int f;
    private String g;
    static Class a;

    public ECKPGenSpi() {
        this("");
    }

    protected ECKPGenSpi(String string) {
        this.g = string;
        if (string == null) {
            throw new IllegalArgumentException("keyType==null");
        }
        this.d = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, string + "KEYGEN");
        this.e = SystemConfig.getConfig().getFormat();
        this.f = SystemConfig.getConfig().getPtCompression();
    }

    public KeyPair generateKeyPair() {
        if (this.b == null) {
            this.b = RNGSpi.a();
        }
        if (this.c == null) {
            this.c = CurveList.byName("sect163k1");
        }
        if (this.d.getMode() == 0) {
            try {
                this.initialize(this.c, this.b);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                // empty catch block
            }
        }
        ECKey[] eCKeyArray = (ECKey[])this.d.transformToObject(null, 0, 0, true);
        PublicKey publicKey = new ECPublicKey(this.e, this.f, (com.certicom.ecc.interfaces.ECPublicKey)eCKeyArray[1]);
        PrivateKey privateKey = new ECPrivateKey(this.e, (com.certicom.ecc.interfaces.ECPrivateKey)eCKeyArray[0]);
        publicKey = (PublicKey)JDKVersion.getTranslator().translateECKey_1_3_to_1_5(publicKey);
        privateKey = (PrivateKey)JDKVersion.getTranslator().translateECKey_1_3_to_1_5(privateKey);
        return new KeyPair(publicKey, privateKey);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        algorithmParameterSpec = JDKVersion.getTranslator().translateECParams_1_5_to_1_3(a == null ? (a = ECKPGenSpi.a("com.certicom.ecc.interfaces.ECParams")) : a, algorithmParameterSpec);
        if (!(algorithmParameterSpec instanceof ECParams)) {
            throw new InvalidAlgorithmParameterException("wrong params");
        }
        this.c = algorithmParameterSpec;
        this.b = secureRandom;
        this.d.init(5, new Object[]{this.c}, this.b);
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        try {
            AlgorithmParameterSpec algorithmParameterSpec = null;
            try {
                algorithmParameterSpec = CurveList.bySize(n2, 2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("curve not found.".equals(illegalArgumentException.getMessage())) {
                    algorithmParameterSpec = CurveList.bySize(n2, 1);
                }
                throw illegalArgumentException;
            }
            this.initialize(algorithmParameterSpec, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException(invalidAlgorithmParameterException.getMessage());
        }
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ECMQVKPGenSpi
    extends ECKPGenSpi {
        public ECMQVKPGenSpi() {
            super("ECMQV");
        }
    }

    public static class ECDHKPGenSpi
    extends ECKPGenSpi {
        public ECDHKPGenSpi() {
            super("ECDH");
        }
    }

    public static class ECDSAKPGenSpi
    extends ECKPGenSpi {
        public ECDSAKPGenSpi() {
            super("ECDSA");
        }
    }
}

