/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.DHDefaultParams;
import com.certicom.ecc.jcae.RNGSpi;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.util.Conversion;
import com.certicom.ecc.util.ConversionException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;

public final class DSAKPGenSpi
extends KeyPairGeneratorSpi {
    private static final DSAParameterSpec c = new DSAParameterSpec(new BigInteger(1, DHDefaultParams.DEFAULT_P512), new BigInteger(1, DHDefaultParams.DEFAULT_Q512), new BigInteger(1, DHDefaultParams.DEFAULT_G512));
    private static final DSAParameterSpec d = new DSAParameterSpec(new BigInteger(1, DHDefaultParams.DEFAULT_P768), new BigInteger(1, DHDefaultParams.DEFAULT_Q768), new BigInteger(1, DHDefaultParams.DEFAULT_G768));
    private static final DSAParameterSpec e = new DSAParameterSpec(new BigInteger(1, DHDefaultParams.DEFAULT_P1024), new BigInteger(1, DHDefaultParams.DEFAULT_Q1024), new BigInteger(1, DHDefaultParams.DEFAULT_G1024));
    private SecureRandom f;
    private DSAParameterSpec g;
    CryptoTransform a;
    KeyFactory b;

    public DSAKPGenSpi() throws InstantiationException {
        try {
            this.b = KeyFactory.getInstance("DSA", "Certicom");
            this.a = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "DSAKEYGEN");
        }
        catch (Exception exception) {
            throw new InstantiationException(exception.getMessage());
        }
    }

    public KeyPair generateKeyPair() {
        if (this.f == null) {
            this.f = RNGSpi.a();
        }
        if (this.g == null) {
            this.g = e;
        }
        if (this.a.getMode() == 0) {
            try {
                this.initialize(this.g, this.f);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                // empty catch block
            }
        }
        Object[] objectArray = (Object[])this.a.transformToObject(null, 0, 0, true);
        DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(new BigInteger(1, (byte[])objectArray[0]), this.g.getP(), this.g.getQ(), this.g.getG());
        DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(new BigInteger(1, (byte[])objectArray[1]), this.g.getP(), this.g.getQ(), this.g.getG());
        try {
            PrivateKey privateKey = this.b.generatePrivate(dSAPrivateKeySpec);
            PublicKey publicKey = this.b.generatePublic(dSAPublicKeySpec);
            return new KeyPair(publicKey, privateKey);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
            return null;
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("wrong params");
        }
        this.g = (DSAParameterSpec)algorithmParameterSpec;
        this.f = secureRandom;
        try {
            byArray3 = Conversion.I2OSP(this.g.getP(), -1);
        }
        catch (ConversionException conversionException) {
            byArray3 = this.g.getP().toByteArray();
        }
        try {
            byArray2 = Conversion.I2OSP(this.g.getQ(), -1);
        }
        catch (ConversionException conversionException) {
            byArray2 = this.g.getQ().toByteArray();
        }
        try {
            byArray = Conversion.I2OSP(this.g.getG(), -1);
        }
        catch (ConversionException conversionException) {
            byArray = this.g.getG().toByteArray();
        }
        this.a.init(5, new Object[]{byArray3, byArray2, byArray}, this.f);
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        block5: {
            try {
                if (n2 == 512) {
                    this.initialize(c, secureRandom);
                    break block5;
                }
                if (n2 == 768) {
                    this.initialize(d, secureRandom);
                    break block5;
                }
                if (n2 == 1024) {
                    this.initialize(e, secureRandom);
                    break block5;
                }
                throw new IllegalArgumentException("no default parameters size: " + n2);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IllegalArgumentException(invalidAlgorithmParameterException.getMessage());
            }
        }
    }
}

