/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.codec;

import com.certicom.ecc.system.CryptoManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class CryptoCodec
implements Serializable {
    private static final long serialVersionUID = -366081322203996916L;
    public static final int UNINIT = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 2;
    public static final Class TYPE;
    protected int mode = 0;
    protected String format = null;
    protected String type = null;
    protected byte[] data;
    protected int doff;
    protected Object dataObj;
    protected Object[] result;

    protected CryptoCodec(String string) {
        this.format = string;
    }

    public static CryptoCodec getInstance(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string).append("/");
        if (n2 == 10) {
            stringBuffer.append("Raw");
        } else {
            stringBuffer.append("Asn1");
        }
        try {
            CryptoCodec cryptoCodec = (CryptoCodec)CryptoManager.getInstance(TYPE, stringBuffer.toString());
            cryptoCodec.type = string;
            return cryptoCodec;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(" not found. Error as follows:").append(illegalArgumentException.getMessage());
            throw new IllegalArgumentException(stringBuffer.toString());
        }
    }

    public void reset() {
        this.mode = 0;
        this.data = null;
        this.doff = 0;
        this.dataObj = null;
        this.result = null;
    }

    public void init(int n2, Object[] objectArray) throws IllegalArgumentException {
        this.mode = n2;
    }

    public Object[] codecToObject(byte[] byArray, int n2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        this.storeData(byArray, n2, n3);
        if (bl || this.hasInterData()) {
            this.dataOK(false);
            if (this.mode == 1) {
                this.encode();
            } else {
                this.decode();
            }
            this.a();
            Object[] objectArray = this.result;
            this.result = null;
            return objectArray;
        }
        return null;
    }

    public Object[] codecToObject(Object object, boolean bl) {
        if (object instanceof byte[]) {
            throw new IllegalArgumentException("use codecToObject(byte[], int, int, boolean)");
        }
        this.dataObj = object;
        if (bl || this.hasInterData()) {
            this.dataOK(true);
            if (this.mode == 1) {
                this.encode();
            } else {
                this.decode();
            }
            this.a();
            Object[] objectArray = this.result;
            this.result = null;
            return objectArray;
        }
        return null;
    }

    public int inputSize() {
        return 0;
    }

    public boolean hasInterData() {
        return false;
    }

    public boolean isIncremental() {
        return true;
    }

    public String getFormat() {
        return this.format;
    }

    public int getMode() {
        return this.mode;
    }

    public String getType() {
        return this.type;
    }

    public int outputSize() {
        return 0;
    }

    protected void storeData(byte[] byArray, int n2, int n3) {
        if (this.mode == 1 || this.mode == 2) {
            int n4;
            if (byArray == null) {
                return;
            }
            if (this.data == null) {
                this.data = new byte[256 > n3 ? 256 : n3];
                this.doff = 0;
            }
            if ((n4 = this.data.length - this.doff) < n3) {
                int n5 = n3 - n4 > 256 ? n3 - n4 : 256;
                byte[] byArray2 = new byte[this.data.length + n5];
                System.arraycopy(this.data, 0, byArray2, 0, this.doff);
                this.data = byArray2;
            }
            System.arraycopy(byArray, n2, this.data, this.doff, n3);
            this.doff += n3;
            return;
        }
        throw new IllegalStateException("wrong mode");
    }

    protected abstract void encode();

    protected abstract void decode();

    protected void dataOK(boolean bl) {
        if (bl ? this.dataObj == null : this.data == null || this.doff == 0) {
            throw new IllegalStateException("no data to codec");
        }
    }

    private void a() {
        this.dataObj = null;
        if (this.data != null) {
            int n2 = 0;
            while (n2 < this.data.length) {
                this.data[n2++] = 0;
            }
        }
        this.doff = 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(new Integer(this.mode));
        objectOutputStream.writeObject(this.format);
        objectOutputStream.writeObject(this.type);
        objectOutputStream.writeObject(this.data);
        objectOutputStream.writeObject(new Integer(this.doff));
        objectOutputStream.writeObject(this.dataObj);
        objectOutputStream.writeObject(this.result);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mode = (Integer)objectInputStream.readObject();
        this.format = (String)objectInputStream.readObject();
        this.type = (String)objectInputStream.readObject();
        this.data = (byte[])objectInputStream.readObject();
        this.doff = (Integer)objectInputStream.readObject();
        this.dataObj = objectInputStream.readObject();
        this.result = (Object[])objectInputStream.readObject();
    }

    static {
        try {
            TYPE = Class.forName("com.certicom.ecc.codec.CryptoCodec");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException();
        }
    }
}

