/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.datavolume;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.ExtentPolicyRandom;
import org.javaseis.util.datavolume.Directory;

public class JSC {
    public static String JSCFG;
    public static String HOME;
    public static String USER;
    public static String DATA;
    public static String ROOT;
    public static String[] HOSTS;
    public static String SCR;
    public static String PATH;
    public static String LOC;
    public static ExtentPolicy POLICY;
    private static String DIR;
    private static String JSCFILE;
    private static String JP_DEF;
    private static String JSCFG_DEF;
    private static String HOME_DEF;
    private static String DATA_DEF;
    private static String ROOT_DEF;
    private static String[] HOSTS_DEF;
    private static String SCR_DEF;
    public static boolean INITED;

    private static boolean initJavaSeisConfiguration() {
        boolean retval = false;
        try {
            JSCFG = System.getenv("JSCFG");
        }
        catch (Exception e) {
            JSCFG = null;
        }
        if (JSCFG != null) {
            retval = JSC.readJavaSeisConfigFile() == 1;
        } else {
            PATH = Directory.validPath(HOME, DIR);
            if (PATH != null && (JSCFG = Directory.validPath(HOME + "." + DIR, JSCFILE)) != null) {
                boolean bl = retval = JSC.readJavaSeisConfigFile() == 1;
            }
            if (!retval) {
                String jp;
                try {
                    jp = System.getenv("JP");
                }
                catch (Exception e) {
                    jp = null;
                }
                if (jp == null) {
                    jp = JP_DEF;
                }
                JSCFG = jp + JSCFG_DEF;
                boolean bl = retval = JSC.readJavaSeisConfigFile() == 1;
            }
        }
        if (!retval) {
            JSC.configureJavaSeisByDefault();
            retval = true;
        }
        return retval;
    }

    private static void configureJavaSeisByDefault() {
        PATH = HOME_DEF + "." + DIR;
        DATA = DATA_DEF;
        ROOT = DATA + USER + ROOT_DEF;
        HOSTS = HOSTS_DEF;
        LOC = SCR_DEF + "." + USER + "." + DIR;
    }

    private static int readJavaSeisConfigFile() {
        int retval = 1;
        boolean have_path = false;
        boolean have_data = false;
        boolean have_root = false;
        boolean have_hosts = false;
        boolean have_location = false;
        File file = new File(JSCFG);
        try {
            FileReader in_stream = new FileReader(file);
            BufferedReader in = new BufferedReader(in_stream);
            String line = null;
            line = in.readLine();
            while (line != null) {
                String lc_line = line.toLowerCase();
                int index = lc_line.indexOf("data_home");
                if (index > -1) {
                    DATA = lc_line.substring(index + 9).trim();
                    have_data = true;
                } else {
                    index = lc_line.indexOf("data_root");
                    if (index > -1) {
                        ROOT = lc_line.substring(index + 9).trim();
                        have_root = true;
                    } else {
                        index = lc_line.indexOf("hosts");
                        if (index > -1) {
                            String host_list = lc_line.substring(index + 5).replace(" ", "");
                            int host_count = 0;
                            for (int k2 = 0; k2 < host_list.length(); ++k2) {
                                if (!host_list.substring(k2, k2 + 1).equalsIgnoreCase(",")) continue;
                                ++host_count;
                            }
                            if (host_list.length() > 0) {
                                ++host_count;
                            }
                            if (host_count > 0) {
                                int beg = 0;
                                int end = 0;
                                HOSTS = new String[host_count];
                                int k2 = 0;
                                while ((end = host_list.indexOf(",", beg)) > -1) {
                                    JSC.HOSTS[k2] = host_list.substring(beg, end);
                                    beg = end + 1;
                                    ++k2;
                                }
                                JSC.HOSTS[host_count - 1] = host_list.substring(beg);
                                have_hosts = true;
                            }
                        } else {
                            index = lc_line.indexOf("scratch_dir");
                            if (index > -1) {
                                SCR = lc_line.substring(index + 11).trim();
                                LOC = SCR + "." + USER + "." + DIR;
                                have_location = true;
                            }
                        }
                    }
                }
                line = in.readLine();
            }
            if (have_data && have_root) {
                ROOT = DATA + USER + ROOT;
            }
        }
        catch (FileNotFoundException e) {
            retval = -1;
        }
        catch (IOException e) {
            retval = -2;
        }
        boolean bl = have_path = PATH != null;
        if (have_path && have_root && have_hosts && have_location) {
            retval = 1;
        }
        return retval;
    }

    static {
        HOME = System.getProperty("user.home");
        USER = System.getProperty("user.name");
        POLICY = new ExtentPolicyRandom();
        DIR = "jsdata";
        JSCFILE = "jsconfig.dat";
        JP_DEF = "";
        JSCFG_DEF = File.separator + "test" + File.separator + "data" + File.separator + JSCFILE;
        HOME_DEF = ".tmp." + USER;
        DATA_DEF = ".tmp.";
        ROOT_DEF = "." + DIR + ".exts";
        HOSTS_DEF = new String[]{"01", "02", "03"};
        SCR_DEF = "scratch";
        INITED = JSC.initJavaSeisConfiguration();
    }
}

